/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.yacy.visualization.CircleTool;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class SkylinePlotter
extends RasterPlotter {
    private final SkylineConfig config;
    private final List<SkylineObject> objects;
    private final List<SkylineBeam> beams;
    private final int centerX;
    private final int horizonY;

    public SkylinePlotter(SkylineConfig config) {
        super(config.width, config.height, RasterPlotter.DrawMode.MODE_REPLACE, config.backgroundColor);
        this.config = config.copy();
        this.objects = new ArrayList<SkylineObject>();
        this.beams = new ArrayList<SkylineBeam>();
        this.centerX = this.getWidth() / 2;
        this.horizonY = config.horizonY >= 0 ? config.horizonY : this.getHeight() / 4;
    }

    public SkylineConfig getConfig() {
        return this.config.copy();
    }

    public void clearScene() {
        this.objects.clear();
        this.beams.clear();
    }

    public SkylineObject addBox(double centerX, double centerZ, double width, double depth, double base, double height, long color) {
        SkylineObject object = new SkylineObject(ShapeType.BOX, centerX, centerZ, width, depth, base, height, color);
        this.objects.add(object);
        return object;
    }

    public SkylineObject addSphere(double centerX, double centerZ, double diameter, double base, long color) {
        SkylineObject object = new SkylineObject(ShapeType.SPHERE, centerX, centerZ, diameter, diameter, base, diameter, color);
        this.objects.add(object);
        return object;
    }

    public SkylineObject addPyramid(double centerX, double centerZ, double width, double depth, double base, double height, long color) {
        SkylineObject object = new SkylineObject(ShapeType.PYRAMID, centerX, centerZ, width, depth, base, height, color);
        this.objects.add(object);
        return object;
    }

    public SkylineBeam addBeam(double startX, double startY, double startZ, double endX, double endY, double endZ, long color) {
        SkylineBeam beam = new SkylineBeam(startX, startY, startZ, endX, endY, endZ, color);
        this.beams.add(beam);
        return beam;
    }

    public void renderFrame(int animationFrame) {
        this.clear();
        double animationAngle = (double)(animationFrame % 8) * 45.0;
        this.drawHorizonGrid(animationAngle);
        if (!this.objects.isEmpty()) {
            ArrayList<SkylineObject> sorted = new ArrayList<SkylineObject>(this.objects);
            Collections.sort(sorted, new Comparator<SkylineObject>(){

                @Override
                public int compare(SkylineObject a, SkylineObject b) {
                    return Double.compare(b.sortKey(), a.sortKey());
                }
            });
            for (SkylineObject object : sorted) {
                this.drawObject(object, animationAngle);
            }
        }
        if (!this.beams.isEmpty()) {
            ArrayList<SkylineBeam> sortedBeams = new ArrayList<SkylineBeam>(this.beams);
            Collections.sort(sortedBeams, new Comparator<SkylineBeam>(){

                @Override
                public int compare(SkylineBeam a, SkylineBeam b) {
                    return Double.compare(b.sortKey(), a.sortKey());
                }
            });
            for (SkylineBeam beam : sortedBeams) {
                this.drawBeam(beam, animationAngle);
            }
        }
    }

    private void drawHorizonGrid(double animationAngle) {
        this.setColor(this.config.gridColor);
        int baseIntensity = this.clampIntensity(this.config.gridIntensity);
        int modulation = (int)Math.round(Math.sin(Math.toRadians(animationAngle)) * (double)this.config.gridPulse);
        int intensity = this.clampIntensity(baseIntensity + modulation);
        double halfWidth = this.config.fieldWidth * 0.5;
        double far = this.config.fieldDepth;
        double near = Math.max(this.config.nearPlane, this.config.gridNear);
        double scaleNear = this.config.focalLength / (near + this.config.cameraDepth);
        double scaleFar = this.config.focalLength / (far + this.config.cameraDepth);
        double minXNear = (double)(0 - this.centerX) / scaleNear;
        double maxXNear = (double)(this.getWidth() - 1 - this.centerX) / scaleNear;
        double minXFar = (double)(0 - this.centerX) / scaleFar;
        double maxXFar = (double)(this.getWidth() - 1 - this.centerX) / scaleFar;
        double minX = Math.min(Math.min(-halfWidth, minXNear), minXFar);
        double maxX = Math.max(Math.max(halfWidth, maxXNear), maxXFar);
        double startX = Math.floor(minX / this.config.gridStepX) * this.config.gridStepX;
        double endX = Math.ceil(maxX / this.config.gridStepX) * this.config.gridStepX;
        for (double x = startX; x <= endX + 1.0E-4; x += this.config.gridStepX) {
            this.drawLine3D(x, 0.0, near, x, 0.0, far, intensity, 0, 0.0);
        }
        for (double z = near; z <= far + 1.0E-4; z += this.config.gridStepZ) {
            this.drawLine3D(startX, 0.0, z, endX, 0.0, z, intensity, 0, 0.0);
        }
    }

    private void drawObject(SkylineObject object, double animationAngle) {
        double angle = (animationAngle + object.animationPhase) % 360.0;
        double bobOffset = object.bobAmplitude == 0.0 ? 0.0 : Math.sin(Math.toRadians(angle)) * object.bobAmplitude;
        int baseIntensity = this.clampIntensity(object.intensity + (int)Math.round(Math.sin(Math.toRadians(angle)) * object.pulseAmplitude));
        int edgeIntensity = this.clampIntensity(baseIntensity + 10);
        int topIntensity = this.clampIntensity(baseIntensity + 8);
        int sideIntensity = this.clampIntensity(baseIntensity - 8);
        long mainColor = object.color;
        long edgeColor = object.edgeColor != null ? object.edgeColor : SkylinePlotter.lighten(mainColor, 1.4);
        long highlightColor = object.accentColor != null ? object.accentColor : SkylinePlotter.lighten(mainColor, 1.2);
        long shadowColor = SkylinePlotter.darken(mainColor, 0.75);
        switch (object.shape.ordinal()) {
            case 0: {
                this.drawBox(object, bobOffset, mainColor, highlightColor, shadowColor, edgeColor, baseIntensity, topIntensity, sideIntensity, edgeIntensity, angle);
                break;
            }
            case 1: {
                this.drawSphere(object, bobOffset, mainColor, highlightColor, edgeColor, baseIntensity, edgeIntensity, angle);
                break;
            }
            case 2: {
                this.drawPyramid(object, bobOffset, mainColor, highlightColor, shadowColor, edgeColor, baseIntensity, topIntensity, sideIntensity, edgeIntensity, angle);
                break;
            }
        }
    }

    private void drawBox(SkylineObject object, double bobOffset, long mainColor, long highlightColor, long shadowColor, long edgeColor, int baseIntensity, int topIntensity, int sideIntensity, int edgeIntensity, double animationAngle) {
        double cx = object.centerX;
        double cz = object.centerZ;
        double base = object.baseHeight + bobOffset;
        double h = object.objectHeight;
        double halfW = object.sizeX * 0.5;
        double halfD = object.sizeZ * 0.5;
        double top = base + h;
        Projection topNW = this.project(cx - halfW, top, cz - halfD);
        Projection topNE = this.project(cx + halfW, top, cz - halfD);
        Projection topSE = this.project(cx + halfW, top, cz + halfD);
        Projection topSW = this.project(cx - halfW, top, cz + halfD);
        Projection baseNW = this.project(cx - halfW, base, cz - halfD);
        Projection baseNE = this.project(cx + halfW, base, cz - halfD);
        Projection baseSE = this.project(cx + halfW, base, cz + halfD);
        Projection baseSW = this.project(cx - halfW, base, cz + halfD);
        this.fillPolygon(new int[]{topNW.x, topNE.x, topSE.x, topSW.x}, new int[]{topNW.y, topNE.y, topSE.y, topSW.y}, highlightColor, topIntensity);
        this.fillPolygon(new int[]{baseNW.x, baseNE.x, topNE.x, topNW.x}, new int[]{baseNW.y, baseNE.y, topNE.y, topNW.y}, mainColor, baseIntensity);
        this.fillPolygon(new int[]{baseNE.x, baseSE.x, topSE.x, topNE.x}, new int[]{baseNE.y, baseSE.y, topSE.y, topNE.y}, shadowColor, sideIntensity);
        Projection[] outline = new Projection[]{baseNW, baseNE, baseSE, baseSW, baseNW, topNW, topNE, topSE, topSW, topNW, topSW, baseSW};
        this.setColor(edgeColor);
        for (int i = 0; i < outline.length - 1; ++i) {
            this.drawLineWithPattern(object.patternModulo, object.patternPhase, outline[i], outline[i + 1], edgeIntensity, animationAngle);
        }
        this.drawLabel(object, topNE, animationAngle);
    }

    private void drawSphere(SkylineObject object, double bobOffset, long mainColor, long highlightColor, long edgeColor, int baseIntensity, int edgeIntensity, double animationAngle) {
        double radiusWorld = object.objectHeight * 0.5;
        double centerY = object.baseHeight + bobOffset + radiusWorld;
        Projection center = this.project(object.centerX, centerY, object.centerZ);
        Projection radiusX = this.project(object.centerX + radiusWorld, centerY, object.centerZ);
        int radius = Math.max(1, Math.abs(radiusX.x - center.x));
        this.setColor(mainColor);
        this.dot(center.x, center.y, radius, true, baseIntensity);
        int highlightRadius = Math.max(1, radius / 2);
        this.setColor(highlightColor);
        this.dot(center.x - highlightRadius / 2, center.y - highlightRadius / 2, highlightRadius, true, baseIntensity);
        this.setColor(edgeColor);
        CircleTool.circle(this, center.x, center.y, radius, edgeIntensity);
        this.drawLabel(object, new Projection(center.x, center.y - radius - 6, center.depth), animationAngle);
    }

    private void drawPyramid(SkylineObject object, double bobOffset, long mainColor, long highlightColor, long shadowColor, long edgeColor, int baseIntensity, int highlightIntensity, int shadowIntensity, int edgeIntensity, double animationAngle) {
        double cx = object.centerX;
        double cz = object.centerZ;
        double base = object.baseHeight + bobOffset;
        double h = object.objectHeight;
        double halfW = object.sizeX * 0.5;
        double halfD = object.sizeZ * 0.5;
        double apexY = base + h;
        Projection baseNW = this.project(cx - halfW, base, cz - halfD);
        Projection baseNE = this.project(cx + halfW, base, cz - halfD);
        Projection baseSE = this.project(cx + halfW, base, cz + halfD);
        Projection baseSW = this.project(cx - halfW, base, cz + halfD);
        Projection apex = this.project(cx, apexY, cz);
        this.fillPolygon(new int[]{baseNW.x, baseNE.x, apex.x}, new int[]{baseNW.y, baseNE.y, apex.y}, highlightColor, highlightIntensity);
        this.fillPolygon(new int[]{baseNE.x, baseSE.x, apex.x}, new int[]{baseNE.y, baseSE.y, apex.y}, mainColor, baseIntensity);
        this.fillPolygon(new int[]{baseSE.x, baseSW.x, apex.x}, new int[]{baseSE.y, baseSW.y, apex.y}, shadowColor, shadowIntensity);
        this.setColor(edgeColor);
        Projection[] outline = new Projection[]{baseNW, baseNE, baseSE, baseSW, baseNW, apex, baseNE, apex, baseSE, apex, baseSW};
        for (int i = 0; i < outline.length - 1; ++i) {
            this.drawLineWithPattern(object.patternModulo, object.patternPhase, outline[i], outline[i + 1], edgeIntensity, animationAngle);
        }
        this.drawLabel(object, apex, animationAngle);
    }

    private void drawLabel(SkylineObject object, Projection reference, double animationAngle) {
        if (object.label == null || object.label.length() == 0) {
            return;
        }
        long labelColor = object.labelColor != null ? object.labelColor : (object.accentColor != null ? object.accentColor : object.color);
        this.setColor(labelColor);
        int targetX = reference.x + object.labelOffsetX;
        int targetY = reference.y + object.labelOffsetY;
        PrintTool.print5(this, targetX, targetY, 0, object.label, -1, this.clampIntensity(object.labelIntensity));
    }

    private void drawLineWithPattern(int patternModulo, double patternPhase, Projection start, Projection end, int intensity, double animationAngle) {
        if (patternModulo <= 1) {
            this.line(start.x, start.y, end.x, end.y, intensity);
            return;
        }
        int steps = Math.max(Math.abs(end.x - start.x), Math.abs(end.y - start.y));
        if (steps == 0) {
            this.plot(start.x, start.y, intensity);
            return;
        }
        int offset = (int)Math.round((double)patternModulo * ((patternPhase + animationAngle) % 360.0) / 360.0) % patternModulo;
        for (int i = 0; i <= steps; ++i) {
            int patternIndex = (i + offset) % patternModulo;
            if (patternIndex >= patternModulo / 2) continue;
            double t = (double)i / (double)steps;
            int x = (int)Math.round((double)start.x + (double)(end.x - start.x) * t);
            int y = (int)Math.round((double)start.y + (double)(end.y - start.y) * t);
            this.plot(x, y, intensity);
        }
    }

    private void drawLine3D(double x0, double y0, double z0, double x1, double y1, double z1, int intensity, int patternModulo, double patternPhase) {
        Projection p0 = this.project(x0, y0, z0);
        Projection p1 = this.project(x1, y1, z1);
        if (patternModulo <= 1) {
            this.line(p0.x, p0.y, p1.x, p1.y, intensity);
        } else {
            this.drawLineWithPattern(patternModulo, patternPhase, p0, p1, intensity, 0.0);
        }
    }

    private void drawBeam(SkylineBeam beam, double animationAngle) {
        double phaseAngle = (animationAngle + beam.animationPhase) % 360.0;
        int beamIntensity = this.clampIntensity(beam.intensity + (int)Math.round(Math.sin(Math.toRadians(phaseAngle)) * beam.pulseAmplitude));
        this.setColor(beam.color);
        Projection start = this.project(beam.startX, beam.startY, beam.startZ);
        Projection end = this.project(beam.endX, beam.endY, beam.endZ);
        this.drawLineWithPattern(beam.patternModulo, beam.patternPhase + phaseAngle, start, end, beamIntensity, phaseAngle);
    }

    private Projection project(double x, double y, double z) {
        double denom = Math.max(this.config.nearPlane, z + this.config.cameraDepth);
        double scale = this.config.focalLength / denom;
        int sx = this.centerX + (int)Math.round(x * scale);
        int sy = this.horizonY + (int)Math.round((this.config.groundLevel - y) * scale);
        return new Projection(sx, sy, denom);
    }

    private int clampIntensity(int value) {
        return value < 0 ? 0 : (value > 100 ? 100 : value);
    }

    public static void main(String[] args) {
        File targetDir;
        System.setProperty("java.awt.headless", "true");
        File file = targetDir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                throw new IllegalStateException("Cannot create output directory " + targetDir.getAbsolutePath());
            }
        } else if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException("Output path is not a directory: " + targetDir.getAbsolutePath());
        }
        SkylineConfig config = new SkylineConfig();
        config.width = 640;
        config.height = 360;
        config.backgroundColor = 17L;
        config.gridColor = 65535L;
        config.gridIntensity = 36;
        config.gridPulse = 12;
        config.gridStepX = 26.0;
        config.gridStepZ = 36.0;
        config.fieldWidth = 420.0;
        config.fieldDepth = 640.0;
        config.focalLength = 560.0;
        config.cameraDepth = 140.0;
        config.groundLevel = 210.0;
        config.horizonY = 110;
        SkylinePlotter skyline = new SkylinePlotter(config);
        skyline.addBox(-160.0, 220.0, 120.0, 110.0, 10.0, 130.0, 30719L).accent(0x55FFFFL).edges(0xFFFFFFL).intensity(85).bob(14.0).pulse(14.0).dotted(6).patternPhase(90.0).label("DATA CORE", -40, -18);
        skyline.addBox(150.0, 260.0, 90.0, 90.0, 0.0, 80.0, 0x3A00AAL).accent(0xAA66FFL).edges(0xFFD6FFL).intensity(75).bob(6.0).pulse(10.0).dotted(8).patternPhase(0.0).label("NODE CLUSTER", -44, -14);
        skyline.addSphere(40.0, 320.0, 120.0, 6.0, 0xFF3366L).accent(0xFF88AAL).intensity(70).bob(18.0).pulse(16.0).animationPhase(180.0).label("ORBITAL CACHE", -52, -22);
        skyline.addPyramid(-20.0, 420.0, 150.0, 150.0, 0.0, 160.0, 0xFFAA33L).accent(16765567L).edges(16769184L).intensity(82).pulse(8.0).animationPhase(45.0).label("SIGNAL SPIRE", -48, -20);
        skyline.addBox(0.0, 540.0, 420.0, 60.0, -18.0, 12.0, 17493L).edges(0x33AADDL).intensity(52).dotted(4).label("RUNWAY 12", -32, 18).labelIntensity(70);
        for (int frame = 0; frame < 8; ++frame) {
            skyline.renderFrame(frame);
            File outFile = new File(targetDir, String.format("skyline_demo_%02d.png", frame));
            try {
                skyline.save(outFile, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write demo frame " + outFile.getAbsolutePath(), e);
            }
        }
    }

    public static class SkylineConfig {
        public int width;
        public int height;
        public long backgroundColor;
        public long gridColor = 52428L;
        public int gridIntensity = 35;
        public int gridPulse = 8;
        public double gridStepX = 30.0;
        public double gridStepZ = 40.0;
        public double gridNear = 6.0;
        public double fieldWidth = 400.0;
        public double fieldDepth = 600.0;
        public double focalLength = 520.0;
        public double cameraDepth = 160.0;
        public double groundLevel = 220.0;
        public double nearPlane = 4.0;
        public int horizonY = -1;

        private SkylineConfig copy() {
            SkylineConfig clone = new SkylineConfig();
            clone.width = this.width;
            clone.height = this.height;
            clone.backgroundColor = this.backgroundColor;
            clone.gridColor = this.gridColor;
            clone.gridIntensity = this.gridIntensity;
            clone.gridPulse = this.gridPulse;
            clone.gridStepX = this.gridStepX;
            clone.gridStepZ = this.gridStepZ;
            clone.gridNear = this.gridNear;
            clone.fieldWidth = this.fieldWidth;
            clone.fieldDepth = this.fieldDepth;
            clone.focalLength = this.focalLength;
            clone.cameraDepth = this.cameraDepth;
            clone.groundLevel = this.groundLevel;
            clone.nearPlane = this.nearPlane;
            clone.horizonY = this.horizonY;
            return clone;
        }
    }

    public static class SkylineObject {
        private final ShapeType shape;
        private final double centerX;
        private final double centerZ;
        private final double sizeX;
        private final double sizeZ;
        private final double baseHeight;
        private final double objectHeight;
        private final long color;
        private Long accentColor;
        private Long edgeColor;
        private int intensity = 80;
        private double bobAmplitude = 0.0;
        private double pulseAmplitude = 0.0;
        private int patternModulo = 0;
        private double patternPhase = 0.0;
        private String label;
        private int labelOffsetX = 0;
        private int labelOffsetY = -12;
        private int labelIntensity = 100;
        private Long labelColor;
        private double animationPhase = 0.0;

        public SkylineObject(ShapeType shape, double centerX, double centerZ, double sizeX, double sizeZ, double baseHeight, double objectHeight, long color) {
            this.shape = shape;
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.sizeX = sizeX;
            this.sizeZ = sizeZ;
            this.baseHeight = baseHeight;
            this.objectHeight = objectHeight;
            this.color = color;
        }

        private double sortKey() {
            return this.centerZ + this.objectHeight;
        }

        public SkylineObject accent(long accentColor) {
            this.accentColor = accentColor;
            return this;
        }

        public SkylineObject edges(long edgeColor) {
            this.edgeColor = edgeColor;
            return this;
        }

        public SkylineObject intensity(int intensity) {
            this.intensity = intensity;
            return this;
        }

        public SkylineObject bob(double amplitude) {
            this.bobAmplitude = amplitude;
            return this;
        }

        public SkylineObject pulse(double amplitude) {
            this.pulseAmplitude = amplitude;
            return this;
        }

        public SkylineObject dotted(int modulo) {
            this.patternModulo = Math.max(0, modulo);
            return this;
        }

        public SkylineObject patternPhase(double phaseDegrees) {
            this.patternPhase = phaseDegrees;
            return this;
        }

        public SkylineObject animationPhase(double phaseDegrees) {
            this.animationPhase = phaseDegrees;
            return this;
        }

        public SkylineObject label(String text) {
            this.label = text;
            return this;
        }

        public SkylineObject label(String text, int offsetX, int offsetY) {
            this.label = text;
            this.labelOffsetX = offsetX;
            this.labelOffsetY = offsetY;
            return this;
        }

        public SkylineObject labelColor(long color) {
            this.labelColor = color;
            return this;
        }

        public SkylineObject labelIntensity(int intensity) {
            this.labelIntensity = intensity;
            return this;
        }
    }

    public static enum ShapeType {
        BOX,
        SPHERE,
        PYRAMID,
        POLYLINE;

    }

    public static final class SkylineBeam {
        private final double startX;
        private final double startY;
        private final double startZ;
        private final double endX;
        private final double endY;
        private final double endZ;
        private final long color;
        private int intensity = 80;
        private int patternModulo = 0;
        private double patternPhase = 0.0;
        private double animationPhase = 0.0;
        private double pulseAmplitude = 0.0;

        private SkylineBeam(double startX, double startY, double startZ, double endX, double endY, double endZ, long color) {
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.endX = endX;
            this.endY = endY;
            this.endZ = endZ;
            this.color = color;
        }

        private double sortKey() {
            return (this.startZ + this.endZ) * 0.5;
        }

        public SkylineBeam intensity(int value) {
            this.intensity = value;
            return this;
        }

        public SkylineBeam dotted(int modulo) {
            this.patternModulo = Math.max(0, modulo);
            return this;
        }

        public SkylineBeam patternPhase(double phaseDegrees) {
            this.patternPhase = phaseDegrees;
            return this;
        }

        public SkylineBeam animationPhase(double phaseDegrees) {
            this.animationPhase = phaseDegrees;
            return this;
        }

        public SkylineBeam pulse(double amplitude) {
            this.pulseAmplitude = amplitude;
            return this;
        }
    }

    public static final class Projection {
        private final int x;
        private final int y;
        private final double depth;

        public Projection(int x, int y, double depth) {
            this.x = x;
            this.y = y;
            this.depth = depth;
        }
    }
}

