/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class PixelTrendMatrixPlotter
extends RasterPlotter {
    private final int rows;
    private final int cols;
    private final double[][] data;
    private final Random random;

    public PixelTrendMatrixPlotter(int width, int height, int rows, int cols) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 18L);
        this.rows = rows;
        this.cols = cols;
        this.random = new Random(195936478L);
        this.data = new double[rows * cols][16];
        for (int i = 0; i < this.data.length; ++i) {
            double value = this.random.nextDouble();
            for (int j = 0; j < this.data[i].length; ++j) {
                value += (this.random.nextDouble() - 0.5) * 0.25;
                this.data[i][j] = value = Math.min(Math.max(value, 0.05), 0.95);
            }
        }
    }

    public void renderMatrix(double wobble) {
        this.clear();
        this.drawGrid();
        int cellWidth = this.getWidth() / this.cols;
        int cellHeight = this.getHeight() / this.rows;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                int index2 = row * this.cols + col;
                int x0 = col * cellWidth;
                int y0 = row * cellHeight;
                this.drawCell(x0, y0, cellWidth, cellHeight, this.data[index2], ((double)index2 + wobble) % 1.0);
            }
        }
    }

    private void drawGrid() {
        this.setColor(6707L);
        for (int y = 0; y < this.getHeight(); y += 8) {
            this.line(0, y, this.getWidth(), y, 15);
        }
        for (int x = 0; x < this.getWidth(); x += 8) {
            this.line(x, 0, x, this.getHeight(), 15);
        }
    }

    private void drawCell(int x0, int y0, int width, int height, double[] values, double wobble) {
        int y;
        int x;
        int i;
        this.setColor(11332L);
        for (int y2 = y0; y2 < y0 + height; ++y2) {
            this.line(x0, y2, x0 + width, y2, 20);
        }
        int padding = 6;
        int innerWidth = width - 12;
        int innerHeight = height - 12 - 14;
        int chartLeft = x0 + 6;
        int chartTop = y0 + 6 + 12;
        long baselineColor = 16239 + ((int)(wobble * 4.0) << 16);
        this.setColor(baselineColor);
        this.line(chartLeft, chartTop + innerHeight / 2, chartLeft + innerWidth, chartTop + innerHeight / 2, 35);
        this.setColor(65450L);
        int points = values.length;
        int prevX = chartLeft;
        int prevY = chartTop + (int)((double)innerHeight * (1.0 - values[0]));
        for (i = 1; i < points; ++i) {
            x = chartLeft + i * innerWidth / (points - 1);
            y = chartTop + (int)((double)innerHeight * (1.0 - values[i])) + (int)(Math.sin((wobble + (double)i) * 0.6) * 2.0);
            this.line(prevX, prevY, x, y, 70);
            prevX = x;
            prevY = y;
        }
        this.setColor(65535L);
        for (i = 0; i < points; i += 3) {
            x = chartLeft + i * innerWidth / (points - 1);
            y = chartTop + (int)((double)innerHeight * (1.0 - values[i]));
            this.dot(x, y, 2, true, 80);
        }
        this.setColor(0x66FFDDL);
        PrintTool.print5(this, x0 + width / 2, y0 + 10, 0, this.labelForCell(values), 0, 70);
    }

    private String labelForCell(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double v : values) {
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        int trend = (int)((values[values.length - 1] - values[0]) * 100.0);
        return String.format("%+d%%  [%02d:%02d]", trend, (int)(min * 100.0), (int)(max * 100.0));
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PixelTrendMatrixPlotter plotter = new PixelTrendMatrixPlotter(640, 400, 3, 4);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderMatrix((double)frame / 8.0);
            File out = new File(dir, String.format("trend_matrix_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save matrix frame", e);
            }
        }
    }
}

