/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class DotMatrixWaterfallPlotter
extends RasterPlotter {
    private final double[] steps;
    private final String[] labels;
    private final long positiveColor = 0x66FF99L;
    private final long negativeColor = 0xFF7777L;
    private final long totalColor = 65535L;

    public DotMatrixWaterfallPlotter(int width, int height, double[] steps, String[] labels) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 263172L);
        this.steps = steps;
        this.labels = labels;
    }

    public void render() {
        this.clear();
        this.drawPaperFeed();
        double cumulative = 0.0;
        int baseX = 80;
        int baseline = this.getHeight() - 80;
        int stepWidth = (this.getWidth() - 80 - 40) / this.steps.length;
        for (int i = 0; i < this.steps.length; ++i) {
            boolean isTotal;
            double step = this.steps[i];
            boolean bl = isTotal = i == this.steps.length - 1;
            long color = isTotal ? 65535L : (step >= 0.0 ? 0x66FF99L : 0xFF7777L);
            double previous = cumulative;
            double top = Math.max(previous, cumulative += step);
            double bottom = Math.min(previous, cumulative);
            int left = 80 + i * stepWidth;
            int right = left + stepWidth - 20;
            this.fillDots(left, right, baseline - (int)(top * 3.0), baseline - (int)(bottom * 3.0), color, isTotal);
            this.drawStepLabel(left, baseline, this.labels[i], step, color);
            if (i >= this.steps.length - 1) continue;
            this.setColor(13107L);
            this.line(right + 4, baseline - (int)(cumulative * 3.0), right + stepWidth - 4, baseline - (int)(cumulative * 3.0), 25);
        }
        this.drawAxes();
    }

    private void drawPaperFeed() {
        this.setColor(0x1A1A1AL);
        for (int y = 0; y < this.getHeight(); y += 16) {
            this.line(0, y, this.getWidth(), y, 18);
        }
        this.setColor(0x202020L);
        for (int x = 0; x < this.getWidth(); x += 12) {
            this.dot(x, 12, 1, true, 40);
            this.dot(x, this.getHeight() - 12, 1, true, 40);
        }
    }

    private void fillDots(int left, int right, int top, int bottom, long color, boolean heavy) {
        int spacing = heavy ? 3 : 4;
        for (int y = top; y <= bottom; y += spacing) {
            for (int x = left; x <= right; x += spacing) {
                this.setColor(color);
                this.dot(x, y, heavy ? 2 : 1, true, heavy ? 90 : 70);
            }
        }
        this.setColor(DotMatrixWaterfallPlotter.darken(color, 0.5));
        this.line(left, top, right, top, 60);
        this.line(left, bottom, right, bottom, 60);
        this.line(left, top, left, bottom, 60);
        this.line(right, top, right, bottom, 60);
    }

    private void drawStepLabel(int left, int baseline, String label, double value, long color) {
        this.setColor(color);
        PrintTool.print5(this, left + 2, baseline + 14, 0, label, -1, 70);
        PrintTool.print5(this, left + 2, baseline + 24, 0, String.format("%+.1f", value), -1, 60);
    }

    private void drawAxes() {
        int baseline = this.getHeight() - 80;
        this.setColor(21845L);
        this.line(60, baseline, this.getWidth() - 20, baseline, 40);
        this.line(60, baseline, 60, 60, 40);
        for (int i = 0; i <= 6; ++i) {
            int y = baseline - i * 30;
            this.line(60, y, this.getWidth() - 20, y, 20);
            PrintTool.print5(this, 42, y, 0, String.format("%+d", i * 10), -1, 50);
        }
        this.setColor(65535L);
        PrintTool.print5(this, this.getWidth() / 2, 30, 0, "WATERFALL LEDGER", 0, 85);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        double[] steps = new double[]{40.0, 18.0, -12.0, 22.0, -15.0, 30.0};
        String[] labels = new String[]{"BASE", "SALES", "RETURNS", "SERVICE", "LOSS", "TOTAL"};
        DotMatrixWaterfallPlotter plotter = new DotMatrixWaterfallPlotter(640, 360, steps, labels);
        plotter.render();
        File out = new File(dir, "dot_matrix_waterfall.png");
        try {
            plotter.save(out, "png");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write waterfall image", e);
        }
    }
}

