/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.utils.translation.TranslationManager;

public class GenerateMasterXliff {
    public static void main(String[] args) throws IOException {
        try {
            File localesFolder = args.length > 0 && args[0] != null ? new File(args[0]) : new File("locales");
            if (!localesFolder.isDirectory()) {
                System.err.println(localesFolder.getPath() + " is not a directory");
                return;
            }
            System.out.println("Using lng files from folder " + localesFolder.getAbsolutePath());
            File masterXlf = args.length > 1 && args[1] != null ? new File(args[1]) : new File("master.lng.xlf");
            if (masterXlf.exists()) {
                System.out.println("Updating master xliff file at " + masterXlf.getAbsolutePath());
            } else {
                System.out.println("Generating a new master xliff file at " + masterXlf.getAbsolutePath());
            }
            new TranslationManager().createMasterTranslationLists(localesFolder, masterXlf);
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }
}

