/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.YaCyHttpServer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.peers.Seed;
import net.yacy.server.serverAccessTracker;

public class serverSwitch {
    private final File configFile;
    private final String configComment;
    public final File dataPath;
    public final File appPath;
    protected boolean firstInit;
    public ConcurrentLog log;
    protected int serverJobs;
    private ConcurrentMap<String, String> configProps;
    private final ConcurrentMap<String, String> configRemoved;
    private final NavigableMap<String, BusyThread> workerThreads;
    private YaCyHttpServer httpserver;
    private final ConcurrentMap<String, Integer> upnpPortMap = new ConcurrentHashMap<String, Integer>();
    private boolean isConnectedViaUpnp;

    public serverSwitch(File dataPath, File appPath, String initPath, String configPath) {
        String key2;
        String yacykey;
        this.dataPath = dataPath;
        this.appPath = appPath;
        this.configComment = "This is an automatically generated file, updated by serverAbstractSwitch and initialized by " + initPath;
        File initFile = new File(appPath, initPath);
        this.configFile = new File(dataPath, configPath);
        this.firstInit = !this.configFile.exists();
        new File(this.configFile.getParent()).mkdir();
        ConcurrentHashMap<String, String> initProps = initFile.exists() ? FileUtils.loadMap(initFile) : new ConcurrentHashMap();
        this.configProps = this.configFile.exists() ? FileUtils.loadMap(this.configFile) : new ConcurrentHashMap<String, String>();
        Properties sysprops = System.getProperties();
        sysprops.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String k = (String)key;
            if (k.startsWith("yacy.")) {
                this.configProps.put(k.substring(5), (String)value);
            }
        }));
        this.configRemoved = new ConcurrentHashMap<String, String>();
        Iterator i = this.configProps.keySet().iterator();
        while (i.hasNext()) {
            String key22 = (String)i.next();
            if (initProps.containsKey(key22)) continue;
            this.configRemoved.put(key22, (String)this.configProps.get(key22));
            i.remove();
        }
        initProps.putAll(this.configProps);
        this.configProps = initProps;
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            yacykey = (String)entry2.getKey();
            if (!yacykey.startsWith("YACY_") || !this.configProps.containsKey(key2 = yacykey.substring(5).toLowerCase().replace('_', '.'))) continue;
            this.configProps.put(key2, (String)entry2.getValue());
        }
        for (Map.Entry<Object, Object> entry3 : System.getenv().entrySet()) {
            yacykey = (String)entry3.getKey();
            if (!yacykey.startsWith("YACY_") || !this.configProps.containsKey(key2 = yacykey.substring(5).toLowerCase().replace('_', '.'))) continue;
            this.configProps.put(key2, (String)entry3.getValue());
        }
        this.saveConfig();
        this.workerThreads = new TreeMap<String, BusyThread>();
        serverAccessTracker.init(this.getConfigLong("server.maxTrackingTime", 3600000L), (int)this.getConfigLong("server.maxTrackingCount", 1000L), (int)this.getConfigLong("server.maxTrackingHostCount", 100L));
    }

    public String myPublicIP() {
        String staticIP = this.getConfig("staticIP", "");
        if (staticIP.length() > 0) {
            return staticIP;
        }
        InetAddress pLIP = Domains.myPublicLocalIP();
        if (pLIP != null) {
            return pLIP.getHostAddress();
        }
        return null;
    }

    public Set<String> myPublicIPs() {
        String s;
        String staticIP = this.getConfig("staticIP", "");
        if (staticIP.length() > 0) {
            HashSet<String> h = new HashSet<String>();
            h.add(staticIP);
            return h;
        }
        LinkedHashSet<String> h = new LinkedHashSet<String>();
        for (InetAddress i : Domains.myPublicIPv6()) {
            s = i.getHostAddress();
            if (!Seed.isProperIP(s)) continue;
            h.add(Domains.chopZoneID(s));
        }
        for (InetAddress i : Domains.myPublicIPv4()) {
            s = i.getHostAddress();
            if (!Seed.isProperIP(s)) continue;
            h.add(Domains.chopZoneID(s));
        }
        return h;
    }

    public int getPublicPort(String key, int dflt) {
        if (this.isConnectedViaUpnp && this.upnpPortMap.containsKey(key)) {
            return (Integer)this.upnpPortMap.get(key);
        }
        return this.getConfigInt(key, dflt);
    }

    public int getLocalPort() {
        return this.getConfigInt("port", 8090);
    }

    public String getLocalHost() {
        return this.getConfig("host", "0.0.0.0");
    }

    public void setLog(ConcurrentLog log) {
        this.log = log;
    }

    public ConcurrentLog getLog() {
        return this.log;
    }

    public void setConfig(Map<String, String> otherConfigs) {
        for (Map.Entry<String, String> entry2 : otherConfigs.entrySet()) {
            this.setConfig(entry2.getKey(), entry2.getValue());
        }
    }

    public void setConfig(String key, boolean value) {
        this.setConfig(key, value ? "true" : "false");
    }

    public void setConfig(String key, long value) {
        this.setConfig(key, Long.toString(value));
    }

    public void setConfig(String key, float value) {
        this.setConfig(key, Float.toString(value));
    }

    public void setConfig(String key, double value) {
        this.setConfig(key, Double.toString(value));
    }

    public void setConfig(String key, String value) {
        String oldValue = this.configProps.put(key, value);
        if (oldValue == null || !value.equals(oldValue)) {
            this.saveConfig();
        }
    }

    public void setConfig(String key, String[] value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            for (String s : value) {
                sb.append(',').append(s);
            }
        }
        this.setConfig(key, sb.length() > 0 ? sb.substring(1) : "");
    }

    public void setConfig(String key, Set<String> value) {
        String[] a = new String[value.size()];
        int c = 0;
        for (String s : value) {
            a[c++] = s;
        }
        this.setConfig(key, a);
    }

    public void removeConfig(String key) {
        this.configProps.remove(key);
    }

    public String getConfig(String key, String dflt) {
        String s = (String)this.configProps.get(key);
        if (s == null) {
            return dflt;
        }
        return s;
    }

    public long getConfigLong(String key, long dflt) {
        try {
            return Long.parseLong(this.getConfig(key, Long.toString(dflt)));
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public float getConfigFloat(String key, float dflt) {
        try {
            return Float.parseFloat(this.getConfig(key, Float.toString(dflt)));
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean isConnectedViaUpnp() {
        return this.isConnectedViaUpnp;
    }

    public void setConnectedViaUpnp(boolean isConnectedViaUpnp) {
        this.isConnectedViaUpnp = isConnectedViaUpnp;
        if (!isConnectedViaUpnp) {
            this.upnpPortMap.clear();
        }
    }

    public void setUpnpPorts(String key, int port) {
        this.upnpPortMap.put(key, port);
    }

    public void removeUpnpPort(String key) {
        this.upnpPortMap.remove(key);
    }

    public int getConfigInt(String key, int dflt) {
        try {
            return Integer.parseInt(this.getConfig(key, Integer.toString(dflt)));
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean getConfigBool(String key, boolean dflt) {
        return Boolean.parseBoolean(this.getConfig(key, Boolean.toString(dflt)));
    }

    public String[] getConfigArray(String key, String dflt) {
        return CommonPattern.COMMA.split(this.getConfig(key, dflt));
    }

    public Set<String> getConfigSet(String key) {
        LinkedHashSet<String> h = new LinkedHashSet<String>();
        for (String s : this.getConfigArray(key, "")) {
            if ((s = s.trim()).length() <= 0) continue;
            h.add(s.trim());
        }
        return h;
    }

    public File getDataPath(String key, String dflt) {
        return this.getFileByPath(key, dflt, this.dataPath);
    }

    public File getAppPath(String key, String dflt) {
        return this.getFileByPath(key, dflt, this.appPath);
    }

    private File getFileByPath(String key, String dflt, File prefix) {
        String path = this.getConfig(key, dflt).replace('\\', '/');
        File f = new File(path);
        return f.isAbsolute() ? new File(f.getAbsolutePath()) : new File(prefix, path);
    }

    public Iterator<String> configKeys() {
        return this.configProps.keySet().iterator();
    }

    private void saveConfig() {
        ConcurrentHashMap<String, String> configPropsCopy = new ConcurrentHashMap<String, String>(this.configProps);
        FileUtils.saveMap(this.configFile, configPropsCopy, this.configComment);
    }

    public ConcurrentMap<String, String> getRemoved() {
        return this.configRemoved;
    }

    public Properties loadDefaultConfig() {
        Properties config = new Properties();
        try (FileInputStream fis = new FileInputStream(new File(this.appPath, "defaults/yacy.init"));){
            config.load(fis);
        }
        catch (FileNotFoundException e) {
            this.log.severe("Could not find default configuration file defaults/yacy.init.");
        }
        catch (IOException | IllegalArgumentException e) {
            this.log.severe("Could not read configuration file.");
        }
        return config;
    }

    public void deployThread(String threadName, String threadShortDescription, String threadLongDescription, String threadMonitorURL, BusyThread newThread, long startupDelay) {
        this.deployThread(threadName, threadShortDescription, threadLongDescription, threadMonitorURL, newThread, startupDelay, Long.parseLong(this.getConfig(threadName + "_idlesleep", "1000")), Long.parseLong(this.getConfig(threadName + "_busysleep", "100")), Long.parseLong(this.getConfig(threadName + "_memprereq", "1048576")), Double.parseDouble(this.getConfig(threadName + "_loadprereq", "9.0")));
    }

    public void deployThread(String threadName, String threadShortDescription, String threadLongDescription, String threadMonitorURL, BusyThread newThread, long startupDelay, long initialIdleSleep, long initialBusySleep, long initialMemoryPreRequisite, double initialLoadPreRequisite) {
        long x;
        if (newThread.isAlive()) {
            throw new RuntimeException("undeployed threads must not live; they are started as part of the deployment");
        }
        newThread.setStartupSleep(startupDelay);
        try {
            x = Long.parseLong(this.getConfig(threadName + "_idlesleep", "novalue"));
            newThread.setIdleSleep(x);
        }
        catch (NumberFormatException e) {
            newThread.setIdleSleep(initialIdleSleep);
            this.setConfig(threadName + "_idlesleep", initialIdleSleep);
        }
        try {
            x = Long.parseLong(this.getConfig(threadName + "_busysleep", "novalue"));
            newThread.setBusySleep(x);
        }
        catch (NumberFormatException e) {
            newThread.setBusySleep(initialBusySleep);
            this.setConfig(threadName + "_busysleep", initialBusySleep);
        }
        try {
            x = Long.parseLong(this.getConfig(threadName + "_memprereq", "novalue"));
            newThread.setMemPreReqisite(x);
        }
        catch (NumberFormatException e) {
            newThread.setMemPreReqisite(initialMemoryPreRequisite);
            this.setConfig(threadName + "_memprereq", initialMemoryPreRequisite);
        }
        try {
            double load = Double.parseDouble(this.getConfig(threadName + "_loadprereq", "novalue"));
            newThread.setLoadPreReqisite(load);
        }
        catch (NumberFormatException e) {
            newThread.setLoadPreReqisite(initialLoadPreRequisite);
            this.setConfig(threadName + "_loadprereq", (float)initialLoadPreRequisite);
        }
        newThread.setDescription(threadShortDescription, threadLongDescription, threadMonitorURL);
        this.workerThreads.put(threadName, newThread);
        if (this.workerThreads.containsKey(threadName)) {
            newThread.start();
        }
    }

    public BusyThread getThread(String threadName) {
        return (BusyThread)this.workerThreads.get(threadName);
    }

    public void setThreadPerformance(String threadName, long idleMillis, long busyMillis, long memprereqBytes, double loadprereq) {
        BusyThread thread = (BusyThread)this.workerThreads.get(threadName);
        if (thread != null) {
            this.setConfig(threadName + "_idlesleep", thread.setIdleSleep(idleMillis));
            this.setConfig(threadName + "_busysleep", thread.setBusySleep(busyMillis));
            this.setConfig(threadName + "_memprereq", memprereqBytes);
            thread.setMemPreReqisite(memprereqBytes);
            this.setConfig(threadName + "_loadprereq", (float)loadprereq);
            thread.setLoadPreReqisite(loadprereq);
        }
    }

    public synchronized void terminateThread(String threadName, boolean waitFor) {
        if (this.workerThreads.containsKey(threadName)) {
            ((BusyThread)this.workerThreads.get(threadName)).terminate(waitFor);
            this.workerThreads.remove(threadName);
        }
    }

    public void intermissionAllThreads(long pause) {
        Iterator e = this.workerThreads.keySet().iterator();
        while (e.hasNext()) {
            ((BusyThread)this.workerThreads.get(e.next())).intermission(pause);
        }
    }

    public synchronized void terminateAllThreads(boolean waitFor) {
        Iterator e = this.workerThreads.keySet().iterator();
        while (e.hasNext()) {
            ((BusyThread)this.workerThreads.get(e.next())).terminate(false);
        }
        if (waitFor) {
            e = this.workerThreads.keySet().iterator();
            while (e.hasNext()) {
                ((BusyThread)this.workerThreads.get(e.next())).terminate(true);
                e.remove();
            }
        }
    }

    public Iterator<String> threadNames() {
        return this.workerThreads.keySet().iterator();
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public File getAppPath() {
        return this.appPath;
    }

    public String toString() {
        return this.configProps.toString();
    }

    public void handleBusyState(int jobs) {
        this.serverJobs = jobs;
    }

    public Reader getConfigFileFromWebOrLocally(String uri, String rootPath, File file) throws IOException, FileNotFoundException {
        File f;
        if (uri.startsWith("http://") || uri.startsWith("https://")) {
            String[] uris;
            for (String netdef : uris = CommonPattern.COMMA.split(uri)) {
                HTTPClient client;
                block18: {
                    InputStreamReader inputStreamReader;
                    netdef = netdef.trim();
                    client = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);
                    RequestHeader reqHeader = new RequestHeader();
                    reqHeader.put("User-Agent", ClientIdentification.yacyInternetCrawlerAgent.userAgent());
                    client.setHeader(reqHeader.entrySet());
                    byte[] data = client.GETbytes(uri, this.getConfig("adminAccountUserName", "admin"), this.getConfig("adminAccountBase64MD5", ""), false);
                    if (data == null || data.length == 0) break block18;
                    try {
                        if (file != null) {
                            try (FileOutputStream f2 = new FileOutputStream(file);){
                                f2.write(data);
                            }
                        }
                        inputStreamReader = new InputStreamReader(new BufferedInputStream(new ByteArrayInputStream(data)));
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    client.close();
                    return inputStreamReader;
                }
                client.close();
            }
            if (file != null && file.exists()) {
                return new FileReader(file);
            }
            throw new FileNotFoundException();
        }
        File file2 = f = uri.length() > 0 && uri.startsWith("/") ? new File(uri) : new File(rootPath, uri);
        if (f.exists()) {
            return new FileReader(f);
        }
        throw new FileNotFoundException(f.toString());
    }

    public void setHttpServer(YaCyHttpServer jettyserver) {
        this.httpserver = jettyserver;
    }

    public YaCyHttpServer getHttpServer() {
        return this.httpserver;
    }
}

