/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import net.yacy.cora.util.CommonPattern;
import net.yacy.server.serverSwitch;

public final class RobotsTxtConfig {
    public static final String WIKI = "wiki";
    public static final String BLOG = "blog";
    public static final String BOOKMARKS = "bookmarks";
    public static final String HOMEPAGE = "homepage";
    public static final String FILESHARE = "fileshare";
    public static final String SURFTIPS = "surftips";
    public static final String NEWS = "news";
    public static final String STATUS = "status";
    public static final String LOCKED = "locked";
    public static final String DIRS = "dirs";
    public static final String NETWORK = "network";
    public static final String PROFILE = "profile";
    public static final String ALL = "all";
    private boolean allDisallowed = false;
    private boolean lockedDisallowed = true;
    private boolean dirsDisallowed = true;
    private boolean wikiDisallowed = false;
    private boolean blogDisallowed = false;
    private boolean fileshareDisallowed = false;
    private boolean homepageDisallowed = false;
    private boolean newsDisallowed = false;
    private boolean statusDisallowed = false;
    private boolean networkDisallowed = false;
    private boolean surftipsDisallowed = false;
    private boolean bookmarksDisallowed = false;
    private boolean profileDisallowed = true;

    public RobotsTxtConfig() {
    }

    public RobotsTxtConfig(String[] active) {
        if (active == null) {
            return;
        }
        for (int i = 0; i < active.length; ++i) {
            if (active[i] == null) continue;
            if (active[i].equals(BLOG)) {
                this.blogDisallowed = true;
                continue;
            }
            if (active[i].equals(WIKI)) {
                this.wikiDisallowed = true;
                continue;
            }
            if (active[i].equals(BOOKMARKS)) {
                this.bookmarksDisallowed = true;
                continue;
            }
            if (active[i].equals(HOMEPAGE)) {
                this.homepageDisallowed = true;
                continue;
            }
            if (active[i].equals(FILESHARE)) {
                this.fileshareDisallowed = true;
                continue;
            }
            if (active[i].equals(SURFTIPS)) {
                this.surftipsDisallowed = true;
                continue;
            }
            if (active[i].equals(NEWS)) {
                this.newsDisallowed = true;
                continue;
            }
            if (active[i].equals(STATUS)) {
                this.statusDisallowed = true;
                continue;
            }
            if (active[i].equals(NETWORK)) {
                this.networkDisallowed = true;
                continue;
            }
            if (active[i].equals(LOCKED)) {
                this.lockedDisallowed = true;
                continue;
            }
            if (active[i].equals(DIRS)) {
                this.dirsDisallowed = true;
                continue;
            }
            if (active[i].equals(PROFILE)) {
                this.profileDisallowed = true;
                continue;
            }
            if (!active[i].equals(ALL)) continue;
            this.allDisallowed = true;
        }
    }

    public static RobotsTxtConfig init(serverSwitch env) {
        String cfg = env.getConfig("httpd.robots.txt", "locked,dirs");
        if (cfg == null) {
            return new RobotsTxtConfig();
        }
        return new RobotsTxtConfig(CommonPattern.COMMA.split(cfg));
    }

    public String toString() {
        if (this.allDisallowed) {
            return ALL;
        }
        StringBuilder sb = new StringBuilder(200);
        if (this.blogDisallowed) {
            sb.append(BLOG).append(",");
        }
        if (this.bookmarksDisallowed) {
            sb.append(BOOKMARKS).append(",");
        }
        if (this.dirsDisallowed) {
            sb.append(DIRS).append(",");
        }
        if (this.fileshareDisallowed) {
            sb.append(FILESHARE).append(",");
        }
        if (this.homepageDisallowed) {
            sb.append(HOMEPAGE).append(",");
        }
        if (this.lockedDisallowed) {
            sb.append(LOCKED).append(",");
        }
        if (this.networkDisallowed) {
            sb.append(NETWORK).append(",");
        }
        if (this.newsDisallowed) {
            sb.append(NEWS).append(",");
        }
        if (this.statusDisallowed) {
            sb.append(STATUS).append(",");
        }
        if (this.surftipsDisallowed) {
            sb.append(SURFTIPS).append(",");
        }
        if (this.wikiDisallowed) {
            sb.append(WIKI).append(",");
        }
        if (this.profileDisallowed) {
            sb.append(PROFILE).append(",");
        }
        return sb.toString();
    }

    public boolean isAllDisallowed() {
        return this.allDisallowed;
    }

    public void setAllDisallowed(boolean allDisallowed) {
        this.allDisallowed = allDisallowed;
    }

    public boolean isLockedDisallowed() {
        return this.lockedDisallowed || this.allDisallowed;
    }

    public void setLockedDisallowed(boolean lockedDisallowed) {
        this.lockedDisallowed = lockedDisallowed;
    }

    public boolean isDirsDisallowed() {
        return this.dirsDisallowed || this.allDisallowed;
    }

    public void setDirsDisallowed(boolean dirsDisallowed) {
        this.dirsDisallowed = dirsDisallowed;
    }

    public boolean isBlogDisallowed() {
        return this.blogDisallowed || this.allDisallowed;
    }

    public void setBlogDisallowed(boolean blogDisallowed) {
        this.blogDisallowed = blogDisallowed;
    }

    public boolean isBookmarksDisallowed() {
        return this.bookmarksDisallowed || this.allDisallowed;
    }

    public void setBookmarksDisallowed(boolean bookmarksDisallowed) {
        this.bookmarksDisallowed = bookmarksDisallowed;
    }

    public boolean isFileshareDisallowed() {
        return this.fileshareDisallowed || this.allDisallowed;
    }

    public void setFileshareDisallowed(boolean fileshareDisallowed) {
        this.fileshareDisallowed = fileshareDisallowed;
    }

    public boolean isHomepageDisallowed() {
        return this.homepageDisallowed || this.allDisallowed;
    }

    public void setHomepageDisallowed(boolean homepageDisallowed) {
        this.homepageDisallowed = homepageDisallowed;
    }

    public boolean isNetworkDisallowed() {
        return this.networkDisallowed || this.allDisallowed;
    }

    public void setNetworkDisallowed(boolean networkDisallowed) {
        this.networkDisallowed = networkDisallowed;
    }

    public boolean isNewsDisallowed() {
        return this.newsDisallowed || this.allDisallowed;
    }

    public void setNewsDisallowed(boolean newsDisallowed) {
        this.newsDisallowed = newsDisallowed;
    }

    public boolean isStatusDisallowed() {
        return this.statusDisallowed || this.allDisallowed;
    }

    public void setStatusDisallowed(boolean statusDisallowed) {
        this.statusDisallowed = statusDisallowed;
    }

    public boolean isSurftipsDisallowed() {
        return this.surftipsDisallowed || this.allDisallowed;
    }

    public void setSurftipsDisallowed(boolean surftipsDisallowed) {
        this.surftipsDisallowed = surftipsDisallowed;
    }

    public boolean isWikiDisallowed() {
        return this.wikiDisallowed || this.allDisallowed;
    }

    public void setWikiDisallowed(boolean wikiDisallowed) {
        this.wikiDisallowed = wikiDisallowed;
    }

    public boolean isProfileDisallowed() {
        return this.profileDisallowed || this.allDisallowed;
    }

    public void setProfileDisallowed(boolean profileDisallowed) {
        this.profileDisallowed = profileDisallowed;
    }
}

