/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.snippet;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.snippet.TextSnippet;

public class TextSnippetStatistics {
    private static final ConcurrentLog logger = new ConcurrentLog(TextSnippetStatistics.class.getName());
    private AtomicLong totalSnippets = new AtomicLong(0L);
    private AtomicLong totalFailures = new AtomicLong(0L);
    private AtomicLong totalFromSolr = new AtomicLong(0L);
    private AtomicLong totalFromCache = new AtomicLong(0L);
    private AtomicLong totalFromWeb = new AtomicLong(0L);
    private AtomicLong totalFromMetadata = new AtomicLong(0L);
    private AtomicLong totalInitTime = new AtomicLong(0L);
    private AtomicLong maxInitTime = new AtomicLong(0L);
    private AtomicBoolean enabled = new AtomicBoolean(false);

    public long getTotalSnippets() {
        return this.totalSnippets.get();
    }

    public long getTotalFailures() {
        return this.totalFailures.get();
    }

    public long getTotalFromSolr() {
        return this.totalFromSolr.get();
    }

    public long getTotalFromCache() {
        return this.totalFromCache.get();
    }

    public long getTotalFromMetadata() {
        return this.totalFromMetadata.get();
    }

    public long getTotalFromWeb() {
        return this.totalFromWeb.get();
    }

    public void addTextSnippetStatistics(DigestURL url, long initTime, TextSnippet.ResultClass resultStatus) {
        if (this.enabled.get() && resultStatus != null) {
            this.totalSnippets.incrementAndGet();
            this.totalInitTime.addAndGet(initTime);
            if (initTime == this.maxInitTime.accumulateAndGet(initTime, new LongBinaryOperator(){

                @Override
                public long applyAsLong(long currentValue, long updateValue) {
                    return currentValue < updateValue ? updateValue : currentValue;
                }
            }) && logger.isFine()) {
                logger.fine("New max snippet init time : status " + String.valueOf((Object)resultStatus) + " in " + initTime + " ms for URL " + String.valueOf(url));
            }
            if (resultStatus != null) {
                switch (resultStatus) {
                    case SOURCE_SOLR: {
                        this.totalFromSolr.incrementAndGet();
                        break;
                    }
                    case SOURCE_CACHE: {
                        this.totalFromCache.incrementAndGet();
                        break;
                    }
                    case SOURCE_METADATA: {
                        this.totalFromMetadata.incrementAndGet();
                        break;
                    }
                    case SOURCE_WEB: {
                        this.totalFromWeb.incrementAndGet();
                        break;
                    }
                    default: {
                        if (!resultStatus.fail()) break;
                        this.totalFailures.incrementAndGet();
                    }
                }
            }
        }
    }

    public long getTotalInitTime() {
        return this.totalInitTime.get();
    }

    public long getMaxInitTime() {
        return this.maxInitTime.get();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean newValue) {
        this.enabled.set(newValue);
    }
}

