/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.schema;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.FailType;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.schema.HyperlinkEdge;
import net.yacy.search.schema.HyperlinkEdges;
import net.yacy.search.schema.HyperlinkType;
import org.apache.solr.common.SolrDocument;

public class HyperlinkGraph
implements Iterable<HyperlinkEdge> {
    public static final Set<String> ROOTFNS = new HashSet<String>();
    HyperlinkEdges edges = new HyperlinkEdges();
    String hostname = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SolrConnector solrConnector, String hostname, MultiProtocolURL stopURL, long maxtime, int maxnodes) {
        HyperlinkEdges errorEdges;
        HyperlinkEdges outboundEdges;
        HyperlinkEdges inboundEdges;
        HashMap<String, FailType> errorDocs;
        block20: {
            this.hostname = hostname;
            if (hostname.startsWith("www.")) {
                hostname = hostname.substring(4);
            }
            StringBuilder q = new StringBuilder();
            q.append(CollectionSchema.host_s.getSolrFieldName()).append(':').append(hostname).append(" OR ").append(CollectionSchema.host_s.getSolrFieldName()).append(':').append("www.").append(hostname);
            int pageSize = 100;
            ArrayBlockingQueue<SolrDocument> docs = new ArrayBlockingQueue<SolrDocument>(100);
            ArrayList<String> queries = new ArrayList<String>();
            queries.add(q.toString());
            Thread solrQueryTask = new Thread(solrConnector.newDocumentsByQueriesTask(docs, queries, CollectionSchema.url_chars_i.getSolrFieldName() + " asc", 0, maxnodes, maxtime, 100, 1, CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName(), CollectionSchema.failreason_s.getSolrFieldName(), CollectionSchema.failtype_s.getSolrFieldName(), CollectionSchema.inboundlinks_protocol_sxt.getSolrFieldName(), CollectionSchema.inboundlinks_urlstub_sxt.getSolrFieldName(), CollectionSchema.outboundlinks_protocol_sxt.getSolrFieldName(), CollectionSchema.outboundlinks_urlstub_sxt.getSolrFieldName()));
            solrQueryTask.start();
            errorDocs = new HashMap<String, FailType>();
            inboundEdges = new HyperlinkEdges();
            outboundEdges = new HyperlinkEdges();
            errorEdges = new HyperlinkEdges();
            try {
                SolrDocument doc;
                while ((doc = (SolrDocument)docs.take()) != AbstractSolrConnector.POISON_DOCUMENT) {
                    FailType error;
                    MultiProtocolURL from;
                    String u = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                    try {
                        from = new MultiProtocolURL(u);
                    }
                    catch (MalformedURLException e1) {
                        continue;
                    }
                    String errortype = (String)doc.getFieldValue(CollectionSchema.failtype_s.getSolrFieldName());
                    FailType failType = error = errortype == null ? null : FailType.valueOf(errortype);
                    if (error != null) {
                        errorDocs.put(u, error);
                    } else {
                        HyperlinkEdge.Target linkurl2;
                        String link;
                        Iterator<String> links = URIMetadataNode.getLinks(doc, true);
                        while (links.hasNext()) {
                            link = links.next();
                            try {
                                linkurl2 = new HyperlinkEdge.Target(link, HyperlinkType.Inbound);
                                inboundEdges.addEdge(from, linkurl2);
                                if (stopURL == null || !linkurl2.equals(stopURL)) continue;
                                break block20;
                            }
                            catch (MalformedURLException linkurl2) {
                            }
                        }
                        links = URIMetadataNode.getLinks(doc, false);
                        while (links.hasNext()) {
                            link = links.next();
                            try {
                                linkurl2 = new HyperlinkEdge.Target(link, HyperlinkType.Outbound);
                                outboundEdges.addEdge(from, linkurl2);
                                if (stopURL == null || !linkurl2.equals(stopURL)) continue;
                                break block20;
                            }
                            catch (MalformedURLException malformedURLException) {
                            }
                        }
                    }
                    if (inboundEdges.size() + outboundEdges.size() <= maxnodes) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                solrQueryTask.interrupt();
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            HyperlinkEdge edge;
            Iterator<HyperlinkEdge> i = inboundEdges.iterator();
            while (i.hasNext()) {
                edge = i.next();
                if (!errorDocs.containsKey(edge.target.toNormalform(true))) continue;
                i.remove();
                edge.target.type = HyperlinkType.Dead;
                errorEdges.add(edge);
            }
            i = outboundEdges.iterator();
            while (i.hasNext()) {
                edge = i.next();
                if (!errorDocs.containsKey(edge.target.toNormalform(true))) continue;
                i.remove();
                edge.target.type = HyperlinkType.Dead;
                errorEdges.add(edge);
            }
            this.edges.addAll(outboundEdges);
            this.edges.addAll(inboundEdges);
            this.edges.addAll(errorEdges);
        }
    }

    public void path(Segment segment, DigestURL from, DigestURL to, int maxtime, int maxnodes) {
        if (this.edges.size() == 0) {
            this.fill(segment.fulltext().getDefaultConnector(), from == null ? to.getHost() : from.getHost(), to, maxtime, maxnodes);
        }
        if (this.getDepth(to) >= 0 && (from == null || this.getDepth(from) >= 0)) {
            return;
        }
    }

    public int findLinkDepth() {
        int remaining = this.edges.size();
        HashSet<MultiProtocolURL> nodes = new HashSet<MultiProtocolURL>();
        HashSet<HyperlinkEdge.Target> nextnodes = new HashSet<HyperlinkEdge.Target>();
        for (HyperlinkEdge edge : this.edges) {
            String path = edge.source.getPath();
            if (!ROOTFNS.contains(path)) continue;
            this.edges.updateDepth(edge.source, 0);
            if (edge.target.type == HyperlinkType.Inbound) {
                this.edges.updateDepth(edge.target, 1);
            }
            nodes.add(edge.source);
            nextnodes.add(edge.target);
            --remaining;
        }
        if (nodes.size() == 0 && this.edges.size() > 0) {
            ConcurrentLog.warn("HyperlinkGraph", "could not find a root node for " + this.hostname + " in " + this.edges.size() + " edges");
        }
        for (String rootpath : ROOTFNS) {
            try {
                this.edges.updateDepth(new DigestURL("http://" + this.hostname + rootpath), 0);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        int depth = 1;
        while (remaining > 0) {
            boolean found = false;
            nodes = nextnodes;
            nextnodes = new HashSet();
            for (HyperlinkEdge edge : this.edges) {
                if (!nodes.contains(edge.source)) continue;
                this.edges.updateDepth(edge.source, depth);
                if (edge.target.type == HyperlinkType.Inbound) {
                    this.edges.updateDepth(edge.target, depth + 1);
                }
                nextnodes.add(edge.target);
                --remaining;
                found = true;
            }
            ++depth;
            if (found) continue;
            break;
        }
        if (remaining > 0) {
            ConcurrentLog.warn("HyperlinkGraph", "could not find all edges for " + this.hostname + ", " + remaining + " remaining.");
        }
        return depth;
    }

    public Integer getDepth(MultiProtocolURL url) {
        return this.edges.getDepth(url);
    }

    @Override
    public Iterator<HyperlinkEdge> iterator() {
        return this.edges.iterator();
    }

    static {
        for (String s : new String[]{"/", "/index.htm", "/index.html", "/index.php", "/home.htm", "/home.html", "/home.php", "/default.htm", "/default.html", "/default.php"}) {
            ROOTFNS.add(s);
        }
    }
}

