/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.ranking;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;

public class RankingProfile {
    public static final String APPEMPH = "appemph";
    public static final String APPURL = "appurl";
    public static final String APP_DC_CREATOR = "appauthor";
    public static final String APP_DC_DESCRIPTION = "appref";
    public static final String APP_DC_SUBJECT = "apptags";
    public static final String APP_DC_TITLE = "appdescr";
    public static final String AUTHORITY = "authority";
    public static final String CATHASAPP = "cathasapp";
    public static final String CATHASAUDIO = "cathasaudio";
    public static final String CATHASIMAGE = "cathasimage";
    public static final String CATHASVIDEO = "cathasvideo";
    public static final String CATINDEXOF = "catindexof";
    public static final String DATE = "date";
    public static final String DOMLENGTH = "domlength";
    public static final String HITCOUNT = "hitcount";
    public static final String LANGUAGE = "language";
    public static final String LLOCAL = "llocal";
    public static final String LOTHER = "lother";
    public static final String PHRASESINTEXT = "phrasesintext";
    public static final String POSINPHRASE = "posinphrase";
    public static final String POSINTEXT = "posintext";
    public static final String POSOFPHRASE = "posofphrase";
    public static final String TERMFREQUENCY = "tf";
    public static final String URLCOMPS = "urlcomps";
    public static final String URLLENGTH = "urllength";
    public static final String WORDDISTANCE = "worddistance";
    public static final String WORDSINTEXT = "wordsintext";
    public static final String WORDSINTITLE = "wordsintitle";
    public static final String URLCOMPINTOPLIST = "urlcompintoplist";
    public static final String DESCRCOMPINTOPLIST = "descrcompintoplist";
    public static final String PREFER = "prefer";
    public static final String CITATION = "citation";
    public static final int COEFF_MIN = 0;
    public static final int COEFF_MAX = 15;
    public int coeff_domlength;
    public int coeff_date;
    public int coeff_wordsintitle;
    public int coeff_wordsintext;
    public int coeff_phrasesintext;
    public int coeff_llocal;
    public int coeff_lother;
    public int coeff_urllength;
    public int coeff_urlcomps;
    public int coeff_hitcount;
    public int coeff_posintext;
    public int coeff_posofphrase;
    public int coeff_posinphrase;
    public int coeff_authority = 5;
    public int coeff_worddistance;
    public int coeff_appurl = 12;
    public int coeff_app_dc_title = 14;
    public int coeff_app_dc_creator = 1;
    public int coeff_app_dc_subject = 2;
    public int coeff_app_dc_description = 10;
    public int coeff_appemph = 5;
    public int coeff_catindexof;
    public int coeff_cathasimage;
    public int coeff_cathasaudio;
    public int coeff_cathasvideo;
    public int coeff_cathasapp;
    public int coeff_urlcompintoplist;
    public int coeff_descrcompintoplist;
    public int coeff_prefer;
    public int coeff_termfrequency;
    public int coeff_language;
    public int coeff_citation;
    private String externalStringCache = null;

    public RankingProfile(Classification.ContentDomain mediatype) {
        this.coeff_cathasapp = mediatype == Classification.ContentDomain.APP ? 15 : 0;
        this.coeff_cathasaudio = mediatype == Classification.ContentDomain.AUDIO ? 15 : 0;
        this.coeff_cathasimage = mediatype == Classification.ContentDomain.IMAGE ? 15 : 0;
        this.coeff_cathasvideo = mediatype == Classification.ContentDomain.VIDEO ? 15 : 0;
        this.coeff_catindexof = mediatype == Classification.ContentDomain.TEXT ? 0 : 15;
        this.coeff_date = 9;
        this.coeff_domlength = 10;
        this.coeff_hitcount = 1;
        this.coeff_language = 2;
        this.coeff_llocal = 0;
        this.coeff_lother = 7;
        this.coeff_phrasesintext = 0;
        this.coeff_posinphrase = 0;
        this.coeff_posintext = 4;
        this.coeff_posofphrase = 0;
        this.coeff_termfrequency = 8;
        this.coeff_urlcomps = 7;
        this.coeff_urllength = 6;
        this.coeff_worddistance = 10;
        this.coeff_wordsintext = 3;
        this.coeff_wordsintitle = 2;
        this.coeff_urlcompintoplist = 2;
        this.coeff_descrcompintoplist = 2;
        this.coeff_prefer = 0;
        this.coeff_citation = 10;
    }

    public RankingProfile(String prefix, String profile2) {
        this(Classification.ContentDomain.TEXT);
        if (profile2 != null && profile2.length() > 0) {
            HashMap<String, Integer> coeff = new HashMap<String, Integer>(40);
            if (profile2.length() > 0 && profile2.charAt(0) == '{' && profile2.endsWith("}")) {
                profile2 = profile2.substring(1, profile2.length() - 1);
            }
            String[] elts = (profile2 = profile2.trim()).indexOf(38) > 0 ? profile2.split("&") : CommonPattern.COMMA.split(profile2);
            int s = prefix == null ? 0 : prefix.length();
            for (String elt : elts) {
                String e = elt.trim();
                if (s != 0 && !e.startsWith(prefix)) continue;
                int p = e.indexOf(61);
                if (p < 0) {
                    System.out.println("DEBUG: bug in plasmaSearchRankingProfile: e = " + e);
                }
                if (p <= 0 || e.length() <= p + 1) continue;
                try {
                    coeff.put(e.substring(s, p), NumberTools.parseIntDecSubstring(e, p + 1));
                }
                catch (NumberFormatException e1) {
                    System.out.println("wrong parameter: " + e.substring(s, p) + "=" + e.substring(p + 1));
                    ConcurrentLog.logException(e1);
                }
            }
            this.coeff_domlength = RankingProfile.parseMap(coeff, DOMLENGTH, this.coeff_domlength);
            this.coeff_date = RankingProfile.parseMap(coeff, DATE, this.coeff_date);
            this.coeff_wordsintitle = RankingProfile.parseMap(coeff, WORDSINTITLE, this.coeff_wordsintitle);
            this.coeff_wordsintext = RankingProfile.parseMap(coeff, WORDSINTEXT, this.coeff_wordsintext);
            this.coeff_phrasesintext = RankingProfile.parseMap(coeff, PHRASESINTEXT, this.coeff_phrasesintext);
            this.coeff_llocal = RankingProfile.parseMap(coeff, LLOCAL, this.coeff_llocal);
            this.coeff_lother = RankingProfile.parseMap(coeff, LOTHER, this.coeff_lother);
            this.coeff_urllength = RankingProfile.parseMap(coeff, URLLENGTH, this.coeff_urllength);
            this.coeff_urlcomps = RankingProfile.parseMap(coeff, URLCOMPS, this.coeff_urlcomps);
            this.coeff_hitcount = RankingProfile.parseMap(coeff, HITCOUNT, this.coeff_hitcount);
            this.coeff_posintext = RankingProfile.parseMap(coeff, POSINTEXT, this.coeff_posintext);
            this.coeff_posofphrase = RankingProfile.parseMap(coeff, POSOFPHRASE, this.coeff_posofphrase);
            this.coeff_posinphrase = RankingProfile.parseMap(coeff, POSINPHRASE, this.coeff_posinphrase);
            this.coeff_authority = RankingProfile.parseMap(coeff, AUTHORITY, this.coeff_authority);
            this.coeff_worddistance = RankingProfile.parseMap(coeff, WORDDISTANCE, this.coeff_worddistance);
            this.coeff_appurl = RankingProfile.parseMap(coeff, APPURL, this.coeff_appurl);
            this.coeff_app_dc_title = RankingProfile.parseMap(coeff, APP_DC_TITLE, this.coeff_app_dc_title);
            this.coeff_app_dc_creator = RankingProfile.parseMap(coeff, APP_DC_CREATOR, this.coeff_app_dc_creator);
            this.coeff_app_dc_subject = RankingProfile.parseMap(coeff, APP_DC_SUBJECT, this.coeff_app_dc_subject);
            this.coeff_app_dc_description = RankingProfile.parseMap(coeff, APP_DC_DESCRIPTION, this.coeff_app_dc_description);
            this.coeff_appemph = RankingProfile.parseMap(coeff, APPEMPH, this.coeff_appemph);
            this.coeff_catindexof = RankingProfile.parseMap(coeff, CATINDEXOF, this.coeff_catindexof);
            this.coeff_cathasimage = RankingProfile.parseMap(coeff, CATHASIMAGE, this.coeff_cathasimage);
            this.coeff_cathasaudio = RankingProfile.parseMap(coeff, CATHASAUDIO, this.coeff_cathasaudio);
            this.coeff_cathasvideo = RankingProfile.parseMap(coeff, CATHASVIDEO, this.coeff_cathasvideo);
            this.coeff_cathasapp = RankingProfile.parseMap(coeff, CATHASAPP, this.coeff_cathasapp);
            this.coeff_termfrequency = RankingProfile.parseMap(coeff, TERMFREQUENCY, this.coeff_termfrequency);
            this.coeff_urlcompintoplist = RankingProfile.parseMap(coeff, URLCOMPINTOPLIST, this.coeff_urlcompintoplist);
            this.coeff_descrcompintoplist = RankingProfile.parseMap(coeff, DESCRCOMPINTOPLIST, this.coeff_descrcompintoplist);
            this.coeff_prefer = RankingProfile.parseMap(coeff, PREFER, this.coeff_prefer);
            this.coeff_language = RankingProfile.parseMap(coeff, LANGUAGE, this.coeff_language);
            this.coeff_citation = RankingProfile.parseMap(coeff, CITATION, this.coeff_citation);
        }
    }

    private static int parseMap(Map<String, Integer> coeff, String attr, int dflt) {
        if (!coeff.containsKey(attr)) {
            return dflt;
        }
        return coeff.get(attr);
    }

    public void allZero() {
        this.coeff_domlength = 0;
        this.coeff_date = 0;
        this.coeff_wordsintitle = 0;
        this.coeff_wordsintext = 0;
        this.coeff_phrasesintext = 0;
        this.coeff_llocal = 0;
        this.coeff_lother = 0;
        this.coeff_urllength = 0;
        this.coeff_urlcomps = 0;
        this.coeff_hitcount = 0;
        this.coeff_posintext = 0;
        this.coeff_posofphrase = 0;
        this.coeff_posinphrase = 0;
        this.coeff_authority = 0;
        this.coeff_worddistance = 0;
        this.coeff_appurl = 0;
        this.coeff_app_dc_title = 0;
        this.coeff_app_dc_creator = 0;
        this.coeff_app_dc_subject = 0;
        this.coeff_app_dc_description = 0;
        this.coeff_appemph = 0;
        this.coeff_catindexof = 0;
        this.coeff_cathasimage = 0;
        this.coeff_cathasaudio = 0;
        this.coeff_cathasvideo = 0;
        this.coeff_cathasapp = 0;
        this.coeff_termfrequency = 0;
        this.coeff_urlcompintoplist = 0;
        this.coeff_descrcompintoplist = 0;
        this.coeff_prefer = 0;
        this.coeff_language = 0;
        this.coeff_citation = 0;
    }

    public String toExternalString() {
        if (this.externalStringCache != null) {
            return this.externalStringCache;
        }
        this.externalStringCache = this.toExternalMap("").toString();
        return this.externalStringCache;
    }

    public Map<String, String> toExternalMap(String prefix) {
        Map<String, String> ext = this.preToExternalMap(prefix);
        ext.putAll(this.postToExternalMap(prefix));
        return ext;
    }

    public Map<String, String> preToExternalMap(String prefix) {
        LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>(40);
        if (prefix.isEmpty()) {
            ext.put(APPEMPH, Integer.toString(this.coeff_appemph));
            ext.put(APPURL, Integer.toString(this.coeff_appurl));
            ext.put(APP_DC_CREATOR, Integer.toString(this.coeff_app_dc_creator));
            ext.put(APP_DC_DESCRIPTION, Integer.toString(this.coeff_app_dc_description));
            ext.put(APP_DC_SUBJECT, Integer.toString(this.coeff_app_dc_subject));
            ext.put(APP_DC_TITLE, Integer.toString(this.coeff_app_dc_title));
            ext.put(AUTHORITY, Integer.toString(this.coeff_authority));
            ext.put(CATHASAPP, Integer.toString(this.coeff_cathasapp));
            ext.put(CATHASAUDIO, Integer.toString(this.coeff_cathasaudio));
            ext.put(CATHASIMAGE, Integer.toString(this.coeff_cathasimage));
            ext.put(CATHASVIDEO, Integer.toString(this.coeff_cathasvideo));
            ext.put(CATINDEXOF, Integer.toString(this.coeff_catindexof));
            ext.put(DATE, Integer.toString(this.coeff_date));
            ext.put(DOMLENGTH, Integer.toString(this.coeff_domlength));
            ext.put(HITCOUNT, Integer.toString(this.coeff_hitcount));
            ext.put(LANGUAGE, Integer.toString(this.coeff_language));
            ext.put(LLOCAL, Integer.toString(this.coeff_llocal));
            ext.put(LOTHER, Integer.toString(this.coeff_lother));
            ext.put(PHRASESINTEXT, Integer.toString(this.coeff_phrasesintext));
            ext.put(POSINPHRASE, Integer.toString(this.coeff_posinphrase));
            ext.put(POSINTEXT, Integer.toString(this.coeff_posintext));
            ext.put(POSOFPHRASE, Integer.toString(this.coeff_posofphrase));
            ext.put(TERMFREQUENCY, Integer.toString(this.coeff_termfrequency));
            ext.put(URLCOMPS, Integer.toString(this.coeff_urlcomps));
            ext.put(URLLENGTH, Integer.toString(this.coeff_urllength));
            ext.put(WORDDISTANCE, Integer.toString(this.coeff_worddistance));
            ext.put(WORDSINTEXT, Integer.toString(this.coeff_wordsintext));
            ext.put(WORDSINTITLE, Integer.toString(this.coeff_wordsintitle));
        } else {
            ext.put(prefix + APPEMPH, Integer.toString(this.coeff_appemph));
            ext.put(prefix + APPURL, Integer.toString(this.coeff_appurl));
            ext.put(prefix + APP_DC_CREATOR, Integer.toString(this.coeff_app_dc_creator));
            ext.put(prefix + APP_DC_DESCRIPTION, Integer.toString(this.coeff_app_dc_description));
            ext.put(prefix + APP_DC_SUBJECT, Integer.toString(this.coeff_app_dc_subject));
            ext.put(prefix + APP_DC_TITLE, Integer.toString(this.coeff_app_dc_title));
            ext.put(prefix + AUTHORITY, Integer.toString(this.coeff_authority));
            ext.put(prefix + CATHASAPP, Integer.toString(this.coeff_cathasapp));
            ext.put(prefix + CATHASAUDIO, Integer.toString(this.coeff_cathasaudio));
            ext.put(prefix + CATHASIMAGE, Integer.toString(this.coeff_cathasimage));
            ext.put(prefix + CATHASVIDEO, Integer.toString(this.coeff_cathasvideo));
            ext.put(prefix + CATINDEXOF, Integer.toString(this.coeff_catindexof));
            ext.put(prefix + DATE, Integer.toString(this.coeff_date));
            ext.put(prefix + DOMLENGTH, Integer.toString(this.coeff_domlength));
            ext.put(prefix + HITCOUNT, Integer.toString(this.coeff_hitcount));
            ext.put(prefix + LANGUAGE, Integer.toString(this.coeff_language));
            ext.put(prefix + LLOCAL, Integer.toString(this.coeff_llocal));
            ext.put(prefix + LOTHER, Integer.toString(this.coeff_lother));
            ext.put(prefix + PHRASESINTEXT, Integer.toString(this.coeff_phrasesintext));
            ext.put(prefix + POSINPHRASE, Integer.toString(this.coeff_posinphrase));
            ext.put(prefix + POSINTEXT, Integer.toString(this.coeff_posintext));
            ext.put(prefix + POSOFPHRASE, Integer.toString(this.coeff_posofphrase));
            ext.put(prefix + TERMFREQUENCY, Integer.toString(this.coeff_termfrequency));
            ext.put(prefix + URLCOMPS, Integer.toString(this.coeff_urlcomps));
            ext.put(prefix + URLLENGTH, Integer.toString(this.coeff_urllength));
            ext.put(prefix + WORDDISTANCE, Integer.toString(this.coeff_worddistance));
            ext.put(prefix + WORDSINTEXT, Integer.toString(this.coeff_wordsintext));
            ext.put(prefix + WORDSINTITLE, Integer.toString(this.coeff_wordsintitle));
        }
        return ext;
    }

    public Map<String, String> postToExternalMap(String prefix) {
        LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>();
        if (prefix.isEmpty()) {
            ext.put(URLCOMPINTOPLIST, Integer.toString(this.coeff_urlcompintoplist));
            ext.put(DESCRCOMPINTOPLIST, Integer.toString(this.coeff_descrcompintoplist));
            ext.put(PREFER, Integer.toString(this.coeff_prefer));
            ext.put(CITATION, Integer.toString(this.coeff_citation));
        } else {
            ext.put(prefix + URLCOMPINTOPLIST, Integer.toString(this.coeff_urlcompintoplist));
            ext.put(prefix + DESCRCOMPINTOPLIST, Integer.toString(this.coeff_descrcompintoplist));
            ext.put(prefix + PREFER, Integer.toString(this.coeff_prefer));
            ext.put(prefix + CITATION, Integer.toString(this.coeff_citation));
        }
        return ext;
    }

    public String toExternalURLGet(String prefix) {
        Map<String, String> emap = this.toExternalMap("");
        StringBuilder ext = new StringBuilder(emap.size() * 40);
        for (Map.Entry<String, String> entry2 : emap.entrySet()) {
            ext.append('&');
            ext.append(prefix);
            ext.append(entry2.getKey());
            ext.append('=');
            ext.append(entry2.getValue());
        }
        return ext.toString();
    }
}

