/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.index;

import java.io.IOException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.search.index.ErrorCache;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class ErrorCacheFiller
extends Thread {
    private Switchboard sb;
    private ErrorCache cache;

    public ErrorCacheFiller(Switchboard sb, ErrorCache cache) {
        super(ErrorCacheFiller.class.getSimpleName());
        if (sb == null || cache == null) {
            throw new IllegalArgumentException("Unexpected null parameters");
        }
        this.sb = sb;
        this.cache = cache;
    }

    @Override
    public void run() {
        SolrQuery params = new SolrQuery();
        params.setParam("defType", new String[]{"edismax"});
        params.setStart(Integer.valueOf(0));
        params.setRows(Integer.valueOf(1000));
        params.setFacet(false);
        params.setSort(new SolrQuery.SortClause(CollectionSchema.load_date_dt.getSolrFieldName(), SolrQuery.ORDER.desc));
        params.setFields(new String[]{CollectionSchema.id.getSolrFieldName()});
        params.setQuery(CollectionSchema.failreason_s.getSolrFieldName() + ":[* TO *]");
        params.set("df", new String[]{CollectionSchema.id.getSolrFieldName()});
        try {
            SolrDocumentList docList = this.sb.index.fulltext().getDefaultConnector().getDocumentListByParams((ModifiableSolrParams)params);
            if (docList != null) {
                for (int i = docList.size() - 1; i >= 0; --i) {
                    SolrDocument doc = (SolrDocument)docList.get(i);
                    String hash = (String)doc.getFieldValue(CollectionSchema.id.getSolrFieldName());
                    this.cache.putHashOnly(hash);
                }
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

