/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.ListManager;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.SetTools;
import net.yacy.repository.BlacklistFile;
import net.yacy.repository.BlacklistHostAndPath;
import net.yacy.repository.RegexHelper;
import net.yacy.search.Switchboard;

public class Blacklist {
    private static final ConcurrentLog log = new ConcurrentLog(Blacklist.class.getSimpleName());
    public static final String BLACKLIST_FILENAME_FILTER = "^.*\\.black$";
    private File blacklistRootPath = null;
    private final ConcurrentMap<BlacklistType, HandleSet> cachedUrlHashs;
    private final ConcurrentMap<BlacklistType, Map<String, Set<Pattern>>> hostpaths_matchable;
    private final ConcurrentMap<BlacklistType, Map<String, Set<Pattern>>> hostpaths_notmatchable;
    private static final Pattern m1 = Pattern.compile("^[a-z0-9.-]*$");
    private static final Pattern m2 = Pattern.compile("^\\*\\.[a-z0-9-.]*$");
    private static final Pattern m3 = Pattern.compile("^[a-z0-9-.]*\\.\\*$");

    public Blacklist(File rootPath) {
        this.setRootPath(rootPath);
        this.hostpaths_matchable = new ConcurrentHashMap<BlacklistType, Map<String, Set<Pattern>>>();
        this.hostpaths_notmatchable = new ConcurrentHashMap<BlacklistType, Map<String, Set<Pattern>>>();
        this.cachedUrlHashs = new ConcurrentHashMap<BlacklistType, HandleSet>();
        for (BlacklistType blacklistType : BlacklistType.values()) {
            this.hostpaths_matchable.put(blacklistType, new ConcurrentHashMap());
            this.hostpaths_notmatchable.put(blacklistType, new ConcurrentHashMap());
            this.loadDHTCache(blacklistType);
        }
    }

    public final synchronized void close() {
        log.fine("Shutting down blacklists ...");
        for (BlacklistType blacklistType : BlacklistType.values()) {
            this.saveDHTCache(blacklistType);
        }
        log.fine("All blacklists has been shutdown.");
    }

    private final void setRootPath(File rootPath) {
        if (rootPath == null) {
            throw new NullPointerException("The blacklist root path must not be null.");
        }
        if (!rootPath.isDirectory()) {
            throw new IllegalArgumentException("The blacklist root path is not a directory.");
        }
        if (!rootPath.canRead()) {
            throw new IllegalArgumentException("The blacklist root path is not readable.");
        }
        this.blacklistRootPath = rootPath;
    }

    protected final Map<String, Set<Pattern>> getBlacklistMap(BlacklistType blacklistType, boolean matchable) {
        return matchable ? (Map)this.hostpaths_matchable.get((Object)blacklistType) : (Map)this.hostpaths_notmatchable.get((Object)blacklistType);
    }

    protected final HandleSet getCacheUrlHashsSet(BlacklistType blacklistType) {
        return (HandleSet)this.cachedUrlHashs.get((Object)blacklistType);
    }

    public final File getRootPath() {
        return this.blacklistRootPath;
    }

    public final void clear() {
        for (Object entry2 : this.hostpaths_matchable.values()) {
            entry2.clear();
        }
        for (Object entry2 : this.hostpaths_notmatchable.values()) {
            entry2.clear();
        }
        for (Object entry2 : this.cachedUrlHashs.values()) {
            entry2.clear();
        }
    }

    public final int size() {
        int size = 0;
        for (BlacklistType entry2 : this.hostpaths_matchable.keySet()) {
            for (Set ientry : ((Map)this.hostpaths_matchable.get((Object)entry2)).values()) {
                size += ientry.size();
            }
        }
        for (BlacklistType entry2 : this.hostpaths_notmatchable.keySet()) {
            for (Set ientry : ((Map)this.hostpaths_notmatchable.get((Object)entry2)).values()) {
                size += ientry.size();
            }
        }
        return size;
    }

    public final void loadList(BlacklistFile[] blFiles, String sep) {
        for (BlacklistFile blf : blFiles) {
            this.loadList(blf, sep);
        }
    }

    private void loadList(BlacklistFile blFile, String sep) {
        Map<String, Set<Pattern>> blacklistMapMatch = this.getBlacklistMap(blFile.getType(), true);
        Map<String, Set<Pattern>> blacklistMapNotMatch = this.getBlacklistMap(blFile.getType(), false);
        Set<String> fileNames = blFile.getFileNamesUnified();
        for (String fileName : fileNames) {
            File file = new File(this.blacklistRootPath, fileName);
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Set<Map.Entry<String, List<String>>> loadedBlacklist = SetTools.loadMapMultiValsPerKey(file.toString(), sep).entrySet();
            for (Map.Entry<String, List<String>> loadedEntry : loadedBlacklist) {
                Set<Pattern> paths;
                List<String> loadedPaths = loadedEntry.getValue();
                HashSet<Pattern> loadedPathsPattern = new HashSet<Pattern>();
                for (String a : loadedPaths) {
                    if (a.equals("*")) {
                        loadedPathsPattern.add(Pattern.compile(".*", 2));
                        continue;
                    }
                    if (a.indexOf("?*", 0) > 0) {
                        log.warn("ignored blacklist path to prevent 'Dangling meta character' exception: " + a);
                        continue;
                    }
                    String normalizedPattern = MultiProtocolURL.escapePathPattern(a);
                    loadedPathsPattern.add(Pattern.compile(normalizedPattern, 2));
                }
                Set<Pattern> set = paths = Blacklist.isMatchable(loadedEntry.getKey()) ? blacklistMapMatch.get(loadedEntry.getKey()) : blacklistMapNotMatch.get(loadedEntry.getKey());
                if (paths == null) {
                    if (Blacklist.isMatchable(loadedEntry.getKey())) {
                        blacklistMapMatch.put(loadedEntry.getKey(), loadedPathsPattern);
                        continue;
                    }
                    blacklistMapNotMatch.put(loadedEntry.getKey(), loadedPathsPattern);
                    continue;
                }
                paths.addAll(new HashSet(loadedPathsPattern));
            }
        }
    }

    public final void loadList(BlacklistType blacklistType, String fileNames, String sep) {
        BlacklistFile blFile = new BlacklistFile(fileNames, blacklistType);
        this.loadList(blFile, sep);
    }

    public final void remove(BlacklistType blacklistType, String blacklistToUse, String host, String path) {
        Map<String, Set<Pattern>> blacklistMap = this.getBlacklistMap(blacklistType, true);
        this.removePatternFromMap(host, path, blacklistMap);
        Map<String, Set<Pattern>> blacklistMapNotMatch = this.getBlacklistMap(blacklistType, false);
        this.removePatternFromMap(host, path, blacklistMapNotMatch);
        ArrayList<String> list2 = FileUtils.getListArray(new File(ListManager.listsPath, blacklistToUse));
        HashSet<CallSite> entriesToDelete = new HashSet<CallSite>();
        String normalizedPathPattern = MultiProtocolURL.escapePathPattern(path);
        entriesToDelete.add((CallSite)((Object)(host + "/" + path)));
        entriesToDelete.add((CallSite)((Object)(host + "/" + normalizedPathPattern)));
        if (!Punycode.isBasic(host)) {
            try {
                String normalizedHost = MultiProtocolURL.toPunycode(host);
                entriesToDelete.add((CallSite)((Object)(normalizedHost + "/" + path)));
                entriesToDelete.add((CallSite)((Object)(normalizedHost + "/" + normalizedPathPattern)));
            }
            catch (Punycode.PunycodeException punycodeException) {
                // empty catch block
            }
        }
        if (list2 != null) {
            for (String e : list2) {
                if (!entriesToDelete.contains(e)) continue;
                list2.remove(e);
                break;
            }
            FileUtils.writeList(new File(ListManager.listsPath, blacklistToUse), list2.toArray(new String[list2.size()]));
        }
    }

    private void removePatternFromMap(String host, String pathPattern, Map<String, Set<Pattern>> blacklistMap) {
        String normalizedPathPattern = MultiProtocolURL.escapePathPattern(pathPattern);
        HashSet<String> hosts = new HashSet<String>();
        hosts.add(host);
        if (!Punycode.isBasic(host)) {
            try {
                hosts.add(MultiProtocolURL.toPunycode(host));
            }
            catch (Punycode.PunycodeException punycodeException) {
                // empty catch block
            }
        }
        for (String hostKey : hosts) {
            Set<Pattern> hostList = blacklistMap.get(hostKey);
            if (hostList == null) continue;
            for (Pattern hp : hostList) {
                String hpxs = hp.pattern();
                if (!hpxs.equals(pathPattern) && !hpxs.equals(normalizedPathPattern)) continue;
                hostList.remove(hp);
                break;
            }
            if (!hostList.isEmpty()) continue;
            blacklistMap.remove(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(BlacklistType blacklistType, String blacklistToUse, Collection<BlacklistHostAndPath> items) throws Punycode.PunycodeException, PatternSyntaxException {
        if (items != null) {
            PrintWriter pw = null;
            try {
                HashSet<String> blacklist = new HashSet<String>(FileUtils.getListArray(new File(this.blacklistRootPath, blacklistToUse)));
                pw = new PrintWriter(new FileWriter(new File(this.blacklistRootPath, blacklistToUse), true));
                for (BlacklistHostAndPath itemToAdd : items) {
                    Set<Pattern> hostList;
                    String safePath;
                    String host = itemToAdd.getHost();
                    String path = itemToAdd.getPath();
                    String safeHost = Punycode.isBasic(host) ? host : MultiProtocolURL.toPunycode(host);
                    if (this.contains(blacklistType, safeHost, safePath = MultiProtocolURL.escapePathPattern(path))) continue;
                    if (safeHost == null) {
                        log.warn("host must not be null");
                        continue;
                    }
                    if (path == null) {
                        log.warn("path must not be null");
                        continue;
                    }
                    Object p = !safePath.isEmpty() && safePath.charAt(0) == '/' ? safePath.substring(1) : safePath;
                    Map<String, Set<Pattern>> blacklistMap = this.getBlacklistMap(blacklistType, Blacklist.isMatchable(host));
                    String h = ((String)(!Blacklist.isMatchable(safeHost) && !safeHost.isEmpty() && safeHost.charAt(0) == '*' ? "." + safeHost : safeHost)).toLowerCase(Locale.ROOT);
                    if (!((String)p).isEmpty() && ((String)p).charAt(0) == '*') {
                        p = "." + (String)p;
                    }
                    if (!blacklistMap.containsKey(h) || (hostList = blacklistMap.get(h)) == null) {
                        hostList = new HashSet<Pattern>();
                        blacklistMap.put(h, hostList);
                    }
                    Pattern pattern = Pattern.compile((String)p, 2);
                    hostList.add(pattern);
                    String newEntry = h + "/" + String.valueOf(pattern);
                    if (blacklist.contains(newEntry)) continue;
                    pw.println(newEntry);
                    blacklist.add(newEntry);
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                if (pw != null) {
                    pw.close();
                    if (pw.checkError()) {
                        log.warn("could not close stream to " + blacklistToUse + "! ");
                    }
                }
            }
        }
    }

    public final void add(BlacklistType blacklistType, String blacklistToUse, String host, String path) throws Punycode.PunycodeException, PatternSyntaxException {
        ArrayList<BlacklistHostAndPath> oneItemList = new ArrayList<BlacklistHostAndPath>();
        oneItemList.add(new BlacklistHostAndPath(host, path));
        this.add(blacklistType, blacklistToUse, oneItemList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(String blacklistSourcefile, String host, String path) throws Punycode.PunycodeException {
        if (host == null) {
            throw new IllegalArgumentException("host may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        Object p = !path.isEmpty() && path.charAt(0) == '/' ? path.substring(1) : path;
        p = MultiProtocolURL.escapePathPattern((String)p);
        String h = ((String)(!Blacklist.isMatchable(host) && !host.isEmpty() && host.charAt(0) == '*' ? "." + host : host)).toLowerCase(Locale.ROOT);
        String string = h = Punycode.isBasic(h) ? h : MultiProtocolURL.toPunycode(h);
        if (!((String)p).isEmpty() && ((String)p).charAt(0) == '*') {
            p = "." + (String)p;
        }
        Pattern pattern = Pattern.compile((String)p, 2);
        for (BlacklistType supportedBlacklistType : BlacklistType.values()) {
            Set<Pattern> hostList;
            if (!ListManager.listSetContains(String.valueOf((Object)supportedBlacklistType) + ".BlackLists", blacklistSourcefile)) continue;
            Map<String, Set<Pattern>> blacklistMap = this.getBlacklistMap(supportedBlacklistType, Blacklist.isMatchable(host));
            if (!blacklistMap.containsKey(h) || (hostList = blacklistMap.get(h)) == null) {
                hostList = new HashSet<Pattern>();
                blacklistMap.put(h, hostList);
            }
            hostList.add(pattern);
        }
        PrintWriter pw = null;
        try {
            String newEntry = h + "/" + String.valueOf(pattern);
            if (!Blacklist.blacklistFileContains(this.blacklistRootPath, blacklistSourcefile, newEntry)) {
                pw = new PrintWriter(new FileWriter(new File(this.blacklistRootPath, blacklistSourcefile), true));
                pw.println(newEntry);
                pw.close();
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception e) {
                    log.warn("could not close stream to " + blacklistSourcefile + "! " + e.getMessage());
                }
            }
        }
    }

    public final int blacklistCacheSize() {
        int size = 0;
        Iterator iter = this.cachedUrlHashs.keySet().iterator();
        while (iter.hasNext()) {
            size += ((HandleSet)this.cachedUrlHashs.get(iter.next())).size();
        }
        return size;
    }

    public final void clearblacklistCache() {
        Iterator iter = this.cachedUrlHashs.keySet().iterator();
        while (iter.hasNext()) {
            ((HandleSet)this.cachedUrlHashs.get(iter.next())).clear();
        }
    }

    public final boolean hashInBlacklistedCache(BlacklistType blacklistType, byte[] urlHash) {
        HandleSet s = this.getCacheUrlHashsSet(blacklistType);
        return s != null && s.has(urlHash);
    }

    public final boolean contains(BlacklistType blacklistType, String host, String path) {
        String h;
        Map<String, Set<Pattern>> blacklistMap;
        Set<Pattern> hostList;
        boolean ret = false;
        if (blacklistType != null && host != null && path != null && (hostList = (blacklistMap = this.getBlacklistMap(blacklistType, Blacklist.isMatchable(host))).get(h = ((String)(!Blacklist.isMatchable(host) && !host.isEmpty() && host.charAt(0) == '*' ? "." + host : host)).toLowerCase(Locale.ROOT))) != null) {
            for (Pattern hp : hostList) {
                String hpxs = hp.pattern();
                if (!hpxs.equals(path)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public final boolean isListed(BlacklistType blacklistType, DigestURL url) {
        if (url == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        if (url.getHost() == null) {
            return false;
        }
        HandleSet urlHashCache = this.getCacheUrlHashsSet(blacklistType);
        if (urlHashCache == null) {
            urlHashCache = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
            if (this.isListed(blacklistType, url.getHost().toLowerCase(Locale.ROOT), url.getFile())) {
                try {
                    urlHashCache.put(url.hash());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
                this.cachedUrlHashs.put(blacklistType, urlHashCache);
            }
        }
        if (!urlHashCache.has(url.hash())) {
            boolean temp = this.isListed(blacklistType, url.getHost().toLowerCase(Locale.ROOT), url.getFile());
            if (temp) {
                try {
                    urlHashCache.put(url.hash());
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            }
            return temp;
        }
        return true;
    }

    public static boolean isMatchable(String host) {
        return m1.matcher(host).matches() || m2.matcher(host).matches() || m3.matcher(host).matches();
    }

    public static String getEngineInfo() {
        return "Default YaCy Blacklist Engine";
    }

    public final boolean isListed(BlacklistType blacklistType, String hostlow, String path) {
        if (hostlow == null) {
            throw new IllegalArgumentException("hostlow may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        Map<String, Set<Pattern>> blacklistMapMatched = this.getBlacklistMap(blacklistType, true);
        Map<String, Set<Pattern>> blacklistMapNotMatched = this.getBlacklistMap(blacklistType, false);
        return Blacklist.isListed(hostlow, path, blacklistMapMatched, blacklistMapNotMatched);
    }

    protected static final boolean isListed(String hostlow, String path, Map<String, Set<Pattern>> blacklistMapMatched, Map<String, Set<Pattern>> blacklistMapNotMatched) {
        long timeInSeconds;
        int i;
        Pattern pp;
        Pattern[] app;
        long beginTime = 0L;
        if (log.isFine()) {
            beginTime = System.nanoTime();
        }
        String p = !path.isEmpty() && path.charAt(0) == '/' ? path.substring(1) : path;
        boolean matched = false;
        if (!matched && blacklistMapMatched.get(hostlow) != null) {
            app = blacklistMapMatched.get(hostlow).toArray(new Pattern[0]);
            for (int i2 = app.length - 1; !matched && i2 > -1; matched |= pp.matcher(p).matches(), --i2) {
                pp = app[i2];
            }
        }
        int index2 = 0;
        while (!matched && (index2 = hostlow.indexOf(46, index2 + 1)) != -1) {
            if (blacklistMapMatched.get(hostlow.substring(0, index2 + 1) + "*") != null) {
                app = blacklistMapMatched.get(hostlow.substring(0, index2 + 1) + "*").toArray(new Pattern[0]);
                for (i = app.length - 1; !matched && i > -1; matched |= pp.matcher(p).matches(), --i) {
                    pp = app[i];
                }
            }
            if (blacklistMapMatched.get(hostlow.substring(0, index2)) == null) continue;
            app = blacklistMapMatched.get(hostlow.substring(0, index2)).toArray(new Pattern[0]);
            for (i = app.length - 1; !matched && i > -1; matched |= pp.matcher(p).matches(), --i) {
                pp = app[i];
            }
        }
        index2 = hostlow.length();
        while (!matched && (index2 = hostlow.lastIndexOf(46, index2 - 1)) != -1) {
            if (blacklistMapMatched.get("*" + hostlow.substring(index2, hostlow.length())) != null) {
                app = blacklistMapMatched.get("*" + hostlow.substring(index2, hostlow.length())).toArray(new Pattern[0]);
                for (i = app.length - 1; !matched && i > -1; matched |= pp.matcher(p).matches(), --i) {
                    pp = app[i];
                }
            }
            if (blacklistMapMatched.get(hostlow.substring(index2 + 1, hostlow.length())) == null) continue;
            app = blacklistMapMatched.get(hostlow.substring(index2 + 1, hostlow.length())).toArray(new Pattern[0]);
            for (i = app.length - 1; !matched && i > -1; matched |= pp.matcher(p).matches(), --i) {
                pp = app[i];
            }
        }
        if (!matched) {
            for (Map.Entry<String, Set<Pattern>> entry2 : blacklistMapNotMatched.entrySet()) {
                String key = entry2.getKey();
                try {
                    if (!Pattern.matches(key, hostlow)) continue;
                    for (Pattern ap : app = entry2.getValue().toArray(new Pattern[0])) {
                        if (!ap.matcher(p).matches()) continue;
                        return true;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                }
            }
        }
        if (log.isFine() && (timeInSeconds = (System.nanoTime() - beginTime) / 1000000000L) > 10L) {
            log.fine("Long processing : " + timeInSeconds + " seconds. URL :  " + hostlow + path);
        }
        return matched;
    }

    public static BlacklistError checkError(String element, Map<String, String> properties) {
        String path;
        String host;
        boolean allowRegex = properties != null && properties.get("allowRegex").equalsIgnoreCase("true");
        int slashPos = element.indexOf(47);
        if (slashPos == -1) {
            host = element;
            path = ".*";
        } else {
            host = element.substring(0, slashPos);
            path = element.substring(slashPos + 1);
        }
        if (!allowRegex || !RegexHelper.isValidRegex(host)) {
            int i = host.indexOf(42);
            if (!host.matches("([A-Za-z0-9_-]+|\\*)(\\.([A-Za-z0-9_-]+|\\*))*")) {
                if (i == 0 && host.length() > 1 && host.charAt(1) != '.') {
                    return BlacklistError.SUBDOMAIN_XOR_WILDCARD;
                }
                return BlacklistError.HOST_WRONG_CHARS;
            }
            if (!host.isEmpty() && i > -1) {
                if (i != 0 && i != host.length() - 1) {
                    return BlacklistError.WILDCARD_BEGIN_OR_END;
                }
                if (i == host.length() - 1 && host.length() > 1 && host.charAt(i - 1) != '.') {
                    return BlacklistError.SUBDOMAIN_XOR_WILDCARD;
                }
            }
            if (host.indexOf("*", i + 1) > -1) {
                return BlacklistError.TWO_WILDCARDS_IN_HOST;
            }
        } else if (allowRegex && !RegexHelper.isValidRegex(host)) {
            return BlacklistError.HOST_REGEX;
        }
        if (!RegexHelper.isValidRegex(path) && !"*".equals(path)) {
            return BlacklistError.PATH_REGEX;
        }
        return BlacklistError.NO_ERROR;
    }

    public static String defaultBlacklist(File listsPath) {
        List<String> dirlist = FileUtils.getDirListing(listsPath, BLACKLIST_FILENAME_FILTER);
        if (dirlist.isEmpty()) {
            return null;
        }
        for (String name : dirlist) {
            if (!name.contains(".default.")) continue;
            return name;
        }
        return dirlist.get(0);
    }

    public static boolean blacklistFileContains(File listsPath, String blacklistToUse, String newEntry) {
        HashSet<String> blacklist = new HashSet<String>(FileUtils.getListArray(new File(listsPath, blacklistToUse)));
        return blacklist != null && blacklist.contains(newEntry);
    }

    private static File DHTCacheFile(BlacklistType type) {
        String BLACKLIST_DHT_CACHEFILE_NAME = "DATA/LISTS/blacklist_" + type.name() + "_Cache.ser";
        return new File(Switchboard.getSwitchboard().dataPath, BLACKLIST_DHT_CACHEFILE_NAME);
    }

    private final void saveDHTCache(BlacklistType type) {
        try (FileOutputStream fileOutStream = new FileOutputStream(Blacklist.DHTCacheFile(type));
             ObjectOutputStream out = new ObjectOutputStream(fileOutStream);){
            HandleSet s = this.getCacheUrlHashsSet(type);
            if (s != null) {
                out.writeObject(this.getCacheUrlHashsSet(type));
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadDHTCache(BlacklistType type) {
        File cachefile = Blacklist.DHTCacheFile(type);
        if (cachefile.exists()) {
            FileInputStream fileInStream = null;
            ObjectInputStream in = null;
            try {
                fileInStream = new FileInputStream(cachefile);
                in = new ObjectInputStream(fileInStream);
                RowHandleSet rhs = (RowHandleSet)in.readObject();
                this.cachedUrlHashs.put(type, rhs == null ? new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0) : rhs);
                return;
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Could not close object input stream on file " + String.valueOf(cachefile));
                    }
                } else if (fileInStream != null) {
                    try {
                        fileInStream.close();
                    }
                    catch (IOException ioe) {
                        log.warn("Could not close input stream on file " + String.valueOf(cachefile));
                    }
                }
            }
        }
        this.cachedUrlHashs.put(type, new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0));
    }

    public static enum BlacklistType {
        DHT,
        CRAWLER,
        PROXY,
        SEARCH,
        SURFTIPS,
        NEWS;


        public final String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static enum BlacklistError {
        NO_ERROR(0),
        TWO_WILDCARDS_IN_HOST(1),
        SUBDOMAIN_XOR_WILDCARD(2),
        PATH_REGEX(3),
        WILDCARD_BEGIN_OR_END(4),
        HOST_WRONG_CHARS(5),
        DOUBLE_OCCURANCE(6),
        HOST_REGEX(7);

        final int errorCode;

        private BlacklistError(int errorCode) {
            this.errorCode = errorCode;
        }

        public int getInt() {
            return this.errorCode;
        }

        public long getLong() {
            return this.errorCode;
        }
    }
}

