/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.operation;

import java.util.Comparator;
import java.util.regex.Matcher;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.search.Switchboard;

public class yacyVersion
implements Comparator<yacyVersion>,
Comparable<yacyVersion> {
    public static final double YACY_SUPPORTS_GZIP_POST_REQUESTS_CHUNKED = 0.5820475816726685;
    public static final double YACY_HANDLES_COLLECTION_INDEX = (double)0.486f;
    public static final double YACY_POVIDES_REMOTECRAWL_LISTS = (double)0.55f;
    private static yacyVersion thisVersion = null;
    private double releaseNr;
    private final String dateStamp;
    private long svn;
    private String git;
    private final boolean mainRelease;
    private final String name;

    public yacyVersion(String release, String host) {
        this.name = release;
        if (release == null || !release.endsWith(".tar.gz") && !release.endsWith(".tar")) {
            throw new RuntimeException("release file name '" + release + "' is not valid, no tar.gz");
        }
        if (!(release = release.substring(0, release.length() - (release.endsWith(".gz") ? 7 : 4))).startsWith("yacy_v")) {
            throw new RuntimeException("release file name '" + release + "' is not valid, wrong prefix");
        }
        release = release.substring(6);
        String[] comp = release.split("_");
        if (comp.length < 2 || comp.length > 3) {
            throw new RuntimeException("release file name '" + release + "' is not valid, 3 information parts expected");
        }
        try {
            this.releaseNr = Double.parseDouble(comp[0]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("release file name '" + release + "' is not valid, '" + comp[0] + "' should be a double number");
        }
        this.mainRelease = (int)(this.getReleaseNr() * 100.0) % 10 == 0 || host != null && host.endsWith("yacy.net");
        this.dateStamp = comp[1];
        if (this.dateStamp.length() != 8 && this.dateStamp.length() != 12) {
            throw new RuntimeException("release file name '" + release + "' is not valid, '" + comp[1] + "' should be a 8 or 12-digit date string");
        }
        if (comp.length > 2) {
            try {
                this.svn = Long.parseLong(comp[2]);
                this.git = "";
            }
            catch (NumberFormatException e) {
                this.svn = Long.parseLong(this.dateStamp);
                this.git = comp[2];
            }
        } else {
            this.svn = 0L;
            this.git = "";
        }
    }

    public static final yacyVersion thisVersion() {
        if (thisVersion == null) {
            Switchboard sb = Switchboard.getSwitchboard();
            if (sb == null) {
                return null;
            }
            thisVersion = new yacyVersion(yacyBuildProperties.getReleaseStub() + ".tar.gz", null);
        }
        return thisVersion;
    }

    @Override
    public int compareTo(yacyVersion obj) {
        return this.compare(this, obj);
    }

    @Override
    public int compare(yacyVersion v0, yacyVersion v1) {
        int r = Double.valueOf(v0.getReleaseGitNr()).compareTo(v1.getReleaseGitNr());
        if (r != 0) {
            return r;
        }
        r = v0.getDateStamp().compareTo(v1.getDateStamp());
        if (r != 0) {
            return r;
        }
        return Long.valueOf(v0.getSvn()).compareTo(v1.getSvn());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof yacyVersion) {
            yacyVersion v = (yacyVersion)obj;
            return this.getReleaseGitNr() == v.getReleaseGitNr() && this.getSvn() == v.getSvn() && this.getName().equals(v.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static String[] combined2prettyVersion(String combinedVersion) {
        return yacyVersion.combined2prettyVersion(combinedVersion, "");
    }

    public static String[] combined2prettyVersion(String ver, String computerName) {
        Matcher matcher = yacyBuildProperties.versionMatcher.matcher(ver);
        Matcher releaseStubMatcher = yacyBuildProperties.releaseStubVersionMatcher.matcher(ver);
        String mainVersion = "dev";
        String revision = "00000";
        if (matcher.find()) {
            mainVersion = Double.parseDouble(matcher.group(1)) < 0.11 ? "dev" : matcher.group(1);
            revision = matcher.group(2);
        } else if (releaseStubMatcher.find()) {
            mainVersion = releaseStubMatcher.group(1);
            revision = releaseStubMatcher.group(3);
        } else {
            ConcurrentLog.warn("STARTUP", "Peer '" + computerName + "': wrong format of version-string: '" + ver + "'. Using default string '" + mainVersion + "/" + revision + "' instead");
        }
        return new String[]{mainVersion, revision};
    }

    public static int revision(String ver) {
        Matcher matcher = yacyBuildProperties.versionMatcher.matcher(ver);
        if (!matcher.find()) {
            return 0;
        }
        return Integer.parseInt(matcher.group(2));
    }

    public static double versvn2combinedVersion(double version2, int svn) {
        return Math.rint(version2 * 1.0E8 + (double)svn) / 1.0E8;
    }

    public String getDateStamp() {
        return this.dateStamp;
    }

    public long getSvn() {
        return this.svn;
    }

    public String getGit() {
        return this.git;
    }

    public boolean isMainRelease() {
        return this.mainRelease;
    }

    public double getReleaseNr() {
        return this.releaseNr;
    }

    public double getReleaseGitNr() {
        double d = (double)this.getSvn() / 1.0E7;
        if (d > 0.0) {
            d /= 10000.0;
        }
        return this.getReleaseNr() + d;
    }

    public String getName() {
        return this.name;
    }

    public static void main(String[] args) {
        yacyVersion y1 = new yacyVersion("yacy_v0.51_20070321_3501.tar.gz", null);
        yacyVersion y2 = new yacyVersion("yacy_v1.0_20111203_8134.tar.gz", null);
        yacyVersion y3 = new yacyVersion("yacy_v1.01_20111206_8140.tar.gz", null);
        yacyVersion y4 = new yacyVersion("yacy_v1.01_20111207.tar.gz", null);
        System.out.println(y1.compareTo(y2));
        System.out.println(y2.compareTo(y3));
        System.out.println(y3.compareTo(y4));
    }
}

