/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.operation;

import java.io.File;
import net.yacy.peers.operation.sshc;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.server.serverSwitch;

public class yacySeedUploadScp
implements yacySeedUploader {
    public static final String CONFIG_SCP_SERVER = "seedScpServer";
    public static final String CONFIG_SCP_SERVER_PORT = "seedScpServerPort";
    public static final String CONFIG_SCP_ACCOUNT = "seedScpAccount";
    public static final String CONFIG_SCP_PASSWORD = "seedScpPassword";
    public static final String CONFIG_SCP_PATH = "seedScpPath";

    @Override
    public String uploadSeedFile(serverSwitch sb, File seedFile) throws Exception {
        if (sb == null) {
            throw new NullPointerException("Reference to serverSwitch nut not be null.");
        }
        if (seedFile == null || !seedFile.exists()) {
            throw new Exception("Seed file does not exist.");
        }
        String seedScpServer = sb.getConfig(CONFIG_SCP_SERVER, null);
        String seedScpServerPort = sb.getConfig(CONFIG_SCP_SERVER_PORT, "22");
        String seedScpAccount = sb.getConfig(CONFIG_SCP_ACCOUNT, null);
        String seedScpPassword = sb.getConfig(CONFIG_SCP_PASSWORD, null);
        String seedScpPath = sb.getConfig(CONFIG_SCP_PATH, null);
        if (seedScpServer == null || seedScpServer.isEmpty()) {
            throw new Exception("Seed SCP upload settings not configured properly. Servername must not be null or empty.");
        }
        if (seedScpAccount == null || seedScpAccount.isEmpty()) {
            throw new Exception("Seed SCP upload settings not configured properly. Username must not be null or empty.");
        }
        if (seedScpPassword == null || seedScpPassword.isEmpty()) {
            throw new Exception("Seed SCP upload settings not configured properly. Password must not be null or empty.");
        }
        if (seedScpPath == null || seedScpPath.isEmpty()) {
            throw new Exception("Seed SCP upload settings not configured properly. File path must not be null or empty.");
        }
        if (seedScpServerPort == null || seedScpServerPort.isEmpty()) {
            throw new Exception("Seed SCP upload settings not configured properly. Server port must not be null or empty.");
        }
        int port = 22;
        try {
            port = Integer.parseInt(seedScpServerPort);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Seed SCP upload settings not configured properly. Server port is not a vaild integer.");
        }
        return sshc.put(seedScpServer, port, seedFile, seedScpPath, "seed.txt", seedScpAccount, seedScpPassword);
    }

    @Override
    public String[] getConfigurationOptions() {
        return new String[]{CONFIG_SCP_SERVER, CONFIG_SCP_SERVER_PORT, CONFIG_SCP_ACCOUNT, CONFIG_SCP_PASSWORD, CONFIG_SCP_PATH};
    }
}

