/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Response;
import net.yacy.search.Switchboard;
import net.yacy.visualization.RasterPlotter;

public class OSMTile {
    public static RasterPlotter getCombinedTiles(tileCoordinates t, int width, int height) {
        int w = (width - 1) / 2;
        width = w * 2 + 1;
        int h = (height - 1) / 2;
        height = h * 2 + 1;
        RasterPlotter m = new RasterPlotter(256 * width, 256 * height, RasterPlotter.DrawMode.MODE_REPLACE, "FFFFFF");
        ArrayList<Place> tileLoader = new ArrayList<Place>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Place place = new Place(m, t.xtile - w + i, t.ytile - h + j, 256 * i, 256 * j, t.zoom);
                place.start();
                tileLoader.add(place);
                if (t.zoom < 17) continue;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (Place p : tileLoader) {
            try {
                p.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return m;
    }

    public static BufferedImage getSingleTile(tileCoordinates tile, int retry) {
        DigestURL tileURL;
        try {
            tileURL = new DigestURL(tile.url(retry));
        }
        catch (MalformedURLException e) {
            return null;
        }
        byte[] tileb = Cache.getContent(tileURL.hash());
        if (tileb == null) {
            Response entry2 = null;
            try {
                entry2 = Switchboard.getSwitchboard().loader.load(Switchboard.getSwitchboard().loader.request(tileURL, false, false), CacheStrategy.IFEXIST, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
            }
            catch (IOException e) {
                ConcurrentLog.warn("OSMTile", "cannot load: " + e.getMessage());
                return null;
            }
            tileb = entry2.getContent();
        }
        try {
            ImageIO.setUseCache(false);
            return ImageIO.read(new ByteArrayInputStream(tileb));
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    static class Place
    extends Thread {
        RasterPlotter m;
        int xt;
        int yt;
        int xc;
        int yc;
        int z;

        public Place(RasterPlotter m, int xt, int yt, int xc, int yc, int z) {
            super("OSMTile.Place(" + xt + "," + yt + ")");
            this.m = m;
            this.xt = xt;
            this.yt = yt;
            this.xc = xc;
            this.yc = yc;
            this.z = z;
        }

        @Override
        public void run() {
            tileCoordinates t = new tileCoordinates(this.xt, this.yt, this.z);
            BufferedImage bi = null;
            for (int i = 0; i < 5; ++i) {
                bi = OSMTile.getSingleTile(t, i);
                if (bi != null) {
                    this.m.insertBitmap(bi, this.xc, this.yc);
                    return;
                }
                try {
                    Thread.sleep(300 + 100 * i);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static class tileCoordinates {
        int xtile;
        int ytile;
        int zoom;

        public tileCoordinates(double lat, double lon, int zoom) {
            this.zoom = zoom;
            this.xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
            this.ytile = (int)Math.floor((1.0 - Math.log(Math.tan(lat * (Math.PI / 180)) + 1.0 / Math.cos(lat * (Math.PI / 180))) / Math.PI) / 2.0 * (double)(1 << zoom));
        }

        public tileCoordinates(int xtile, int ytile, int zoom) {
            this.zoom = zoom;
            this.xtile = xtile;
            this.ytile = ytile;
        }

        public String url(int retry) {
            int hash = (this.xtile + 7 * this.ytile + 13 * this.zoom + retry) % 4;
            String host = hash == 3 ? "tile.openstreetmap.org" : (char)(97 + hash) + ".tile.openstreetmap.org";
            String url = "https://" + host + "/" + this.zoom + "/" + this.xtile + "/" + this.ytile + ".png";
            return url;
        }
    }
}

