/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.workflow.WorkflowJob;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;

public class Transmission {
    public static final int maxRWIsCount = 1000;
    private final Switchboard env;
    protected ConcurrentLog log;
    protected Segment segment;
    protected SeedDB seeds;
    protected boolean gzipBody4Transfer;
    protected int timeout4Transfer;

    public Transmission(Switchboard env, ConcurrentLog log, boolean gzipBody4Transfer, int timeout4Transfer) {
        this.env = env;
        this.log = log;
        this.segment = env.index;
        this.seeds = env.peers;
        this.gzipBody4Transfer = gzipBody4Transfer;
        this.timeout4Transfer = timeout4Transfer;
    }

    public Chunk newChunk(Seed dhtTarget) {
        return new Chunk(dhtTarget);
    }

    public class Chunk
    extends WorkflowJob
    implements Iterable<ReferenceContainer<WordReference>> {
        private final Seed dhtTarget;
        private final ReferenceContainerCache<WordReference> containers;
        private final HandleSet references;
        private final HandleSet badReferences;

        public Chunk(Seed dhtTarget) {
            this.dhtTarget = dhtTarget;
            this.containers = new ReferenceContainerCache<WordReference>(Segment.wordReferenceFactory, Segment.wordOrder, 12);
            this.references = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0);
            this.badReferences = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0);
        }

        private ReferenceContainer<WordReference> trimContainer(ReferenceContainer<WordReference> container, int max) throws SpaceExceededException {
            ReferenceContainer<WordReference> c = new ReferenceContainer<WordReference>(Segment.wordReferenceFactory, container.getTermHash(), max);
            int part = container.size() / max + 1;
            Random r = new Random();
            ArrayList<byte[]> selected = new ArrayList<byte[]>();
            Iterator<WordReference> i = container.entries();
            while (i.hasNext() && c.size() < max) {
                WordReference w = i.next();
                if (r.nextInt(part) != 0) continue;
                c.add(w);
                selected.add(w.urlhash());
            }
            for (byte[] b : selected) {
                container.removeReference(b);
            }
            try {
                Transmission.this.segment.storeRWI(container);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
            return c;
        }

        public void add(ReferenceContainer<WordReference> container) throws SpaceExceededException {
            WordReference e;
            int remaining = 1000;
            for (ReferenceContainer<WordReference> ic : this) {
                remaining -= ic.size();
            }
            if (remaining <= 0) {
                try {
                    Transmission.this.segment.storeRWI(container);
                }
                catch (Exception e2) {
                    ConcurrentLog.logException(e2);
                }
                return;
            }
            ReferenceContainer<WordReference> c = remaining >= container.size() ? container : this.trimContainer(container, remaining);
            ArrayList<byte[]> notFoundx = new ArrayList<byte[]>();
            HashSet<String> testids = new HashSet<String>();
            Iterator<WordReference> i = c.entries();
            while (i.hasNext()) {
                e = i.next();
                if (this.references.has(e.urlhash())) continue;
                if (this.badReferences.has(e.urlhash())) {
                    notFoundx.add(e.urlhash());
                    continue;
                }
                testids.add(ASCII.String(e.urlhash()));
            }
            i = c.entries();
            while (i.hasNext()) {
                e = i.next();
                if (Transmission.this.segment.fulltext().exists(ASCII.String(e.urlhash()))) {
                    this.references.put(e.urlhash());
                    continue;
                }
                notFoundx.add(e.urlhash());
                this.badReferences.put(e.urlhash());
            }
            for (byte[] b : notFoundx) {
                c.removeReference(b);
            }
            this.containers.add(c);
        }

        @Override
        public Iterator<ReferenceContainer<WordReference>> iterator() {
            return this.containers.iterator();
        }

        public int containersSize() {
            return this.containers.size();
        }

        public Seed dhtTarget() {
            return this.dhtTarget;
        }

        public boolean transmit() {
            if (this.dhtTarget == Transmission.this.seeds.mySeed() || this.dhtTarget.hash.equals(Transmission.this.seeds.mySeed().hash)) {
                this.restore();
                Transmission.this.log.info("Transfer of chunk to myself-target");
                return true;
            }
            Transmission.this.log.info("starting new index transmission request to " + this.dhtTarget.getName());
            long start = System.currentTimeMillis();
            String error = Protocol.transferIndex(Transmission.this.env, this.dhtTarget, this.containers, this.references, Transmission.this.segment, Transmission.this.gzipBody4Transfer, Transmission.this.timeout4Transfer);
            if (error == null) {
                long transferTime = System.currentTimeMillis() - start;
                Iterator<ReferenceContainer<WordReference>> i = this.containers.iterator();
                ReferenceContainer<WordReference> firstContainer = i == null ? null : i.next();
                Transmission.this.log.info("Index transfer of " + this.containers.size() + " references for terms [ " + (firstContainer == null ? null : ASCII.String(firstContainer.getTermHash())) + " ..] and " + this.references.size() + " URLs to peer " + this.dhtTarget.getName() + ":" + this.dhtTarget.hash + " in " + transferTime / 1000L + " seconds successful (" + (long)(1000 * this.containers.size()) / (transferTime + 1L) + " words/s)");
                Transmission.this.seeds.mySeed().incSI(this.containers.size());
                Transmission.this.seeds.mySeed().incSU(this.references.size());
                Transmission.this.log.info("Transfer finished of chunk to target " + this.dhtTarget.hash + "/" + this.dhtTarget.getName());
                return true;
            }
            Transmission.this.log.info("Index transfer to peer " + this.dhtTarget.getName() + ":" + this.dhtTarget.hash + " failed: " + error);
            Transmission.this.log.info("Transfer failed of chunk to target " + this.dhtTarget.hash + "/" + this.dhtTarget.getName() + ": " + error);
            Seed newTarget = Transmission.this.seeds.get(this.dhtTarget.hash);
            if (newTarget != null && this.dhtTarget.clash(newTarget.getIPs())) {
                newTarget.setFlagAcceptRemoteIndex(false);
                Transmission.this.seeds.updateConnected(newTarget);
            }
            return false;
        }

        public void restore() {
            for (ReferenceContainer<WordReference> ic : this) {
                try {
                    Transmission.this.segment.storeRWI(ic);
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
    }
}

