/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import java.nio.channels.ClosedByInterruptException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.workflow.WorkflowThread;

public abstract class AbstractThread
extends Thread
implements WorkflowThread {
    private static ConcurrentLog log = new ConcurrentLog("AbstractThread");
    protected boolean running = true;
    private boolean announcedShutdown = false;
    protected long busytime = 0L;
    protected long memuse = 0L;
    private long blockPause = 0L;
    private String shortDescr = "";
    private String longDescr = "";
    private String monitorURL = null;
    private long threadBlockTimestamp = System.currentTimeMillis();

    public AbstractThread() {
        this.setDaemon(true);
    }

    protected final void announceThreadBlockApply() {
        this.threadBlockTimestamp = System.currentTimeMillis();
    }

    protected final void announceThreadBlockRelease() {
        long thisBlockTime = System.currentTimeMillis() - this.threadBlockTimestamp;
        this.blockPause += thisBlockTime;
        this.busytime -= thisBlockTime;
    }

    @Override
    public final void setDescription(String shortText, String longText, String monitorURL) {
        this.shortDescr = shortText;
        this.longDescr = longText;
        this.monitorURL = monitorURL;
    }

    @Override
    public final String getShortDescription() {
        return this.shortDescr;
    }

    @Override
    public final String getLongDescription() {
        return this.longDescr;
    }

    @Override
    public String getMonitorURL() {
        return this.monitorURL;
    }

    @Override
    public final long getBlockTime() {
        return this.blockPause;
    }

    @Override
    public final long getExecTime() {
        return this.busytime;
    }

    @Override
    public long getMemoryUse() {
        return this.memuse;
    }

    @Override
    public boolean shutdownInProgress() {
        return !this.running || this.announcedShutdown || Thread.currentThread().isInterrupted();
    }

    @Override
    public void terminate(boolean waitFor) {
        this.running = false;
        this.interrupt();
        if (waitFor) {
            try {
                this.join(3000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private final void logError(String text, Throwable thrown) {
        if (log == null) {
            ConcurrentLog.severe("THREAD-CONTROL", text, thrown);
        } else {
            log.severe(text, thrown);
        }
    }

    @Override
    public void jobExceptionHandler(Exception e) {
        if (!(e instanceof ClosedByInterruptException)) {
            this.logError("thread '" + this.getName() + "': " + e.toString(), e);
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

