/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ObjectSpace {
    private static final int minSize = 10;
    private static final int maxSize = 256;
    private static Map<Integer, List<byte[]>> objHeap = new HashMap<Integer, List<byte[]>>();
    private static NavigableMap<Integer, Integer> aliveNow = new TreeMap<Integer, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incAlive(int size) {
        Integer s = size;
        NavigableMap<Integer, Integer> navigableMap = aliveNow;
        synchronized (navigableMap) {
            Integer x = (Integer)aliveNow.get(s);
            if (x == null) {
                aliveNow.put(s, 1);
            } else {
                aliveNow.put(s, x + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decAlive(int size) {
        Integer s = size;
        NavigableMap<Integer, Integer> navigableMap = aliveNow;
        synchronized (navigableMap) {
            Integer x = (Integer)aliveNow.get(s);
            if (x == null) {
                aliveNow.put(s, -1);
            } else {
                aliveNow.put(s, x - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] alloc(int len) {
        if (len < 10 || len > 256) {
            return new byte[len];
        }
        ObjectSpace.incAlive(len);
        Map<Integer, List<byte[]>> map = objHeap;
        synchronized (map) {
            List<byte[]> buf = objHeap.get(len);
            if (buf == null || buf.isEmpty()) {
                return new byte[len];
            }
            return buf.remove(buf.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(byte[] b) {
        if (b.length < 10 || b.length > 256) {
            return;
        }
        ObjectSpace.decAlive(b.length);
        Map<Integer, List<byte[]>> map = objHeap;
        synchronized (map) {
            Integer i = b.length;
            List<byte[]> buf = objHeap.get(i);
            if (buf == null) {
                buf = new ArrayList<byte[]>();
                buf.add(b);
                objHeap.put(i, buf);
            } else {
                buf.add(b);
            }
        }
    }

    public static NavigableMap<Integer, Integer> statAlive() {
        return aliveNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<Integer, Integer> statHeap() {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        Map<Integer, List<byte[]>> map = objHeap;
        synchronized (map) {
            for (Map.Entry<Integer, List<byte[]>> entry2 : objHeap.entrySet()) {
                result.put(entry2.getKey(), entry2.getValue().size());
            }
        }
        return result;
    }
}

