/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.server.serverCore;

public final class OS {
    public static final String blankTypeString = "____";
    private static final System systemOS;
    public static final boolean isMacArchitecture;
    private static final boolean isUnixFS;
    public static final boolean canExecUnix;
    public static final boolean isWindows;
    public static final boolean isWin32;
    public static int maxPathLength;
    public static final Map<String, String> macFSTypeCache;
    public static final Map<String, String> macFSCreatorCache;

    public static String infoString() {
        Object s = "System=";
        s = systemOS == System.Unknown ? (String)s + "unknown" : (systemOS == System.MacOSC ? (String)s + "Mac OS Classic" : (systemOS == System.MacOSX ? (String)s + "Mac OS X" : (systemOS == System.Unix ? (String)s + "Unix/Linux" : (systemOS == System.Windows ? (String)s + "Windows" : (String)s + "unknown"))));
        if (isMacArchitecture) {
            s = (String)s + ", Mac System Architecture";
        }
        if (isUnixFS) {
            s = (String)s + ", has Unix-like File System";
        }
        if (canExecUnix) {
            s = (String)s + ", can execute Unix-Shell Commands";
        }
        return s;
    }

    public static String infoKey() {
        Object s = "";
        s = systemOS == System.Unknown ? (String)s + "o" : (systemOS == System.MacOSC ? (String)s + "c" : (systemOS == System.MacOSX ? (String)s + "x" : (systemOS == System.Unix ? (String)s + "u" : (systemOS == System.Windows ? (String)s + "w" : (String)s + "o"))));
        if (isMacArchitecture) {
            s = (String)s + "m";
        }
        if (isUnixFS) {
            s = (String)s + "f";
        }
        if (canExecUnix) {
            s = (String)s + "e";
        }
        return s;
    }

    public static void deployScript(File scriptFile, String theScript) throws IOException {
        FileUtils.copy(UTF8.getBytes(theScript), scriptFile);
        if (!isWindows) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "755", scriptFile.getAbsolutePath().replaceAll(" ", "\\ ")}).waitFor();
            }
            catch (InterruptedException e) {
                ConcurrentLog.severe("DEPLOY", "deploy of script file failed. file = " + scriptFile.getAbsolutePath(), e);
                throw new IOException(e.getMessage());
            }
        }
    }

    public static int getPID() {
        String pids = ManagementFactory.getRuntimeMXBean().getName();
        int p = pids.indexOf(64);
        return p >= 0 ? NumberTools.parseIntDecSubstring(pids, 0, p) : -1;
    }

    public static void execAsynchronous(File scriptFile) throws IOException {
        String starterFileExtension = null;
        String script = null;
        if (isWindows) {
            starterFileExtension = ".starter.bat";
            script = "start /MIN CMD /C \"" + scriptFile.getAbsolutePath() + "\"";
        } else {
            starterFileExtension = ".starter.sh";
            script = "#!/bin/sh" + serverCore.LF_STRING + scriptFile.getAbsolutePath().replaceAll(" ", "\\ ") + " &" + serverCore.LF_STRING;
        }
        File starterFile = new File(scriptFile.getAbsolutePath().replaceAll(" ", "\\ ") + starterFileExtension);
        OS.deployScript(starterFile, script);
        try {
            Runtime.getRuntime().exec(new String[]{starterFile.getAbsolutePath().replaceAll(" ", "\\ ")}).waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        FileUtils.deletedelete(starterFile);
    }

    public static List<String> execSynchronous(String[] command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        return OS.readStreams(p);
    }

    public static List<String> readStreams(Process p) throws IOException {
        String line;
        BufferedReader in;
        ArrayList<String> output = new ArrayList<String>();
        if (p == null) {
            return output;
        }
        try (InputStreamReader streamReader = new InputStreamReader(p.getInputStream());){
            in = new BufferedReader(streamReader);
            try {
                while ((line = in.readLine()) != null) {
                    output.add(line);
                }
            }
            finally {
                in.close();
            }
        }
        streamReader = new InputStreamReader(p.getErrorStream());
        try {
            in = new BufferedReader(streamReader);
            try {
                while ((line = in.readLine()) != null) {
                    output.add(line);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            streamReader.close();
        }
        return output;
    }

    public static void main(String[] args) {
        try {
            List<String> v = OS.execSynchronous(new String[]{"/usr/local/bin/wkhtmltoimage"});
            for (String r : v) {
                java.lang.System.out.println(r);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        maxPathLength = 65535;
        macFSTypeCache = new HashMap<String, String>();
        macFSCreatorCache = new HashMap<String, String>();
        Properties sysprop = java.lang.System.getProperties();
        String sysname = sysprop.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        systemOS = sysname.startsWith("mac os x") ? System.MacOSX : (sysname.startsWith("mac os") ? System.MacOSC : (sysname.startsWith("windows") ? System.Windows : (sysname.startsWith("linux") || sysname.startsWith("unix") ? System.Unix : System.Unknown)));
        isMacArchitecture = systemOS == System.MacOSC || systemOS == System.MacOSX;
        isUnixFS = systemOS == System.MacOSX || systemOS == System.Unix;
        canExecUnix = isUnixFS || systemOS != System.MacOSC && systemOS != System.Windows;
        isWindows = systemOS == System.Windows;
        isWin32 = isWindows && java.lang.System.getProperty("os.arch", "").contains("x86");
        maxPathLength = isWindows ? 255 : 65535;
    }

    public static enum System {
        MacOSC,
        MacOSX,
        Unix,
        Windows,
        Unknown;

    }
}

