/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.GenerationMemoryStrategy;
import net.yacy.kelondro.util.MemoryStrategy;
import net.yacy.kelondro.util.StandardMemoryStrategy;

public class MemoryControl {
    private static AtomicBoolean shortStatus = new AtomicBoolean(false);
    private static boolean simulatedShortStatus = false;
    private static boolean usingStandardStrategy = true;
    private static MemoryStrategy strategy;

    private static MemoryStrategy getStrategy() {
        if (strategy == null || MemoryStrategy.hasError()) {
            if (!usingStandardStrategy) {
                strategy = new GenerationMemoryStrategy();
                if (MemoryStrategy.hasError()) {
                    usingStandardStrategy = true;
                    strategy = new StandardMemoryStrategy();
                }
            } else {
                strategy = new StandardMemoryStrategy();
            }
        }
        return strategy;
    }

    public static final void setStandardStrategy(boolean std) {
        if (usingStandardStrategy != std) {
            usingStandardStrategy = std;
            strategy = null;
        }
    }

    public static final String getStrategyName() {
        MemoryControl.getStrategy();
        return MemoryStrategy.getName();
    }

    public static final synchronized boolean gc(int last, String info) {
        return MemoryControl.getStrategy().gc(last, info);
    }

    public static final long free() {
        return MemoryControl.getStrategy().free();
    }

    public static final long available() {
        long available = MemoryControl.getStrategy().available();
        return available;
    }

    public static final long maxMemory() {
        return MemoryControl.getStrategy().maxMemory();
    }

    public static final long total() {
        return MemoryControl.getStrategy().total();
    }

    public static boolean request(long size, boolean force) {
        if (size < 1024L) {
            return true;
        }
        return MemoryControl.getStrategy().request(size, force, shortStatus);
    }

    public static void setSimulatedShortStatus(boolean status) {
        simulatedShortStatus = status;
    }

    public static boolean getSimulatedShortStatus() {
        return simulatedShortStatus;
    }

    public static boolean shortStatus() {
        return simulatedShortStatus || shortStatus.get();
    }

    public static long used() {
        return MemoryControl.getStrategy().used();
    }

    public static boolean properState() {
        return MemoryControl.getStrategy().properState();
    }

    public static void resetProperState() {
        MemoryControl.getStrategy().resetProperState();
    }

    public static void setProperMbyte(long mbyte) {
        MemoryControl.getStrategy().setProperMbyte(mbyte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long beginTime = System.nanoTime();
        int i = 0;
        try {
            int mb = 0x100000;
            boolean force = false;
            for (String arg : args) {
                if (arg.equals("force")) {
                    force = true;
                }
                if (arg.equalsIgnoreCase("gen")) {
                    usingStandardStrategy = false;
                }
                if (!arg.equalsIgnoreCase("std")) continue;
                usingStandardStrategy = true;
            }
            System.out.println("vm: " + System.getProperty("java.vm.version"));
            System.out.println("computed max = " + MemoryControl.maxMemory() / 0x100000L + " mb");
            System.out.println("using " + MemoryControl.getStrategyName());
            if (force) {
                System.out.println("forcing garbage collector when requesting");
            } else {
                System.out.println("not forcing garbage collector when requesting");
            }
            byte[][] x = new byte[100000][];
            for (i = 0; i < 100000; ++i) {
                if (!MemoryControl.request(0x100000L, force)) {
                    System.out.println("No more memory available!");
                    break;
                }
                x[i] = new byte[0x100000];
                System.out.println("used = " + i + " / " + MemoryControl.used() / 0x100000L + ", total = " + MemoryControl.total() / 0x100000L + ", free = " + MemoryControl.free() / 0x100000L + ", max = " + MemoryControl.maxMemory() / 0x100000L + ", avail = " + MemoryControl.available() / 0x100000L + (String)(usingStandardStrategy ? ", averageGC = " + ((StandardMemoryStrategy)MemoryControl.getStrategy()).getAverageGCFree() : ""));
            }
        }
        finally {
            long time = System.nanoTime() - beginTime;
            System.out.println("Test run in " + time / 1000000L + " ms");
            ConcurrentLog.shutdown();
            System.out.println("Succesfull requests : " + i);
        }
    }
}

