/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ISO639 {
    private static final String[] codes = new String[]{"aa-Afar", "ab-Abkhazian", "ae-Avestan", "af-Afrikaans", "ak-Akan", "am-Amharic", "an-Aragonese", "ar-Arabic", "as-Assamese", "av-Avaric", "ay-Aymara", "az-Azerbaijani", "ba-Bashkir", "be-Belarusian", "bg-Bulgarian", "bh-Bihari", "bi-Bislama", "bm-Bambara", "bn-Bengali", "bo-Tibetan", "br-Breton", "bs-Bosnian", "ca-Catalan", "ce-Chechen", "ch-Chamorro", "co-Corsican", "cr-Cree", "cs-Czech", "cu-Church Slavic", "cv-Chuvash", "cy-Welsh", "da-Danish", "de-German", "dv-Dhivehi", "dz-Dzongkha", "ee-Ewe", "el-Modern Greek (1453-)", "en-English", "eo-Esperanto", "es-Spanish", "et-Estonian", "eu-Basque", "fa-Persian", "ff-Fulah", "fi-Finnish", "fj-Fijian", "fo-Faroese", "fr-French", "fy-Western Frisian", "ga-Irish", "gd-Scottish Gaelic", "gl-Galician", "gn-Guarani", "gu-Gujarati", "gv-Manx", "ha-Hausa", "he-Hebrew", "hi-Hindi", "ho-Hiri Motu", "hr-Croatian", "ht-Haitian", "hu-Hungarian", "hy-Armenian", "hz-Herero", "ia-Interlingua", "id-Indonesian", "ie-Interlingue", "ig-Igbo", "ii-Sichuan Yi", "ik-Inupiaq", "in-Indonesian", "io-Ido", "is-Icelandic", "it-Italian", "iu-Inuktitut", "iw-Hebrew", "ja-Japanese", "ji-Yiddish", "jv-Javanese", "ka-Georgian", "kg-Kongo", "ki-Kikuyu", "kj-Kuanyama", "kk-Kazakh", "kl-Kalaallisut; Greenlandic", "km-Central Khmer", "kn-Kannada", "ko-Korean", "kr-Kanuri", "ks-Kashmiri", "ku-Kurdish", "kv-Komi", "kw-Cornish", "ky-Kirghiz", "la-Latin", "lb-Luxembourgish", "lg-Ganda", "li-Limburgan", "ln-Lingala", "lo-Lao", "lt-Lithuanian", "lu-Luba-Katanga", "lv-Latvian", "mg-Malagasy", "mh-Marshallese", "mi-Maori", "mk-Macedonian", "ml-Malayalam", "mn-Mongolian", "mr-Marathi", "ms-Malay", "mt-Maltese", "my-Burmese", "na-Nauru", "nb-Norwegian Bokm\u00e5l", "nd-North Ndebele", "ne-Nepali", "ng-Ndonga", "nl-Dutch", "nn-Norwegian Nynorsk", "no-Norwegian", "nr-South Ndebele", "nv-Navajo", "ny-Nyanja", "oc-Occitan (post 1500)", "oj-Ojibwa", "om-Oromo", "or-Oriya", "os-Ossetian", "pa-Panjabi; Punjabi", "pi-Pali", "pl-Polish", "ps-Pushto; Pashto", "pt-Portuguese", "qu-Quechua", "rm-Romansh", "rn-Rundi", "ro-Romanian", "ru-Russian", "rw-Kinyarwanda", "sa-Sanskrit", "sc-Sardinian", "sd-Sindhi", "se-Northern Sami", "sg-Sango", "sh-Serbo-Croatian", "si-Sinhala; Sinhalese", "sk-Slovak", "sl-Slovenian", "sm-Samoan", "sn-Shona", "so-Somali", "sq-Albanian", "sr-Serbian", "ss-Swati", "st-Southern Sotho", "su-Sundanese", "sv-Swedish", "sw-Swahili", "ta-Tamil", "te-Telugu", "tg-Tajik", "th-Thai", "ti-Tigrinya", "tk-Turkmen", "tl-Tagalog", "tn-Tswana", "to-Tonga (Tonga Islands)", "tr-Turkish", "ts-Tsonga", "tt-Tatar", "tw-Twi", "ty-Tahitian", "ug-Uighur", "uk-Ukrainian", "ur-Urdu", "uz-Uzbek", "ve-Venda", "vi-Vietnamese", "vo-Volap\u00fck", "wa-Walloon", "wo-Wolof", "xh-Xhosa", "yi-Yiddish", "yo-Yoruba", "za-Zhuang", "zh-Chinese", "zu-Zulu"};
    private static Map<String, String> mapping = new ConcurrentHashMap<String, String>(codes.length);

    public static final String country(String code) {
        return mapping.get(code.toLowerCase(Locale.ROOT));
    }

    public static final boolean exists(String code) {
        if (code == null) {
            return false;
        }
        return mapping.containsKey(code.toLowerCase(Locale.ROOT));
    }

    public static final String userAgentLanguageDetection(String userAgent) {
        int p;
        if (userAgent == null || userAgent.length() < 2) {
            return null;
        }
        if (mapping.containsKey((userAgent = userAgent.toLowerCase(Locale.ROOT)).substring(0, 2))) {
            return userAgent.substring(0, 2);
        }
        if (userAgent.length() == 2 && mapping.containsKey(userAgent)) {
            return userAgent;
        }
        if (userAgent.length() == 5 && mapping.containsKey(userAgent.substring(0, 2))) {
            return userAgent.substring(0, 2);
        }
        for (p = 2; p < userAgent.length() - 1 && (p = userAgent.indexOf(45, p)) > 2; ++p) {
            if (userAgent.charAt(p - 3) != ' ' || !mapping.containsKey(userAgent.substring(p - 2, p))) continue;
            return userAgent.substring(p - 2, p);
        }
        for (p = 1; p < userAgent.length() - 1 && (p = userAgent.indexOf(59, p)) > 2; ++p) {
            if (userAgent.charAt(p - 3) != ' ' || !mapping.containsKey(userAgent.substring(p - 2, p))) continue;
            return userAgent.substring(p - 2, p);
        }
        return null;
    }

    static {
        for (int i = 0; i < codes.length; ++i) {
            mapping.put(codes[i].substring(0, 2), codes[i].substring(3));
        }
    }
}

