/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.kelondro.util.FileUtils;

public class BDecoder {
    private static final byte[] _e = "e".getBytes();
    private static final byte[] _i = "i".getBytes();
    private static final byte[] _d = "d".getBytes();
    private static final byte[] _l = "l".getBytes();
    private static final byte[] _p = ":".getBytes();
    private final byte[] b;
    private int pos;

    public BDecoder(byte[] b) {
        this.b = b;
        this.pos = 0;
    }

    private Map<String, BObject> convertToMap(List<BObject> list2) {
        LinkedHashMap<String, BObject> m = new LinkedHashMap<String, BObject>();
        int length = list2.size();
        for (int i = 0; i < length; i += 2) {
            byte[] key = list2.get(i).getString();
            BObject value = null;
            if (i + 1 < length) {
                value = list2.get(i + 1);
            }
            m.put(UTF8.String(key), value);
        }
        return m;
    }

    private List<BObject> readList() {
        ArrayList<BObject> list2 = new ArrayList<BObject>();
        char ch = (char)this.b[this.pos];
        while (ch != 'e') {
            BObject bo = this.parse();
            if (bo == null) {
                ++this.pos;
                break;
            }
            list2.add(bo);
            ch = (char)this.b[this.pos];
        }
        ++this.pos;
        return list2;
    }

    public BObject parse() {
        if (this.pos >= this.b.length) {
            return null;
        }
        char ch = (char)this.b[this.pos];
        if (ch >= '0' && ch <= '9') {
            int end = this.pos;
            ++end;
            while (this.b[end] != 58) {
                ++end;
            }
            int len = Integer.parseInt(ASCII.String(this.b, this.pos, end - this.pos));
            byte[] s = new byte[len];
            System.arraycopy(this.b, end + 1, s, 0, len);
            this.pos = end + len + 1;
            return new BStringObject(s);
        }
        if (ch == 'l') {
            ++this.pos;
            return new BListObject(this.readList());
        }
        if (ch == 'd') {
            ++this.pos;
            return new BDictionaryObject(this.convertToMap(this.readList()));
        }
        if (ch == 'i') {
            ++this.pos;
            int end = this.pos;
            while (this.b[end] != 101) {
                ++end;
            }
            BIntegerObject io = new BIntegerObject(Long.parseLong(UTF8.String(this.b, this.pos, end - this.pos)));
            this.pos = end + 1;
            return io;
        }
        return null;
    }

    private static void print(BObject bo, int t) {
        int i;
        for (i = 0; i < t; ++i) {
            System.out.print(" ");
        }
        if (bo.getType() == BType.integer) {
            System.out.println(bo.getInteger());
        }
        if (bo.getType() == BType.string) {
            System.out.println(bo.getString());
        }
        if (bo.getType() == BType.list) {
            System.out.println("[");
            for (BObject o : bo.getList()) {
                BDecoder.print(o, t + 1);
            }
            for (i = 0; i < t; ++i) {
                System.out.print(" ");
            }
            System.out.println("]");
        }
        if (bo.getType() == BType.dictionary) {
            System.out.println("{");
            for (Map.Entry<String, BObject> e : bo.getMap().entrySet()) {
                for (int i2 = 0; i2 < t + 1; ++i2) {
                    System.out.print(" ");
                }
                System.out.print(e.getKey());
                System.out.println(":");
                BDecoder.print(e.getValue(), t + 2);
            }
            for (int i3 = 0; i3 < t; ++i3) {
                System.out.print(" ");
            }
            System.out.println("}");
        }
    }

    public static void main(String[] args) {
        try {
            byte[] b = FileUtils.read(new File(args[0]));
            BDecoder bdecoder = new BDecoder(b);
            BObject o = bdecoder.parse();
            BDecoder.print(o, 0);
            System.out.println("Object: " + o.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface BObject {
        public BType getType();

        public byte[] getString();

        public long getInteger();

        public List<BObject> getList();

        public Map<String, BObject> getMap();

        public String toString();

        public void toStream(OutputStream var1) throws IOException;
    }

    public static class BStringObject
    extends BDfltObject
    implements BObject {
        private byte[] b;

        public BStringObject(byte[] b) {
            this.b = b;
        }

        @Override
        public BType getType() {
            return BType.string;
        }

        @Override
        public byte[] getString() {
            return this.b;
        }

        @Override
        public String toString() {
            return UTF8.String(this.b);
        }

        @Override
        public void toStream(OutputStream os) throws IOException {
            os.write(ASCII.getBytes(Integer.toString(this.b.length)));
            os.write(_p);
            os.write(this.b);
        }

        private static void toStream(OutputStream os, byte[] b) throws IOException {
            os.write(ASCII.getBytes(Integer.toString(b.length)));
            os.write(_p);
            os.write(b);
        }

        private static void toStream(OutputStream os, String s) throws IOException {
            byte[] b = UTF8.getBytes(s);
            os.write(ASCII.getBytes(Integer.toString(b.length)));
            os.write(_p);
            os.write(b);
        }
    }

    public static class BListObject
    extends BDfltObject
    implements BObject {
        private List<BObject> l;

        public BListObject(List<BObject> l) {
            this.l = l;
        }

        @Override
        public BType getType() {
            return BType.list;
        }

        @Override
        public List<BObject> getList() {
            return this.l;
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder(this.l.size() * 40 + 1);
            s.append("[");
            for (BObject o : this.l) {
                s.append(o.toString()).append(",");
            }
            s.setLength(s.length() - 1);
            s.append("]");
            return s.toString();
        }

        @Override
        public void toStream(OutputStream os) throws IOException {
            os.write(_l);
            for (BObject bo : this.l) {
                bo.toStream(os);
            }
            os.write(_e);
        }
    }

    public static class BDictionaryObject
    extends BDfltObject
    implements BObject {
        private Map<String, BObject> m;

        public BDictionaryObject(Map<String, BObject> m) {
            this.m = m;
        }

        @Override
        public BType getType() {
            return BType.dictionary;
        }

        @Override
        public Map<String, BObject> getMap() {
            return this.m;
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder(this.m.size() * 40 + 1);
            s.append('{');
            for (Map.Entry<String, BObject> e : this.m.entrySet()) {
                s.append(e.getKey()).append(':').append(e.getValue().toString()).append(',');
            }
            s.setLength(s.length() - 1);
            s.append('}');
            return s.toString();
        }

        @Override
        public void toStream(OutputStream os) throws IOException {
            os.write(_d);
            for (Map.Entry<String, BObject> e : this.m.entrySet()) {
                BStringObject.toStream(os, e.getKey());
                e.getValue().toStream(os);
            }
            os.write(_e);
        }

        public static void toStream(OutputStream os, String key, byte[] value) throws IOException {
            os.write(_d);
            BStringObject.toStream(os, key);
            BStringObject.toStream(os, value);
            os.write(_e);
        }
    }

    public static class BIntegerObject
    extends BDfltObject
    implements BObject {
        private long i;

        private BIntegerObject(long i) {
            this.i = i;
        }

        @Override
        public BType getType() {
            return BType.integer;
        }

        @Override
        public long getInteger() {
            return this.i;
        }

        @Override
        public String toString() {
            return Long.toString(this.i);
        }

        @Override
        public void toStream(OutputStream os) throws IOException {
            os.write(_i);
            os.write(ASCII.getBytes(Long.toString(this.i)));
            os.write(_e);
        }
    }

    public static enum BType {
        string,
        integer,
        list,
        dictionary;

    }

    private static abstract class BDfltObject
    implements BObject {
        private BDfltObject() {
        }

        @Override
        public long getInteger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BObject> getList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, BObject> getMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            throw new UnsupportedOperationException();
        }
    }
}

