/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;

public class ChunkIterator
extends LookAheadIterator<byte[]>
implements Iterator<byte[]> {
    private final int chunksize;
    private final DataInputStream stream;
    private final int recordsize;

    public ChunkIterator(File file, int recordsize, int chunksize) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        assert (file.exists());
        assert (file.length() % (long)recordsize == 0L);
        this.recordsize = recordsize;
        this.chunksize = chunksize;
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 65536));
    }

    public void close() throws IOException {
        this.stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] next0() {
        byte[] chunk = new byte[this.chunksize];
        byte[] result = null;
        try {
            int s;
            this.stream.readFully(chunk);
            boolean skipError = false;
            for (int r = this.chunksize; r < this.recordsize; r += s) {
                s = (int)this.stream.skip(this.recordsize - r);
                assert (s > 0);
                if (s > 0) continue;
                skipError = true;
                break;
            }
            if (!skipError) {
                result = chunk;
            }
        }
        catch (EOFException e) {
            result = null;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            result = null;
        }
        finally {
            if (result == null) {
                try {
                    this.stream.close();
                }
                catch (IOException ex) {
                    ConcurrentLog.logException(ex);
                }
            }
        }
        return result;
    }
}

