/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.document.parser.html.CharacterCoding;

public final class CharBuffer
extends Writer {
    public static final char singlequote = '\'';
    public static final char doublequote = '\"';
    public static final char equal = '=';
    private char[] buffer;
    private int offset;
    private int length;
    private final int maximumLength;
    private boolean overflow;
    private static final char SPACE = ' ';
    private static final char CR = '\r';
    private static final char LF = '\n';

    public CharBuffer(int maximumLength) {
        this.buffer = new char[10];
        this.length = 0;
        this.offset = 0;
        this.maximumLength = maximumLength;
        this.overflow = false;
    }

    public CharBuffer(int maximumLength, int initLength) {
        this.buffer = new char[initLength];
        this.length = 0;
        this.offset = 0;
        this.maximumLength = maximumLength;
        this.overflow = false;
    }

    public CharBuffer(int maximumLength, char[] bb) {
        this.buffer = bb;
        this.length = bb.length;
        this.offset = 0;
        this.maximumLength = maximumLength;
        this.overflow = false;
    }

    public CharBuffer(int maximumLength, char[] bb, int initLength) {
        this.buffer = new char[initLength];
        System.arraycopy(bb, 0, this.buffer, 0, bb.length);
        this.length = bb.length;
        this.offset = 0;
        this.maximumLength = maximumLength;
        this.overflow = false;
    }

    public CharBuffer(File f) throws IOException {
        if (f.length() > Integer.MAX_VALUE) {
            throw new IOException("file is too large for buffering");
        }
        this.maximumLength = Integer.MAX_VALUE;
        this.length = 0;
        this.buffer = new char[(int)f.length() * 2];
        this.offset = 0;
        this.overflow = false;
        try (FileReader fr = null;){
            int c;
            fr = new FileReader(f);
            char[] temp = new char[256];
            while ((c = fr.read(temp)) > 0) {
                this.append(temp, 0, c);
            }
        }
    }

    public void clear() {
        this.buffer = new char[0];
        this.length = 0;
        this.offset = 0;
        this.overflow = false;
    }

    public int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    private void grow(int minSize) {
        int newsize = 12 * Math.max(this.buffer.length, minSize) / 10;
        char[] tmp = new char[newsize];
        System.arraycopy(this.buffer, this.offset, tmp, 0, this.length);
        this.buffer = tmp;
        this.offset = 0;
    }

    @Override
    public void write(int b) {
        this.write((char)b);
    }

    public void write(char b) {
        if (this.buffer.length > this.maximumLength) {
            this.overflow = true;
            return;
        }
        if (this.offset + this.length + 1 > this.buffer.length) {
            this.grow(this.offset + this.length + 1);
        }
        this.buffer[this.offset + this.length++] = b;
    }

    @Override
    public void write(char[] bb) {
        this.write(bb, 0, bb.length);
    }

    @Override
    public void write(char[] bb, int of, int le) {
        if (this.buffer.length > this.maximumLength) {
            this.overflow = true;
            return;
        }
        if (this.offset + this.length + le > this.buffer.length) {
            this.grow(this.offset + this.length + le);
        }
        System.arraycopy(bb, of, this.buffer, this.offset + this.length, le);
        this.length += le;
    }

    public CharBuffer appendSpace() {
        this.write(' ');
        return this;
    }

    public CharBuffer appendCR() {
        this.write('\r');
        return this;
    }

    public CharBuffer appendLF() {
        this.write('\n');
        return this;
    }

    public CharBuffer append(int i) {
        this.write((char)i);
        return this;
    }

    public CharBuffer append(char[] bb) {
        this.write(bb, 0, bb.length);
        return this;
    }

    public CharBuffer append(char[] bb, int of, int le) {
        this.write(bb, of, le);
        return this;
    }

    @Override
    public CharBuffer append(char c) {
        this.write(c);
        return this;
    }

    public CharBuffer append(String s) {
        char[] temp = new char[s.length()];
        s.getChars(0, temp.length, temp, 0);
        this.write(temp, 0, temp.length);
        return this;
    }

    public CharBuffer append(String s, int off, int len) {
        char[] temp = new char[len];
        s.getChars(off, off + len, temp, 0);
        this.write(temp, 0, len);
        return this;
    }

    public CharBuffer append(CharBuffer bb) {
        this.write(bb.buffer, bb.offset, bb.length);
        return this;
    }

    public char charAt(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pos > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + pos];
    }

    public void deleteCharAt(int pos) {
        if (pos < 0) {
            return;
        }
        if (pos >= this.length) {
            return;
        }
        if (pos == this.length - 1) {
            --this.length;
        } else {
            System.arraycopy(this.buffer, this.offset + pos + 1, this.buffer, this.offset + pos, this.length - pos - 1);
        }
    }

    public int indexOf(char b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(char[] bs) {
        return this.indexOf(bs, 0);
    }

    public int indexOf(char b, int start) {
        if (start >= this.length) {
            return -1;
        }
        for (int i = start; i < this.length; ++i) {
            if (this.buffer[this.offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char[] bs, int start) {
        if (start + bs.length > this.length) {
            return -1;
        }
        block0: for (int i = start; i <= this.length - bs.length; ++i) {
            if (this.buffer[this.offset + i] != bs[0]) continue;
            for (int j = 1; j < bs.length; ++j) {
                if (this.buffer[this.offset + i + j] != bs[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] b, char c) {
        return CharBuffer.indexOf(b, 0, c);
    }

    public static int indexOf(char[] b, int offset, char c) {
        for (int i = offset; i < b.length; ++i) {
            if (b[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] b, char[] s) {
        return CharBuffer.indexOf(b, 0, s);
    }

    public static int indexOf(char[] b, int start, char[] bs) {
        if (start + bs.length > b.length) {
            return -1;
        }
        block0: for (int i = start; i <= b.length - bs.length; ++i) {
            if (b[i] != bs[0]) continue;
            for (int j = 1; j < bs.length; ++j) {
                if (b[i + j] != bs[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char b) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.buffer[this.offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public boolean startsWith(char[] bs) {
        if (this.length < bs.length) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (this.buffer[this.offset + i] == bs[i]) continue;
            return false;
        }
        return true;
    }

    public char[] getChars() {
        return this.getChars(0);
    }

    public char[] getChars(int start) {
        return this.getChars(start, this.length);
    }

    public char[] getChars(int start, int end) {
        if (end > this.length) {
            throw new IndexOutOfBoundsException("getBytes: end > length");
        }
        if (start > this.length) {
            throw new IndexOutOfBoundsException("getBytes: start > length");
        }
        char[] tmp = new char[end - start];
        System.arraycopy(this.buffer, this.offset + start, tmp, 0, end - start);
        return tmp;
    }

    public byte[] getBytes() {
        return UTF8.getBytes(this.toString());
    }

    public CharBuffer trim(int start) {
        if (start > this.length) {
            throw new IndexOutOfBoundsException("trim: start > length");
        }
        this.offset += start;
        this.length -= start;
        return this;
    }

    public CharBuffer trim(int start, int end) {
        if (start > this.length) {
            throw new IndexOutOfBoundsException("trim: start > length");
        }
        if (end > this.length) {
            throw new IndexOutOfBoundsException("trim: end > length");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("trim: start > end");
        }
        this.offset += start;
        this.length = end - start;
        return this;
    }

    public CharBuffer trim() {
        int r;
        int l;
        for (l = 0; l < this.length && this.buffer[this.offset + l] <= ' '; ++l) {
        }
        for (r = this.length; r > 0 && this.buffer[this.offset + r - 1] <= ' '; --r) {
        }
        if (l > r) {
            r = l;
        }
        return this.trim(l, r);
    }

    public boolean isWhitespace(boolean includeNonLetterBytes) {
        if (includeNonLetterBytes) {
            for (int i = 0; i < this.length; ++i) {
                char b = this.buffer[this.offset + i];
                if (!(b >= '0' && b <= '9' || b >= 'A' && b <= 'Z') && (b < 'a' || b > 'z')) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[this.offset + i] <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public int whitespaceStart(boolean includeNonLetterBytes) {
        if (includeNonLetterBytes) {
            for (int i = 0; i < this.length; ++i) {
                char b = this.buffer[this.offset + i];
                if (!(b >= '0' && b <= '9' || b >= 'A' && b <= 'Z') && (b < 'a' || b > 'z')) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[this.offset + i] <= ' ') continue;
                return i;
            }
        }
        return this.length;
    }

    public int whitespaceEnd(boolean includeNonLetterBytes) {
        if (includeNonLetterBytes) {
            for (int i = this.length - 1; i >= 0; --i) {
                char b = this.buffer[this.offset + i];
                if (!(b >= '0' && b <= '9' || b >= 'A' && b <= 'Z') && (b < 'a' || b > 'z')) continue;
                return i + 1;
            }
        } else {
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.buffer[this.offset + i] <= ' ') continue;
                return i + 1;
            }
        }
        return 0;
    }

    public String toString() {
        return new String(this.buffer, this.offset, this.length);
    }

    public String toString(int left, int rightbound) {
        return new String(this.buffer, this.offset + left, rightbound - left);
    }

    public Properties propParser() {
        int pos;
        Properties p = new Properties();
        for (pos = this.offset; pos < this.length && this.buffer[pos] <= ' '; ++pos) {
        }
        while (pos < this.length) {
            int start = pos;
            while (pos < this.length && this.buffer[pos] != '=' && this.buffer[pos] > ' ') {
                ++pos;
            }
            String key = new String(this.buffer, start, pos - start).trim().toLowerCase();
            while (pos < this.length && this.buffer[pos] != '=' && this.buffer[pos] <= ' ') {
                ++pos;
            }
            if (pos >= this.length || this.buffer[pos] != '=') {
                p.setProperty(key, "");
                continue;
            }
            ++pos;
            while (pos < this.length && this.buffer[pos] <= ' ') {
                ++pos;
            }
            String value = null;
            if (pos >= this.length) break;
            if (this.buffer[pos] == '\"') {
                start = ++pos;
                while (pos < this.length && this.buffer[pos] != '\"') {
                    ++pos;
                }
                if (pos >= this.length) break;
                value = new String(this.buffer, start, pos - start).trim();
                ++pos;
            } else if (this.buffer[pos] == '\'') {
                start = ++pos;
                while (pos < this.length && this.buffer[pos] != '\'') {
                    ++pos;
                }
                if (pos >= this.length) break;
                value = new String(this.buffer, start, pos - start).trim();
                ++pos;
            } else {
                start = pos;
                while (pos < this.length && this.buffer[pos] > ' ') {
                    ++pos;
                }
                value = new String(this.buffer, start, pos - start).trim();
            }
            p.setProperty(key, CharacterCoding.html2unicode(value));
            while (pos < this.length && this.buffer[pos] <= ' ') {
                ++pos;
            }
        }
        return p;
    }

    public static boolean equals(char[] buffer, char[] pattern) {
        return CharBuffer.equals(buffer, 0, pattern);
    }

    public static boolean equals(char[] buffer, int offset, char[] pattern) {
        if (buffer.length < offset + pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (buffer[offset + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.length = 0;
        this.offset = 0;
    }

    public void trimToSize() {
        char[] v = new char[this.length];
        System.arraycopy(this.buffer, this.offset, v, 0, this.length);
        this.buffer = v;
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.length];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.length);
        return newbuf;
    }

    @Override
    public synchronized void close() {
        this.length = 0;
        this.offset = 0;
        this.buffer = null;
    }

    @Override
    public void flush() {
        this.trimToSize();
    }
}

