/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.io.AbstractReader;
import net.yacy.kelondro.io.Reader;
import net.yacy.kelondro.util.MemoryControl;

public final class CachedFileReader
extends AbstractReader
implements Reader {
    private final RandomAccessFile RAFile;
    private byte[] cache;
    private final int cachelen;

    public CachedFileReader(File file) throws IOException, FileNotFoundException {
        this.name = file.getName();
        this.file = file;
        this.RAFile = new RandomAccessFile(this.file, "r");
        if (MemoryControl.available() / 10L > this.RAFile.length() && this.RAFile.length() < Integer.MAX_VALUE) {
            this.cache = new byte[(int)this.RAFile.length()];
            this.RAFile.seek(0L);
            this.RAFile.readFully(this.cache);
        } else {
            this.cache = null;
        }
        this.cachelen = 0;
    }

    @Override
    public final synchronized long available() throws IOException {
        return this.length() - this.RAFile.getFilePointer();
    }

    @Override
    public final synchronized long length() throws IOException {
        return this.RAFile.length();
    }

    @Override
    public final synchronized void readFully(byte[] b, int off, int len) throws IOException {
        long seek = this.RAFile.getFilePointer();
        if (this.cache != null && (long)this.cachelen - seek >= (long)len) {
            System.arraycopy(this.cache, (int)seek, b, off, len);
            this.RAFile.seek(seek + (long)len);
            return;
        }
        this.RAFile.readFully(b, off, len);
    }

    @Override
    public final synchronized void seek(long pos) throws IOException {
        this.RAFile.seek(pos);
    }

    @Override
    public final synchronized void close() {
        if (this.RAFile != null) {
            try {
                try {
                    this.RAFile.getChannel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.RAFile.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.cache = null;
    }
}

