/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.yacy.kelondro.io.ByteCount;

public final class ByteCountOutputStream
extends BufferedOutputStream {
    protected long byteCount;
    protected String byteCountAccountName = null;
    private boolean finished = false;

    public ByteCountOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public ByteCountOutputStream(OutputStream outputStream, String accountName) {
        this(outputStream, 0L, accountName);
    }

    public ByteCountOutputStream(OutputStream outputStream, long initByteCount, String accountName) {
        super(outputStream);
        this.byteCount = initByteCount;
        this.byteCountAccountName = accountName;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        super.write(b);
        this.byteCount += (long)b.length;
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.byteCount += (long)len;
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        super.write(b);
        ++this.byteCount;
    }

    public final long getCount() {
        return this.byteCount;
    }

    public String getAccountName() {
        return this.byteCountAccountName;
    }

    public final void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        ByteCount.addAccountCount(this.byteCountAccountName, this.byteCount);
    }
}

