/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.SetTools;

public final class RowHandleSet
implements HandleSet,
Iterable<byte[]>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 444204785291174968L;
    private final Row rowdef;
    private RowSet index;

    public RowHandleSet(int keylength, ByteOrder objectOrder, int expectedspace) {
        this.rowdef = new Row(new Column[]{new Column("key", 2, 3, keylength, "key")}, objectOrder);
        try {
            this.index = new RowSet(this.rowdef, expectedspace);
        }
        catch (SpaceExceededException e) {
            try {
                this.index = new RowSet(this.rowdef, 0);
            }
            catch (SpaceExceededException ee) {
                ConcurrentLog.logException(ee);
                this.index = null;
            }
        }
    }

    private RowHandleSet(Row rowdef, RowSet index2) {
        this.rowdef = rowdef;
        this.index = index2;
    }

    public RowHandleSet(Row rowdef, byte[] b) throws SpaceExceededException {
        this.rowdef = rowdef;
        this.index = RowSet.importRowSet(b, this.rowdef);
    }

    @Override
    public RowHandleSet clone() {
        this.optimize();
        return new RowHandleSet(this.rowdef, this.index.clone());
    }

    @Override
    public byte[] export() {
        return this.index.exportCollection();
    }

    @Override
    public void optimize() {
        this.index.sort();
        this.index.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowHandleSet(int keylength, ByteOrder objectOrder, File file) throws IOException, SpaceExceededException {
        this(keylength, objectOrder, (int)(file.length() / (long)(keylength + 8)));
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream is = null;
        try {
            int c;
            is = new BufferedInputStream(fis, 0x100000);
            byte[] a = new byte[keylength];
            while ((c = ((InputStream)is).read(a)) > 0) {
                this.index.addUnique(this.rowdef.newEntry(a));
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            } else if (fis != null) {
                fis.close();
            }
        }
        assert ((long)this.index.size() == file.length() / (long)keylength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int dump(File file) throws IOException {
        CloneableIterator<Row.Entry> i = this.index.rows(true, null);
        int c = 0;
        FileOutputStream fileStream = new FileOutputStream(file);
        OutputStream os = null;
        try {
            try {
                os = new BufferedOutputStream(fileStream, 0x100000);
            }
            catch (OutOfMemoryError e) {
                os = fileStream;
            }
            while (i.hasNext()) {
                os.write(((Row.Entry)i.next()).bytes());
                ++c;
            }
            os.flush();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            finally {
                if (fileStream != os) {
                    fileStream.close();
                }
            }
        }
        return c;
    }

    @Override
    public final synchronized byte[] smallestKey() {
        return this.index.smallestKey();
    }

    @Override
    public final synchronized byte[] largestKey() {
        return this.index.largestKey();
    }

    @Override
    public ByteOrder comparator() {
        return this.rowdef.objectOrder;
    }

    public final Row row() {
        return this.index.row();
    }

    @Override
    public int keylen() {
        return this.index.rowdef.primaryKeyLength;
    }

    @Override
    public final void clear() {
        this.index.clear();
    }

    @Override
    public final synchronized boolean has(byte[] key) {
        assert (key != null);
        return this.index.has(key);
    }

    @Override
    public final void putAll(HandleSet aset) throws SpaceExceededException {
        for (byte[] b : aset) {
            this.put(b);
        }
    }

    @Override
    public final boolean put(byte[] key) throws SpaceExceededException {
        assert (key != null);
        Row.Entry newentry = this.index.row().newEntry(key);
        return this.index.put(newentry);
    }

    @Override
    public final void putUnique(byte[] key) throws SpaceExceededException {
        assert (key != null);
        Row.Entry newentry = this.index.row().newEntry(key);
        this.index.addUnique(newentry);
    }

    @Override
    public final boolean remove(byte[] key) {
        assert (key != null);
        Row.Entry indexentry = this.index.remove(key);
        return indexentry != null;
    }

    @Override
    public final synchronized byte[] removeOne() {
        Row.Entry indexentry = this.index.removeOne();
        if (indexentry == null) {
            return null;
        }
        return indexentry.getPrimaryKeyBytes();
    }

    @Override
    public final synchronized byte[] getOne(int idx2) {
        if (idx2 >= this.size()) {
            return null;
        }
        Row.Entry indexentry = this.index.get(this.size() - 1 - idx2, true);
        if (indexentry == null) {
            return null;
        }
        return indexentry.getPrimaryKeyBytes();
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public final synchronized int size() {
        return this.index.size();
    }

    @Override
    public final synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) {
        return this.index.keys(up, firstKey);
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return this.keys(true, null);
    }

    @Override
    public final synchronized void close() {
        this.index.close();
        this.index = null;
    }

    public final String toString() {
        return this.index.toString();
    }

    public HandleSet joinConstructive(HandleSet other) throws SpaceExceededException {
        return RowHandleSet.joinConstructive(this, other);
    }

    public static HandleSet joinConstructive(HandleSet set1, HandleSet set2) throws SpaceExceededException {
        int stepsTest;
        int low;
        if (set1 == null || set2 == null) {
            return null;
        }
        assert (set1.comparator() == set2.comparator());
        if (set1.comparator() != set2.comparator()) {
            return null;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return new RowHandleSet(set1.keylen(), set1.comparator(), 0);
        }
        int high = set1.size() > set2.size() ? set1.size() : set2.size();
        int stepsEnum = 10 * (high + (low = set1.size() > set2.size() ? set2.size() : set1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * SetTools.log2a(high) * low)) {
            if (set1.size() < set2.size()) {
                return RowHandleSet.joinConstructiveByTest(set1, set2);
            }
            return RowHandleSet.joinConstructiveByTest(set2, set1);
        }
        return RowHandleSet.joinConstructiveByEnumeration(set1, set2);
    }

    private static HandleSet joinConstructiveByTest(HandleSet small, HandleSet large) throws SpaceExceededException {
        Iterator<byte[]> mi = small.iterator();
        RowHandleSet result = new RowHandleSet(small.keylen(), small.comparator(), 0);
        while (mi.hasNext()) {
            byte[] o = mi.next();
            if (!large.has(o)) continue;
            result.put(o);
        }
        result.optimize();
        return result;
    }

    private static HandleSet joinConstructiveByEnumeration(HandleSet set1, HandleSet set2) throws SpaceExceededException {
        ByteOrder comp = set1.comparator();
        Iterator<byte[]> mi = set1.iterator();
        Iterator<byte[]> si = set2.iterator();
        RowHandleSet result = new RowHandleSet(set1.keylen(), comp, 0);
        if (mi.hasNext() && si.hasNext()) {
            byte[] mobj = mi.next();
            byte[] sobj = si.next();
            while (true) {
                int c;
                if ((c = comp.compare(mobj, sobj)) < 0) {
                    if (!mi.hasNext()) break;
                    mobj = mi.next();
                    continue;
                }
                if (c > 0) {
                    if (!si.hasNext()) break;
                    sobj = si.next();
                    continue;
                }
                result.put(mobj);
                if (!mi.hasNext()) break;
                mobj = mi.next();
                if (!si.hasNext()) break;
                sobj = si.next();
            }
        }
        result.optimize();
        return result;
    }

    @Override
    public void excludeDestructive(Set<byte[]> other) {
        if (other == null) {
            return;
        }
        if (other.isEmpty()) {
            return;
        }
        if (other.size() > this.size()) {
            for (byte[] b : this) {
                if (!other.contains(b)) continue;
                this.remove(b);
            }
        } else {
            for (byte[] b : other) {
                this.remove(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RowHandleSet s = new RowHandleSet(8, NaturalOrder.naturalOrder, 100);
        try {
            s.put(UTF8.getBytes("Hello"));
            s.put(UTF8.getBytes("World"));
            try {
                File f = File.createTempFile("HandleSet", "stream");
                try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));){
                    out.writeObject(s);
                }
                try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));){
                    RowHandleSet s1 = (RowHandleSet)in.readObject();
                    for (byte[] b : s1) {
                        System.out.println(UTF8.String(b));
                    }
                    s1.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (SpaceExceededException e) {
            e.printStackTrace();
        }
        s.close();
        ConcurrentLog.shutdown();
    }
}

