/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.kelondro.blob.Tables;

public abstract class TablesColumnIndex {
    private INDEXTYPE type;
    protected static final Comparator<byte[]> NATURALORDER = new NaturalOrder(true);

    protected abstract void insertPK(String var1, String var2, byte[] var3);

    protected abstract void removePK(byte[] var1);

    protected abstract void clear();

    public abstract Set<String> keySet(String var1);

    public abstract boolean containsKey(String var1, String var2);

    public abstract boolean hasIndex(String var1);

    public abstract Collection<byte[]> get(String var1, String var2);

    public abstract int size(String var1);

    public abstract int size();

    public abstract Collection<String> columns();

    public abstract void deleteIndex(String var1);

    public TablesColumnIndex(INDEXTYPE type) {
        this.type = type;
    }

    public INDEXTYPE getType() {
        return this.type;
    }

    public synchronized void buildIndex(Map<String, String> columns, Iterator<Tables.Row> table) {
        this.clear();
        while (table.hasNext()) {
            this.add(columns, table.next());
        }
    }

    private void insertPK(String columnName, String[] columnValues, byte[] pk) {
        for (String columnValue : columnValues) {
            this.insertPK(columnName, columnValue, pk);
        }
    }

    public void delete(byte[] pk) {
        this.removePK(pk);
    }

    public void update(String columnName, String separator, Tables.Row row) {
        this.removePK(row.getPK());
        this.add(columnName, separator, row);
    }

    public void update(Map<String, String> columns, Tables.Row row) {
        this.removePK(row.getPK());
        this.add(columns, row);
    }

    public void add(String columnName, String separator, Map<String, String> map, byte[] pk) {
        if (separator.isEmpty()) {
            this.insertPK(columnName, map.get(columnName), pk);
        } else {
            this.insertPK(columnName, map.get(columnName).split(separator), pk);
        }
    }

    public void add(String columnName, String separator, Tables.Data row, byte[] pk) {
        if (separator.isEmpty()) {
            this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)), pk);
        } else {
            this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)).split(separator), pk);
        }
    }

    public void add(String columnName, String separator, Tables.Row row) {
        if (separator.isEmpty()) {
            this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)), row.getPK());
        } else {
            this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)).split(separator), row.getPK());
        }
    }

    public void add(Map<String, String> columns, Map<String, String> map, byte[] pk) {
        for (String columnName : columns.keySet()) {
            if (columns.get(columnName).isEmpty()) {
                this.insertPK(columnName, map.get(columnName), pk);
                continue;
            }
            this.insertPK(columnName, map.get(columnName).split(columns.get(columnName)), pk);
        }
    }

    public void add(Map<String, String> columns, Tables.Data row, byte[] pk) {
        for (String columnName : columns.keySet()) {
            if (columns.get(columnName).isEmpty()) {
                this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)), pk);
                continue;
            }
            this.insertPK(columnName, UTF8.String((byte[])row.get(columnName)).split(columns.get(columnName)), pk);
        }
    }

    public void add(Map<String, String> columns, Tables.Row row) {
        this.add(columns, row, row.getPK());
    }

    public static enum INDEXTYPE {
        RAM,
        BLOB;

    }
}

