/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.util.SortedMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.blob.HeapReader;
import net.yacy.kelondro.io.CachedFileWriter;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;

public class HeapModifier
extends HeapReader
implements BLOB {
    public HeapModifier(File heapFile, int keylength, ByteOrder ordering) throws IOException {
        super(heapFile, keylength, ordering);
    }

    @Override
    public synchronized void clear() throws IOException {
        this.index.clear();
        this.free.clear();
        this.file.close();
        this.file = null;
        FileUtils.deletedelete(this.heapFile);
        super.deleteFingerprint();
        this.file = new CachedFileWriter(this.heapFile);
    }

    @Override
    public synchronized void close(boolean writeIDX) {
        this.shrinkWithGapsAtEnd();
        super.close(writeIDX);
    }

    @Override
    public synchronized void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key) throws IOException {
        if (this.index == null) {
            return;
        }
        long seek = this.index.get(key = this.normalizeKey(key));
        if (seek < 0L) {
            return;
        }
        HeapModifier heapModifier = this;
        synchronized (heapModifier) {
            seek = this.index.get(key);
            if (seek < 0L) {
                return;
            }
            this.file.seek(seek);
            int size = this.file.readInt();
            long filelength = this.file.length();
            if (seek + (long)size + 4L > filelength) {
                ConcurrentLog.severe("KELONDRO", "BLOBHeap: " + this.heapFile.getName() + ": too long size " + size + " in record at " + seek);
                throw new IOException("BLOBHeap: " + this.heapFile.getName() + ": too long size " + size + " in record at " + seek);
            }
            super.deleteFingerprint();
            this.free.put(seek, size);
            int l = size;
            byte[] fill = new byte[size];
            while (l-- > 0) {
                fill[l] = 0;
            }
            this.file.write(fill, 0, size);
            this.index.remove(key);
            this.tryMergeNextGaps(seek, size);
            this.tryMergePreviousGap(seek);
        }
    }

    private void tryMergePreviousGap(long thisSeek) throws IOException {
        int previousSize;
        SortedMap head = this.free.headMap(thisSeek);
        if (head.isEmpty()) {
            return;
        }
        long previousSeek = head.lastKey();
        if (previousSeek + (long)(previousSize = ((Integer)head.get(previousSeek)).intValue()) + 4L == thisSeek) {
            Integer thisSize = (Integer)this.free.get(thisSeek);
            assert (thisSize != null);
            this.mergeGaps(previousSeek, previousSize, thisSeek, thisSize);
        }
    }

    private void tryMergeNextGaps(long thisSeek, int thisSize) throws IOException {
        long nextSeek = thisSeek + (long)thisSize + 4L;
        if (nextSeek >= this.file.length()) {
            return;
        }
        Integer nextSize = (Integer)this.free.get(nextSeek);
        if (nextSize == null) {
            return;
        }
        assert (nextSize > 0);
        if (nextSize == 0) {
            this.mergeGaps(thisSeek, thisSize, nextSeek, 0);
            this.tryMergeNextGaps(thisSeek, thisSize + 4);
        } else {
            this.file.seek(nextSeek + 4L);
            byte[] o = new byte[1];
            this.file.readFully(o, 0, 1);
            byte t = o[0];
            assert (t == 0);
            if (t == 0) {
                this.mergeGaps(thisSeek, thisSize, nextSeek, nextSize);
                this.tryMergeNextGaps(thisSeek, thisSize + 4 + nextSize);
            }
        }
    }

    private void mergeGaps(long seek0, int size0, long seek1, int size1) throws IOException {
        Integer g = (Integer)this.free.remove(seek1);
        assert (g != null);
        assert (g == size1);
        this.file.seek(seek1);
        this.file.writeInt(0);
        int newSize = size0 + 4 + size1;
        this.file.seek(seek0);
        this.file.writeInt(newSize);
        g = this.free.put(seek0, newSize);
        assert (g != null);
        assert (g == size0);
    }

    protected void shrinkWithGapsAtEnd() {
        if (this.free == null) {
            return;
        }
        try {
            while (!this.free.isEmpty()) {
                Long seek = (Long)this.free.lastKey();
                int size = (Integer)this.free.get(seek);
                if (seek + (long)size + 4L != this.file.length()) {
                    return;
                }
                this.file.setLength(seek);
                this.free.remove(seek);
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public void insert(byte[] key, byte[] b) throws IOException {
        throw new UnsupportedOperationException("put is not supported in BLOBHeapModifier");
    }

    @Override
    public int replace(byte[] key, BLOB.Rewriter rewriter) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reduce(byte[] key, BLOB.Reducer reducer) throws IOException, SpaceExceededException {
        key = this.normalizeKey(key);
        assert (key.length == this.keylength);
        long pos = this.index.get(key);
        if (pos < 0L) {
            return 0;
        }
        HeapModifier heapModifier = this;
        synchronized (heapModifier) {
            long m = this.mem();
            pos = this.index.get(key);
            if (pos < 0L) {
                return 0;
            }
            this.file.seek(pos);
            int len = this.file.readInt() - this.keylength;
            if (MemoryControl.available() < (long)len && !MemoryControl.request(len, true)) {
                return 0;
            }
            super.deleteFingerprint();
            byte[] keyf = new byte[this.keylength];
            this.file.readFully(keyf, 0, keyf.length);
            assert (this.ordering == null || this.ordering.equal(key, keyf)) : "key = " + UTF8.String(key) + ", keyf = " + UTF8.String(keyf);
            byte[] blob = new byte[len];
            this.file.readFully(blob, 0, blob.length);
            blob = reducer.rewrite(blob);
            int reduction = len - blob.length;
            if (reduction == 0) {
                this.file.seek(pos + 4L + (long)key.length);
                this.file.write(blob);
                return 0;
            }
            if (blob.length > len - 4) {
                throw new IOException("replace of BLOB for key " + UTF8.String(key) + " failed (too large): new size = " + blob.length + ", old size = " + (len - 4));
            }
            this.file.seek(pos);
            this.file.writeInt(blob.length + key.length);
            this.file.write(key);
            this.file.write(blob);
            int newfreereclen = reduction - 4;
            assert (newfreereclen >= 0);
            this.file.writeInt(newfreereclen);
            int l = newfreereclen;
            byte[] fill = new byte[newfreereclen];
            while (l-- > 0) {
                fill[l] = 0;
            }
            this.file.write(fill, 0, newfreereclen);
            this.free.put(pos + 4L + (long)blob.length + (long)key.length, newfreereclen);
            assert (this.mem() <= m) : "m = " + m + ", mem() = " + this.mem();
            return reduction;
        }
    }
}

