/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.servlets.RAGProxyServlet;
import org.apache.solr.servlet.cache.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MCPSearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 433609077273989355L;
    private static final ConcurrentLog log = new ConcurrentLog("MCPSearchServlet");
    private static final String JSONRPC_VERSION = "2.0";
    private static final String MCP_PROTOCOL_VERSION = "2024-11-05";
    private static final String TOOL_NAME = "search";
    private static final int DEFAULT_RESULT_COUNT = 10;
    private static final int MAX_RESULT_COUNT = 100;

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        log.info("MCPSearchServlet: " + hrequest.getMethod() + " " + hrequest.getRequestURI());
        hresponse.setContentType("application/json;charset=utf-8");
        hresponse.setHeader("Access-Control-Allow-Origin", "*");
        hresponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        hresponse.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        Method reqMethod = Method.getMethod((String)hrequest.getMethod());
        if (reqMethod == Method.OTHER) {
            hresponse.setStatus(200);
            return;
        }
        String body = MCPSearchServlet.readBody(request);
        Object parsed = null;
        if (body.length() == 0) {
            parsed = new JSONObject();
        } else {
            try {
                JSONTokener tokener = new JSONTokener(body);
                parsed = tokener.nextValue();
            }
            catch (JSONException e) {
                MCPSearchServlet.writeJsonResponse(hresponse, MCPSearchServlet.errorResponse(JSONObject.NULL, -32700, e.getMessage()));
            }
        }
        try {
            if (parsed instanceof JSONObject) {
                JSONObject responseObject;
                if (((JSONObject)parsed).optString("method", "").length() == 0) {
                    String uri = hrequest.getRequestURI();
                    ((JSONObject)parsed).put("method", uri.substring(1));
                }
                if ((responseObject = this.handleRequest((JSONObject)parsed)) != null) {
                    MCPSearchServlet.writeJsonResponse(hresponse, responseObject);
                } else {
                    hresponse.setStatus(204);
                }
            } else if (parsed instanceof JSONArray) {
                JSONArray requestArray = (JSONArray)parsed;
                JSONArray responseArray = new JSONArray();
                for (int i = 0; i < requestArray.length(); ++i) {
                    JSONObject responseObject;
                    Object entry2 = requestArray.get(i);
                    if (!(entry2 instanceof JSONObject) || (responseObject = this.handleRequest((JSONObject)entry2)) == null) continue;
                    responseArray.put(responseObject);
                }
                if (responseArray.length() > 0) {
                    MCPSearchServlet.writeJsonResponse(hresponse, responseArray);
                } else {
                    hresponse.setStatus(204);
                }
            } else {
                MCPSearchServlet.writeJsonResponse(hresponse, MCPSearchServlet.errorResponse(JSONObject.NULL, -32600, "Invalid JSON-RPC payload"));
            }
        }
        catch (JSONException e) {
            MCPSearchServlet.writeJsonResponse(hresponse, MCPSearchServlet.errorResponse(JSONObject.NULL, -32700, e.getMessage()));
        }
    }

    private JSONObject handleRequest(JSONObject requestObject) {
        Object id = requestObject.opt("id");
        String jsonrpc = requestObject.optString("jsonrpc", JSONRPC_VERSION);
        String method = requestObject.optString("method", "");
        if (!JSONRPC_VERSION.equals(jsonrpc)) {
            return MCPSearchServlet.errorResponse(id, -32600, "Unsupported JSON-RPC version");
        }
        if (method == null || method.isEmpty()) {
            return MCPSearchServlet.errorResponse(id, -32600, "Missing method");
        }
        int slash = method.indexOf(47);
        int dot = method.indexOf(46);
        if (slash > 0) {
            method = method.substring(slash + 1);
        } else if (dot > 0) {
            method = method.substring(dot + 1);
        }
        if (id == JSONObject.NULL || id == null) {
            if ("ping".equals(method)) {
                return null;
            }
            return null;
        }
        switch (method) {
            case "initialize": {
                return this.handleInitialize(id, requestObject.optJSONObject("params"));
            }
            case "list": {
                return this.handleToolsList(id);
            }
            case "call": {
                return this.handleToolsCall(id, requestObject.optJSONObject("params"));
            }
        }
        return MCPSearchServlet.errorResponse(id, -32601, "Unknown method: " + method);
    }

    private JSONObject handleInitialize(Object id, JSONObject params) {
        try {
            log.info("MCPSearchServlet: initialize " + (params == null ? "" : params.toString(0)));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject result = new JSONObject(true);
        try {
            JSONObject serverInfo = new JSONObject(true);
            serverInfo.put("name", "YaCy MCP Web Search");
            serverInfo.put("version", "1.0");
            JSONObject capabilities = new JSONObject(true);
            JSONObject toolsCapability = new JSONObject(true);
            toolsCapability.put("list", true);
            toolsCapability.put("call", true);
            capabilities.put("tools", toolsCapability);
            result.put("protocolVersion", MCP_PROTOCOL_VERSION);
            result.put("serverInfo", serverInfo);
            result.put("capabilities", capabilities);
        }
        catch (JSONException e) {
            return MCPSearchServlet.errorResponse(id, -32603, e.getMessage());
        }
        return MCPSearchServlet.successResponse(id, result);
    }

    private JSONObject handleToolsList(Object id) {
        log.info("MCPSearchServlet: list " + (id == null ? "" : id.toString()));
        try {
            JSONObject tool = new JSONObject(true);
            tool.put("name", TOOL_NAME);
            tool.put("description", "Search the YaCy index and return the most relevant documents.");
            JSONObject inputProperties = new JSONObject(true);
            JSONObject querySchema = new JSONObject(true);
            querySchema.put("type", "string");
            querySchema.put("description", "Search query to execute against the YaCy index.");
            inputProperties.put("query", querySchema);
            JSONObject limitSchema = new JSONObject(true);
            limitSchema.put("type", "integer");
            limitSchema.put("minimum", 1);
            limitSchema.put("maximum", 100);
            limitSchema.put("description", "Maximum number of results to return.");
            inputProperties.put("limit", limitSchema);
            JSONObject includeSnippetSchema = new JSONObject(true);
            includeSnippetSchema.put("type", "boolean");
            includeSnippetSchema.put("description", "Include text snippets extracted from the indexed document content.");
            inputProperties.put("include_snippet", includeSnippetSchema);
            JSONObject inputSchema = new JSONObject(true);
            inputSchema.put("type", "object");
            inputSchema.put("properties", inputProperties);
            JSONArray required = new JSONArray();
            required.put("query");
            inputSchema.put("required", required);
            tool.put("inputSchema", inputSchema);
            JSONObject outputSchema = new JSONObject(true);
            outputSchema.put("type", "object");
            JSONObject outputProperties = new JSONObject(true);
            JSONObject resultsSchema = new JSONObject(true);
            resultsSchema.put("type", "array");
            resultsSchema.put("description", "Ordered list of search results.");
            outputProperties.put("results", resultsSchema);
            outputSchema.put("properties", outputProperties);
            tool.put("outputSchema", outputSchema);
            JSONArray tools = new JSONArray();
            tools.put(tool);
            JSONObject result = new JSONObject(true);
            result.put("tools", tools);
            return MCPSearchServlet.successResponse(id, result);
        }
        catch (JSONException e) {
            return MCPSearchServlet.errorResponse(id, -32603, e.getMessage());
        }
    }

    private JSONObject handleToolsCall(Object id, JSONObject params) {
        try {
            log.info("MCPSearchServlet: call " + (id == null ? "" : id.toString()) + " params: " + (params == null ? "" : params.toString(0)));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (params == null) {
            return MCPSearchServlet.errorResponse(id, -32602, "Missing params");
        }
        String name = params.optString("name", "");
        if (!TOOL_NAME.equals(name)) {
            return MCPSearchServlet.errorResponse(id, -32601, "Unknown tool: " + name);
        }
        JSONObject arguments = params.optJSONObject("arguments");
        if (arguments == null) {
            return MCPSearchServlet.errorResponse(id, -32602, "Missing tool arguments");
        }
        String query2 = arguments.optString("query", "").trim();
        if (query2.isEmpty()) {
            return MCPSearchServlet.errorResponse(id, -32602, "Tool argument 'query' must be a non-empty string");
        }
        int limit = arguments.optInt("limit", 10);
        if (limit <= 0) {
            limit = 10;
        }
        limit = Math.min(limit, 100);
        boolean includeSnippet = arguments.optBoolean("include_snippet", true);
        JSONArray results = RAGProxyServlet.searchResults(query2, limit, includeSnippet);
        try {
            JSONObject payload = new JSONObject(true);
            payload.put("results", results);
            JSONObject contentItem = new JSONObject(true);
            contentItem.put("type", "json");
            contentItem.put("json", payload);
            JSONArray content = new JSONArray();
            content.put(contentItem);
            JSONObject result = new JSONObject(true);
            result.put("content", content);
            return MCPSearchServlet.successResponse(id, result);
        }
        catch (JSONException e) {
            return MCPSearchServlet.errorResponse(id, -32603, e.getMessage());
        }
    }

    private static String readBody(ServletRequest request) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        return builder.toString();
    }

    private static JSONObject successResponse(Object id, JSONObject result) {
        JSONObject response = new JSONObject(true);
        try {
            response.put("jsonrpc", JSONRPC_VERSION);
            response.put("id", id);
            response.put("result", result);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Failed to construct success response", e);
        }
        return response;
    }

    private static JSONObject errorResponse(Object id, int code, String message2) {
        JSONObject response = new JSONObject(true);
        try {
            response.put("jsonrpc", JSONRPC_VERSION);
            response.put("id", id);
            JSONObject error = new JSONObject(true);
            error.put("code", code);
            error.put("message", message2);
            response.put("error", error);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Failed to construct error response", e);
        }
        return response;
    }

    private static void writeJsonResponse(HttpServletResponse response, Object payload) throws IOException {
        String serialized = payload instanceof JSONObject ? ((JSONObject)payload).toString() : (payload instanceof JSONArray ? ((JSONArray)payload).toString() : payload.toString());
        response.getWriter().write(serialized);
        response.getWriter().flush();
    }
}

