/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.TextParser;
import net.yacy.http.AbstractRemoteHandler;
import net.yacy.server.http.HTTPDProxyHandler;
import net.yacy.server.http.MultiOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.eclipse.jetty.server.Handler;

public class ProxyHandler
extends AbstractRemoteHandler
implements Handler {
    protected int timeout = 10000;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.timeout = this.sb.getConfigInt("proxy.clientTimeout", 10000);
    }

    private void convertHeaderToJetty(HttpResponse in, HttpServletResponse out) {
        for (Header h : in.getAllHeaders()) {
            out.addHeader(h.getName(), h.getValue());
        }
    }

    private void cleanResponseHeader(HttpResponse headers) {
        headers.removeHeaders("Content-Encoding");
        headers.removeHeaders("Content-Length");
    }

    private void deleteFromCache(byte[] hash) {
        ResponseHeader rh = Cache.getResponseHeader(hash);
        if (rh != null) {
            try {
                Cache.delete(hash);
            }
            catch (IOException e) {
                HTTPDProxyHandler.proxyLog.fine(e.getMessage());
            }
        }
    }

    private void storeToCache(final Response yacyResponse, final byte[] cacheArray) {
        Thread t = new Thread(this){
            final /* synthetic */ ProxyHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (yacyResponse == null) {
                    return;
                }
                this.setName("ProxyHandler.storeToCache(" + yacyResponse.url().toNormalform(true) + ")");
                this.this$0.deleteFromCache(yacyResponse.url().hash());
                if (cacheArray == null || cacheArray.length <= 0) {
                    return;
                }
                yacyResponse.setContent(cacheArray);
                try {
                    Cache.store(yacyResponse.url(), yacyResponse.getResponseHeader(), cacheArray);
                    this.this$0.sb.toIndexer(yacyResponse);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    @Override
    public void handleRemote(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.sb.proxyLastAccess = System.currentTimeMillis();
        RequestHeader proxyHeaders = ProxyHandler.convertHeaderFromJetty(request);
        this.setProxyHeaderForClient(request, proxyHeaders);
        try (HTTPClient client = new HTTPClient(ClientIdentification.yacyProxyAgent);){
            client.setTimout(this.timeout);
            client.setHeader(proxyHeaders.entrySet());
            client.setRedirecting(false);
            String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
            DigestURL digestURI = new DigestURL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI() + queryString);
            if (request.getMethod().equals("GET")) {
                client.GET(digestURI, false);
            } else if (request.getMethod().equals("POST")) {
                client.POST(digestURI, (InputStream)request.getInputStream(), request.getContentLength(), false);
            } else if (request.getMethod().equals("HEAD")) {
                client.HEADResponse(digestURI, false);
            } else {
                throw new ServletException("Unsupported Request Method");
            }
            HttpResponse clientresponse = client.getHttpResponse();
            int statusCode = clientresponse.getStatusLine().getStatusCode();
            ResponseHeader responseHeaderLegacy = new ResponseHeader(statusCode, clientresponse.getAllHeaders());
            if (responseHeaderLegacy.isEmpty()) {
                throw new SocketException(clientresponse.getStatusLine().toString());
            }
            this.cleanResponseHeader(clientresponse);
            Request yacyRequest = new Request(null, digestURI, null, "", responseHeaderLegacy.lastModified(), this.sb.crawler.defaultProxyProfile.handle(), 0, this.sb.crawler.defaultProxyProfile.timezoneOffset());
            Response yacyResponse = new Response(yacyRequest, null, responseHeaderLegacy, this.sb.crawler.defaultProxyProfile, false, null);
            String storeError = yacyResponse.shallStoreCacheForProxy();
            boolean storeHTCache = yacyResponse.profile().storeHTCache();
            String supportError = TextParser.supports(yacyResponse.url(), yacyResponse.getMimeType());
            if (storeError == null && (storeHTCache || supportError != null)) {
                int l = responseHeaderLegacy.size();
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream(l < 32 ? 32 : l);
                MultiOutputStream toClientAndMemory = new MultiOutputStream(new OutputStream[]{response.getOutputStream(), byteStream});
                this.convertHeaderToJetty(clientresponse, response);
                response.setStatus(statusCode);
                client.writeTo(toClientAndMemory);
                this.storeToCache(yacyResponse, byteStream.toByteArray());
            } else {
                this.convertHeaderToJetty(clientresponse, response);
                response.setStatus(statusCode);
                if (statusCode == 200) {
                    client.writeTo((OutputStream)response.getOutputStream());
                }
            }
        }
        catch (SocketException se) {
            throw new ServletException("Socket Exception: " + se.getMessage());
        }
        ProxyHandler.logProxyAccess(request);
        baseRequest.setHandled(true);
    }

    public static RequestHeader convertHeaderFromJetty(HttpServletRequest request) {
        RequestHeader result = new RequestHeader();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                result.add(headerName, header);
            }
        }
        return result;
    }

    private void setProxyHeaderForClient(HttpServletRequest origServletRequest, HeaderFramework header) {
        String ip;
        header.remove("Keep-Alive");
        header.remove("Content-Length");
        if (this.sb.getConfigBool("proxy.sendXForwardedForHeader", true) && !Domains.isThisHostIP(ip = origServletRequest.getRemoteAddr())) {
            header.put("X-Forwarded-For", origServletRequest.getRemoteAddr());
        }
        String httpVersion = origServletRequest.getProtocol();
        HTTPDProxyHandler.modifyProxyHeaders(header, httpVersion);
    }

    public static final synchronized void logProxyAccess(HttpServletRequest request) {
        StringBuilder logMessage = new StringBuilder(80);
        logMessage.append(GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date()));
        logMessage.append(' ');
        String clientIP = request.getRemoteAddr();
        logMessage.append(clientIP);
        logMessage.append(' ');
        String requestMethod = request.getMethod();
        logMessage.append(requestMethod);
        logMessage.append(' ');
        logMessage.append(request.getRequestURL());
        String requestArgs = request.getQueryString();
        if (requestArgs != null) {
            logMessage.append("?").append(requestArgs);
        }
        HTTPDProxyHandler.proxyLog.fine(logMessage.toString());
    }
}

