/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.protocol.ConnectionInfo;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class MonitorHandler
extends AbstractHandler {
    private final Connection.Listener remover = new Connection.Listener(){

        public void onClosed(Connection c) {
            ConnectionInfo.removeServerConnection(c.hashCode());
        }

        public void onOpened(Connection c) {
        }
    };

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Connection connection = baseRequest.getHttpChannel().getEndPoint().getConnection();
        ConnectionInfo info = new ConnectionInfo(baseRequest.getScheme(), RequestHeader.client((ServletRequest)baseRequest) + ":" + baseRequest.getRemotePort(), baseRequest.getMethod() + " " + baseRequest.getHttpURI().getPathQuery(), connection.hashCode(), baseRequest.getTimeStamp(), -1L);
        if (ConnectionInfo.getServerConnections().contains(info)) {
            ConnectionInfo.removeServerConnection(info);
        } else {
            connection.addListener(this.remover);
        }
        ConnectionInfo.addServerConnection(info);
        if (ConnectionInfo.isServerCountReached()) {
            if (Domains.isLocal(baseRequest.getRemoteAddr(), baseRequest.getRemoteInetSocketAddress().getAddress())) {
                return;
            }
            response.sendError(503, "max. server connections reached (increase /PerformanceQueues_p.html -> httpd Session Pool).");
            baseRequest.setHandled(true);
        }
    }
}

