/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.handler.InetAccessHandler;
import org.eclipse.jetty.util.InetAddressSet;
import org.eclipse.jetty.util.component.DumpableCollection;

public class InetPathAccessHandler
extends InetAccessHandler {
    private final PathMappings<InetAddressSet> white = new PathMappings();
    private final PathMappings<InetAddressSet> black = new PathMappings();

    public void include(String pattern) throws IllegalArgumentException {
        this.addPattern(pattern, this.white);
    }

    public void include(String ... patterns) throws IllegalArgumentException {
        for (String pattern : patterns) {
            this.include(pattern);
        }
    }

    public void exclude(String pattern) throws IllegalArgumentException {
        this.addPattern(pattern, this.black);
    }

    public void exclude(String ... patterns) throws IllegalArgumentException {
        for (String pattern : patterns) {
            this.exclude(pattern);
        }
    }

    protected void addPattern(String pattern, PathMappings<InetAddressSet> pathMappings) throws IllegalArgumentException {
        if (pattern != null && !pattern.isEmpty()) {
            String path;
            int idx2 = pattern.indexOf(124);
            String addr = idx2 > 0 ? pattern.substring(0, idx2) : pattern;
            String string = path = idx2 > 0 && pattern.length() > idx2 + 1 ? pattern.substring(idx2 + 1) : "/*";
            if (!addr.isEmpty()) {
                PathSpec pathSpec = PathSpec.from((String)path);
                InetAddressSet addresses = (InetAddressSet)pathMappings.get(pathSpec);
                if (addresses == null) {
                    addresses = new InetAddressSet();
                    pathMappings.put(pathSpec, (Object)addresses);
                }
                addresses.add(addr);
            }
        }
    }

    public static void checkPattern(String pattern) throws IllegalArgumentException {
        new InetPathAccessHandler().include(pattern);
    }

    protected boolean isAllowed(InetAddress address, String path) {
        String nonNullPath;
        boolean allowed = true;
        String string = nonNullPath = path != null ? path : "/";
        if (this.white.size() > 0) {
            allowed = false;
            for (MappedResource mapping : this.white.getMatches(nonNullPath)) {
                if (!((InetAddressSet)mapping.getResource()).test(address)) continue;
                allowed = true;
                break;
            }
        }
        if (allowed) {
            for (MappedResource mapping : this.black.getMatches(nonNullPath)) {
                if (!((InetAddressSet)mapping.getResource()).test(address)) continue;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{DumpableCollection.from((String)"white", (Object[])new Object[]{this.white.getMappings()}), DumpableCollection.from((String)"black", (Object[])new Object[]{this.black.getMappings()})});
    }
}

