/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.protocol.Domains;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;

public abstract class AbstractRemoteHandler
extends ConnectHandler
implements Handler {
    protected Switchboard sb = null;
    private final Set<String> localVirtualHostNames = new HashSet<String>();

    protected void doStart() throws Exception {
        super.doStart();
        this.sb = Switchboard.getSwitchboard();
        this.localVirtualHostNames.add("localhost");
        this.localVirtualHostNames.add(this.sb.getConfig("fileHost", "localpeer"));
        new Thread(AbstractRemoteHandler.class.getSimpleName() + ".doStart"){

            @Override
            public void run() {
                for (InetAddress localInetAddress : Domains.myPublicIPv4()) {
                    if (localInetAddress == null) continue;
                    if (!AbstractRemoteHandler.this.localVirtualHostNames.contains(localInetAddress.getHostName())) {
                        AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getHostName());
                        AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getHostAddress());
                    }
                    if (AbstractRemoteHandler.this.localVirtualHostNames.contains(localInetAddress.getCanonicalHostName())) continue;
                    AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getCanonicalHostName());
                }
                for (InetAddress localInetAddress : Domains.myPublicIPv6()) {
                    if (localInetAddress == null) continue;
                    if (!AbstractRemoteHandler.this.localVirtualHostNames.contains(localInetAddress.getHostName())) {
                        AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getHostName());
                        AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getHostAddress());
                    }
                    if (AbstractRemoteHandler.this.localVirtualHostNames.contains(localInetAddress.getCanonicalHostName())) continue;
                    AbstractRemoteHandler.this.localVirtualHostNames.add(localInetAddress.getCanonicalHostName());
                }
                if (AbstractRemoteHandler.this.sb.peers != null) {
                    AbstractRemoteHandler.this.localVirtualHostNames.addAll(AbstractRemoteHandler.this.sb.peers.mySeed().getIPs());
                    AbstractRemoteHandler.this.localVirtualHostNames.add(AbstractRemoteHandler.this.sb.peers.myAlternativeAddress());
                    AbstractRemoteHandler.this.localVirtualHostNames.add(AbstractRemoteHandler.this.sb.peers.mySeed().getHexHash() + ".yacyh");
                }
            }
        }.start();
    }

    public abstract void handleRemote(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String host = request.getHeader("Host");
        if (host == null) {
            return;
        }
        String hostOnly = Domains.stripToHostName(host);
        if (this.localVirtualHostNames.contains(hostOnly)) {
            return;
        }
        if (Domains.isLocal(hostOnly, null)) {
            return;
        }
        if (this.sb.peers.myIPs().contains(hostOnly)) {
            this.localVirtualHostNames.addAll(this.sb.peers.myIPs());
            return;
        }
        InetAddress resolvedIP = Domains.dnsResolve(hostOnly);
        if (resolvedIP != null && this.sb.myPublicIPs().contains(resolvedIP.getHostAddress())) {
            this.localVirtualHostNames.add(resolvedIP.getHostName());
            return;
        }
        if (!Switchboard.getSwitchboard().getConfigBool("isTransparentProxy", false)) {
            response.sendError(403, "proxy use not allowed (see System Administration -> Advanced Settings -> Proxy Access Settings -> Transparent Proxy; switched off).");
            baseRequest.setHandled(true);
            return;
        }
        String remoteHost = request.getRemoteHost();
        if (!this.proxyippatternmatch(remoteHost)) {
            response.sendError(403, "proxy use not granted for IP " + remoteHost + " (see Advanced Settings -> Proxy Access Settings -> IP-Number filter).");
            baseRequest.setHandled(true);
            return;
        }
        if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.PROXY, hostOnly.toLowerCase(Locale.ROOT), request.getPathInfo())) {
            response.sendError(403, "URL '" + hostOnly + "' blocked by yacy proxy (blacklisted)");
            baseRequest.setHandled(true);
            return;
        }
        if (request.getMethod().equalsIgnoreCase("CONNECT")) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        this.handleRemote(target, baseRequest, request, response);
    }

    private boolean proxyippatternmatch(String key) {
        String cfgippattern = Switchboard.getSwitchboard().getConfig("proxyClient", "*");
        if (cfgippattern.equals("*")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(cfgippattern, ",");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            if (!key.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

