/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.data.UserDB;
import net.yacy.document.DateDetection;
import net.yacy.document.LibraryProvider;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSortDirection;
import net.yacy.search.navigator.NavigatorSortType;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.query.SearchEventType;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class yacysearchtrailer {
    private static final int TOPWORDS_MAXCOUNT = 16;
    private static final int TOPWORDS_MINSIZE = 8;
    private static final int TOPWORDS_MAXSIZE = 22;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int neg;
        String name;
        int count;
        int i;
        Iterator<String> navigatorIterator;
        boolean authenticated;
        if (post == null) {
            throw new TemplateMissingParameterException("The eventID parameter is required");
        }
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        String eventID = post.get("eventID", "");
        boolean adminAuthenticated = sb.verifyAuthentication(header);
        UserDB.Entry user = sb.userDB != null ? sb.userDB.getUser(header) : null;
        boolean bl = authenticated = adminAuthenticated || user != null;
        if (post.containsKey("auth") && !authenticated) {
            prop.authenticationRequired();
            return prop;
        }
        SearchEvent theSearch = SearchEventCache.getEvent(eventID);
        if (theSearch == null) {
            return prop;
        }
        RequestHeader.FileType fileType = header.fileType();
        boolean clustersearch = sb.isRobinsonMode() && sb.getConfig("cluster.mode", "").equals("publiccluster");
        boolean indexReceiveGranted = sb.getConfigBool("allowReceiveIndex.search", true) || clustersearch;
        boolean p2pmode = sb.peers != null && sb.peers.sizeConnected() > 0 && indexReceiveGranted;
        boolean global = post == null || !post.get("resource-switch", post.get("resource", "global")).equals("local") && p2pmode;
        boolean stealthmode = p2pmode && !global;
        Classification.ContentDomain contentdom = theSearch.getQuery().contentdom;
        prop.put("searchdomswitches", sb.getConfigBool("search.text", true) || sb.getConfigBool("search.audio", true) || sb.getConfigBool("search.video", true) || sb.getConfigBool("search.image", true) || sb.getConfigBool("search.app", true) ? 1L : 0L);
        String originalquerystring = post.get("query", post.get("search", "")).trim();
        originalquerystring = originalquerystring.replace('<', ' ').replace('>', ' ');
        String former = originalquerystring.replaceAll("yacyall", "*");
        CacheStrategy snippetFetchStrategy = CacheStrategy.parse(post.get("verify", sb.getConfig("search.verify", "")));
        String snippetFetchStrategyName = snippetFetchStrategy == null ? sb.getConfig("search.verify", CacheStrategy.IFFRESH.toName()) : snippetFetchStrategy.toName();
        int startRecord = post.getInt("startRecord", post.getInt("offset", post.getInt("start", 0)));
        int meanMax = post.getInt("meanCount", 0);
        prop.put("resource-switches", adminAuthenticated && (stealthmode || global));
        prop.put("resource-switches_global", adminAuthenticated && global);
        yacysearchtrailer.appendSearchFormValues("resource-switches_", post, prop, global, theSearch, former, snippetFetchStrategyName, startRecord, meanMax);
        prop.put("ranking-switches", true);
        yacysearchtrailer.appendSearchFormValues("ranking-switches_", post, prop, global, theSearch, former, snippetFetchStrategyName, startRecord, meanMax);
        prop.put("ranking-switches_nav-generation", theSearch.getNavGeneration());
        prop.put("ranking-switches_contextRanking", !former.contains(" /date"));
        prop.put("ranking-switches_contextRanking_formerWithoutDate", former.replace(" /date", ""));
        prop.put("ranking-switches_dateRanking", former.contains(" /date"));
        prop.put("ranking-switches_dateRanking_former", former);
        yacysearchtrailer.appendSearchFormValues("searchdomswitches_", post, prop, global, theSearch, former, snippetFetchStrategyName, startRecord, meanMax);
        prop.put("searchdomswitches_searchtext", sb.getConfigBool("search.text", true) ? 1L : 0L);
        prop.put("searchdomswitches_searchaudio", sb.getConfigBool("search.audio", true) ? 1L : 0L);
        prop.put("searchdomswitches_searchvideo", sb.getConfigBool("search.video", true) ? 1L : 0L);
        prop.put("searchdomswitches_searchimage", sb.getConfigBool("search.image", true) ? 1L : 0L);
        prop.put("searchdomswitches_searchapp", sb.getConfigBool("search.app", true) ? 1L : 0L);
        prop.put("searchdomswitches_searchtext_check", contentdom == Classification.ContentDomain.TEXT || contentdom == Classification.ContentDomain.ALL ? "1" : "0");
        prop.put("searchdomswitches_searchaudio_check", contentdom == Classification.ContentDomain.AUDIO ? "1" : "0");
        prop.put("searchdomswitches_searchvideo_check", contentdom == Classification.ContentDomain.VIDEO ? "1" : "0");
        prop.put("searchdomswitches_searchimage_check", contentdom == Classification.ContentDomain.IMAGE ? "1" : "0");
        prop.put("searchdomswitches_searchapp_check", contentdom == Classification.ContentDomain.APP ? "1" : "0");
        yacysearchtrailer.appendSearchFormValues("searchdomswitches_strictContentDomSwitch_", post, prop, global, theSearch, former, snippetFetchStrategyName, startRecord, meanMax);
        prop.put("searchdomswitches_strictContentDomSwitch", contentdom != Classification.ContentDomain.TEXT && contentdom != Classification.ContentDomain.ALL ? 1L : 0L);
        prop.put("searchdomswitches_strictContentDomSwitch_strictContentDom", theSearch.getQuery().isStrictContentDom() ? 1L : 0L);
        ScoreMap<String> topicNavigator = theSearch.getTopicNavigator(16);
        if (topicNavigator == null || topicNavigator.isEmpty()) {
            prop.put("nav-topics", "0");
        } else {
            prop.put("nav-topics", "1");
            navigatorIterator = topicNavigator.keys(false);
            i = 0;
            LinkedList<AbstractMap.SimpleEntry<String, Integer>> cloud = new LinkedList<AbstractMap.SimpleEntry<String, Integer>>();
            int mincount = Integer.MAX_VALUE;
            int maxcount = 0;
            while (i < 16 && navigatorIterator.hasNext() && (count = topicNavigator.get(name = navigatorIterator.next())) != 0) {
                if (name == null) continue;
                int normcount = (count + 16 - i) / 2;
                if (normcount > maxcount) {
                    maxcount = normcount;
                }
                if (normcount < mincount) {
                    mincount = normcount;
                }
                AbstractMap.SimpleEntry<String, Integer> entry2 = new AbstractMap.SimpleEntry<String, Integer>(name, normcount);
                if (cloud.size() % 2 == 0) {
                    cloud.addFirst(entry2);
                } else {
                    cloud.addLast(entry2);
                }
                ++i;
            }
            i = 0;
            for (AbstractMap.SimpleEntry<String, Integer> entry2 : cloud) {
                name = (String)entry2.getKey();
                count = (Integer)entry2.getValue();
                prop.put(fileType, "nav-topics_element_" + i + "_modifier", name);
                prop.put(fileType, "nav-topics_element_" + i + "_name", name);
                prop.putUrlEncoded(fileType, "nav-topics_element_" + i + "_url", QueryParams.navurl(fileType, 0, theSearch.query, name, false, authenticated).toString());
                prop.put("nav-topics_element_" + i + "_count", count);
                int fontsize = 8 + 14 * (count - mincount) / (1 + maxcount - mincount);
                fontsize = Math.max(8, fontsize - (name.length() - 5));
                prop.put("nav-topics_element_" + i + "_size", fontsize);
                prop.put("nav-topics_element_" + i + "_nl", 1L);
                ++i;
            }
            prop.put("nav-topics_element", i);
            prop.put("nav-topics_count", i);
            prop.put("nav-topics_element_" + --i + "_nl", 0L);
        }
        if (theSearch.protocolNavigator == null || theSearch.protocolNavigator.isEmpty()) {
            prop.put("nav-protocols", 0L);
        } else {
            prop.put("nav-protocols", 1L);
            navigatorIterator = theSearch.protocolNavigator.keys(false);
            i = 0;
            int pos = 0;
            neg = 0;
            String oldQuery = theSearch.query.getQueryGoal().query_original;
            String oldProtocolModifier = theSearch.query.modifier.protocol;
            if (oldProtocolModifier != null && oldProtocolModifier.length() > 0) {
                theSearch.query.modifier.remove("/" + oldProtocolModifier);
                theSearch.query.modifier.remove(oldProtocolModifier);
            }
            theSearch.query.modifier.protocol = "";
            theSearch.query.getQueryGoal().query_original = oldQuery.replaceAll(" /https", "").replaceAll(" /http", "").replaceAll(" /ftp", "").replaceAll(" /smb", "").replaceAll(" /file", "");
            while (i < theSearch.getQuery().getStandardFacetsMaxCount() && navigatorIterator.hasNext() && (count = theSearch.protocolNavigator.get(name = navigatorIterator.next().trim())) != 0) {
                String url;
                String nav = "%2F" + name;
                String rawNav = "/" + name;
                if (oldProtocolModifier == null || !oldProtocolModifier.equals(name)) {
                    ++pos;
                    prop.put("nav-protocols_element_" + i + "_on", 0L);
                    prop.put("nav-protocols_element_" + i + "_onclick", 0L);
                    prop.put(fileType, "nav-protocols_element_" + i + "_modifier", nav);
                    url = QueryParams.navurl(fileType, 0, theSearch.query, rawNav, false, authenticated).toString();
                } else {
                    ++neg;
                    prop.put("nav-protocols_element_" + i + "_on", 1L);
                    prop.put("nav-protocols_element_" + i + "_onclick", 1L);
                    prop.put(fileType, "nav-protocols_element_" + i + "_modifier", "-" + nav);
                    url = QueryParams.navUrlWithSingleModifierRemoved(fileType, 0, theSearch.query, rawNav, authenticated).toString();
                }
                prop.put(fileType, "nav-protocols_element_" + i + "_name", name);
                prop.put("nav-protocols_element_" + i + "_onclick_url", url);
                prop.putUrlEncoded(fileType, "nav-protocols_element_" + i + "_url", url);
                prop.put("nav-protocols_element_" + i + "_count", count);
                prop.put("nav-protocols_element_" + i + "_nl", 1L);
                ++i;
            }
            if (i == 1) {
                prop.put("nav-protocols_element_0_onclick", 0L);
            }
            theSearch.query.modifier.protocol = oldProtocolModifier;
            if (oldProtocolModifier != null && oldProtocolModifier.length() > 0) {
                theSearch.query.modifier.add((String)(oldProtocolModifier.startsWith("/") ? oldProtocolModifier : "/" + oldProtocolModifier));
            }
            theSearch.query.getQueryGoal().query_original = oldQuery;
            prop.put("nav-protocols_element", i);
            prop.put("nav-protocols_count", i);
            prop.put("nav-protocols_element_" + --i + "_nl", 0L);
            if (pos == 1 && neg == 0) {
                prop.put("nav-protocols", 0L);
            }
        }
        if (theSearch.dateNavigator == null || theSearch.dateNavigator.isEmpty()) {
            prop.put("nav-dates", 0L);
        } else {
            Date toconstraint;
            Date fromconstraint;
            prop.put("nav-dates", 1L);
            navigatorIterator = theSearch.dateNavigator.keysByNaturalOrder(true);
            i = 0;
            int pos = 0;
            neg = 0;
            long dx = -1L;
            Date date = fromconstraint = theSearch.getQuery().modifier.from == null ? null : DateDetection.parseLine(theSearch.getQuery().modifier.from, theSearch.getQuery().timezoneOffset);
            if (fromconstraint == null) {
                fromconstraint = new Date(System.currentTimeMillis() - 31536000000L);
            }
            Date date2 = toconstraint = theSearch.getQuery().modifier.to == null ? null : DateDetection.parseLine(theSearch.getQuery().modifier.to, theSearch.getQuery().timezoneOffset);
            if (toconstraint == null) {
                toconstraint = new Date(System.currentTimeMillis() + 31536000000L);
            }
            while (i < theSearch.getQuery().getDateFacetMaxCount() && navigatorIterator.hasNext()) {
                name = navigatorIterator.next().trim();
                if (name.length() < 10 || (count = theSearch.dateNavigator.get(name)) == 0) continue;
                String shortname = name.substring(0, 10);
                long d = Instant.parse(name).toEpochMilli();
                Date dd = new Date(d);
                if (fromconstraint != null && dd.before(fromconstraint)) continue;
                if (toconstraint != null && dd.after(toconstraint)) break;
                if (dx > 0L) {
                    while (d - dx > 86400000L && i < theSearch.getQuery().getDateFacetMaxCount()) {
                        String sn = new Date(dx += 86400000L).toInstant().toString().substring(0, 10);
                        prop.put("nav-dates_element_" + i + "_on", 0L);
                        prop.put(fileType, "nav-dates_element_" + i + "_name", sn);
                        prop.put("nav-dates_element_" + i + "_count", 0L);
                        prop.put("nav-dates_element_" + i + "_nl", 1L);
                        ++i;
                    }
                }
                dx = d;
                if (theSearch.query.modifier.on == null || !theSearch.query.modifier.on.contains(shortname)) {
                    ++pos;
                    prop.put("nav-dates_element_" + i + "_on", 1L);
                } else {
                    ++neg;
                    prop.put("nav-dates_element_" + i + "_on", 0L);
                }
                prop.put(fileType, "nav-dates_element_" + i + "_name", shortname);
                prop.put("nav-dates_element_" + i + "_count", count);
                prop.put("nav-dates_element_" + i + "_nl", 1L);
                ++i;
            }
            prop.put("nav-dates_element", i);
            prop.put("nav-dates_count", i);
            prop.put("nav-dates_element_" + --i + "_nl", 0L);
            if (pos == 1 && neg == 0) {
                prop.put("nav-dates", 0L);
            }
        }
        Map<String, ScoreMap<String>> vocabularyNavigators = theSearch.vocabularyNavigator;
        if (vocabularyNavigators != null && !vocabularyNavigators.isEmpty()) {
            int navvoccount = 0;
            for (Map.Entry<String, ScoreMap<String>> ve : vocabularyNavigators.entrySet()) {
                int i2;
                String navname = ve.getKey();
                if (ve.getValue() == null || ve.getValue().isEmpty()) continue;
                prop.put(fileType, "nav-vocabulary_" + navvoccount + "_navname", navname);
                navigatorIterator = ve.getValue().keys(false);
                for (i2 = 0; i2 < 20 && navigatorIterator.hasNext(); ++i2) {
                    String navUrl;
                    name = navigatorIterator.next();
                    count = ve.getValue().get(name);
                    if (count == 0) break;
                    String nav = "%2Fvocabulary%2F" + navname + "%2F" + MultiProtocolURL.escape(Tagging.encodePrintname(name)).toString();
                    String rawNav = "/vocabulary/" + navname + "/" + MultiProtocolURL.escape(Tagging.encodePrintname(name)).toString();
                    if (!theSearch.query.modifier.toString().contains("/vocabulary/" + navname + "/" + name.replace(' ', '_'))) {
                        prop.put("nav-vocabulary_" + navvoccount + "_element_" + i2 + "_on", 1L);
                        prop.put(fileType, "nav-vocabulary_" + navvoccount + "_element_" + i2 + "_modifier", nav);
                        navUrl = QueryParams.navurl(fileType, 0, theSearch.query, rawNav, false, authenticated).toString();
                    } else {
                        prop.put("nav-vocabulary_" + navvoccount + "_element_" + i2 + "_on", 0L);
                        prop.put(fileType, "nav-vocabulary_" + navvoccount + "_element_" + i2 + "_modifier", "-" + nav);
                        navUrl = QueryParams.navUrlWithSingleModifierRemoved(fileType, 0, theSearch.query, rawNav, authenticated);
                    }
                    prop.put(fileType, "nav-vocabulary_" + navvoccount + "_element_" + i2 + "_name", name);
                    prop.putUrlEncoded(fileType, "nav-vocabulary_" + navvoccount + "_element_" + i2 + "_url", navUrl);
                    prop.put(fileType, "nav-vocabulary_" + navvoccount + "_element_" + i2 + "_id", "vocabulary_" + navname + "_" + i2);
                    prop.put("nav-vocabulary_" + navvoccount + "_element_" + i2 + "_count", count);
                    prop.put("nav-vocabulary_" + navvoccount + "_element_" + i2 + "_nl", 1L);
                }
                prop.put("nav-vocabulary_" + navvoccount + "_element", i2);
                prop.put("nav-vocabulary_" + navvoccount + "_count", i2);
                prop.put("nav-vocabulary_" + navvoccount + "_element_" + --i2 + "_nl", 0L);
                ++navvoccount;
            }
            prop.put("nav-vocabulary", navvoccount);
        } else {
            prop.put("nav-vocabulary", 0L);
        }
        int ni = 0;
        for (String naviname : theSearch.navigatorPlugins.keySet()) {
            Navigator navi = theSearch.navigatorPlugins.get(naviname);
            if (navi.isEmpty()) continue;
            prop.put("navs_" + ni + "_displayname", navi.getDisplayName());
            prop.put("navs_" + ni + "_name", naviname);
            prop.put("navs_" + ni + "_count", navi.size());
            int navSort = navi.getSort() == null ? 0 : (navi.getSort().getSortType() == NavigatorSortType.COUNT ? (navi.getSort().getSortDir() == NavigatorSortDirection.DESC ? 0 : 1) : (navi.getSort().getSortDir() == NavigatorSortDirection.DESC ? 2 : 3));
            prop.put("navs_" + ni + "_navSort", navSort);
            navigatorIterator = navi.navigatorKeys();
            int i3 = 0;
            int pos = 0;
            int neg2 = 0;
            while (i3 < theSearch.getQuery().getStandardFacetsMaxCount() && navigatorIterator.hasNext()) {
                String navUrl;
                String nav;
                name = navigatorIterator.next();
                count = navi.get(name);
                if (count == 0) continue;
                String rawNav = navi.getQueryModifier(name);
                try {
                    nav = URLEncoder.encode(rawNav, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException ex) {
                    nav = "";
                }
                boolean isactive = navi.modifieractive(theSearch.query.modifier, name);
                if (!isactive) {
                    ++pos;
                    prop.put("navs_" + ni + "_element_" + i3 + "_on", 1L);
                    prop.put(fileType, "navs_" + ni + "_element_" + i3 + "_modifier", nav);
                    navUrl = QueryParams.navurl(fileType, 0, theSearch.query, rawNav, false, authenticated).toString();
                } else {
                    ++neg2;
                    prop.put("navs_" + ni + "_element_" + i3 + "_on", 0L);
                    prop.put(fileType, "navs_" + ni + "_element_" + i3 + "_modifier", "-" + nav);
                    navUrl = QueryParams.navUrlWithSingleModifierRemoved(fileType, 0, theSearch.query, rawNav, authenticated);
                }
                prop.put(fileType, "navs_" + ni + "_element_" + i3 + "_name", navi.getElementDisplayName(name));
                prop.putUrlEncoded(fileType, "navs_" + ni + "_element_" + i3 + "_url", navUrl);
                prop.put(fileType, "navs_" + ni + "_element_" + i3 + "_id", naviname + "_" + i3);
                prop.put("navs_" + ni + "_element_" + i3 + "_count", count);
                prop.put("navs_" + ni + "_element_" + i3 + "_nl", 1L);
                ++i3;
            }
            if (i3 == 0) continue;
            prop.put("navs_" + ni + "_element", i3);
            prop.put("navs_" + ni + "_count", i3);
            prop.put("navs_" + ni + "_element_" + --i3 + "_nl", 0L);
            if (pos == 1 && neg2 == 0) {
                prop.put("navs_" + ni, 0L);
            }
            ++ni;
        }
        prop.put("navs", ni);
        String aboutBody = env.getConfig("about.body", "");
        String aboutHeadline = env.getConfig("about.headline", "");
        if (aboutBody.isEmpty() && aboutHeadline.isEmpty() || theSearch.getResultCount() == 0) {
            prop.put("nav-about", 0L);
        } else {
            prop.put("nav-about", 1L);
            prop.put("nav-about_headline", aboutHeadline);
            prop.put("nav-about_body", aboutBody);
        }
        if (theSearch.locationNavigator == null || (LibraryProvider.geoLoc.isEmpty() || theSearch.getResultCount() == 0) && theSearch.locationNavigator.isEmpty()) {
            prop.put("cat-location", 0L);
        } else {
            prop.put("cat-location", 1L);
            String query2 = theSearch.query.getQueryGoal().getQueryString(false);
            prop.put(fileType, "cat-location_query", query2);
            String queryenc = theSearch.query.getQueryGoal().getQueryString(true).replace(' ', '+');
            prop.putUrlEncoded(fileType, "cat-location_queryenc", queryenc);
        }
        prop.put("num-results_totalcount", theSearch.getResultCount());
        EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theSearch.query.id(true), SearchEventType.FINALIZATION, "bottomline", 0, 0L), false);
        return prop;
    }

    private static void appendSearchFormValues(String templatePrefix, serverObjects post, serverObjects prop, boolean global, SearchEvent theSearch, String former, String snippetFetchStrategyName, int startRecord, int meanMax) {
        prop.putHTML(templatePrefix + "former", former);
        prop.put(templatePrefix + "authSearch", post.containsKey("auth"));
        prop.put(templatePrefix + "contentdom", post.get("contentdom", "text"));
        prop.put(templatePrefix + "strictContentDom", String.valueOf(theSearch.getQuery().isStrictContentDom()));
        prop.put(templatePrefix + "maximumRecords", theSearch.getQuery().itemsPerPage);
        prop.put(templatePrefix + "startRecord", startRecord);
        prop.put(templatePrefix + "search.verify", snippetFetchStrategyName);
        prop.put(templatePrefix + "resource", global ? "global" : "local");
        prop.put(templatePrefix + "search.navigation", post.get("nav", "all"));
        prop.putHTML(templatePrefix + "prefermaskfilter", theSearch.getQuery().prefer.pattern());
        prop.put(templatePrefix + "depth", "0");
        prop.put(templatePrefix + "constraint", theSearch.getQuery().constraint == null ? "" : theSearch.getQuery().constraint.exportB64());
        prop.put(templatePrefix + "meanCount", meanMax);
    }
}

