/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.net.MalformedURLException;
import java.util.Arrays;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class yacydoc {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        boolean html = post != null && post.containsKey("html");
        prop.setLocalized(html);
        prop.put("dc_title", "");
        prop.put("dc_creator", "");
        prop.put("dc_description", "");
        prop.put("dc_subject", "");
        prop.put("dc_publisher", "");
        prop.put("dc_contributor", "");
        prop.put("dc_date", "");
        prop.put("dc_type", "");
        prop.put("dc_identifier", "");
        prop.put("dc_language", "");
        prop.put("collection", "");
        prop.put("geo_lat", "");
        prop.put("geo_long", "");
        prop.put("yacy_urlhash", "");
        prop.put("yacy_loaddate", "");
        prop.put("yacy_referrer_hash", "");
        prop.put("yacy_referrer_url", "");
        prop.put("yacy_size", "");
        prop.put("yacy_words", "");
        prop.put("yacy_citations", "");
        prop.put("yacy_inbound", "");
        prop.put("yacy_outbound", "");
        if (post == null) {
            return prop;
        }
        String urlstring = post.get("url", "").trim();
        String urlhash = post.get("urlhash", "").trim();
        if (urlstring.isEmpty() && urlhash.isEmpty()) {
            return prop;
        }
        if (urlstring.length() > 0 && urlhash.isEmpty()) {
            try {
                DigestURL url = new DigestURL(urlstring);
                urlhash = ASCII.String(url.hash());
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (urlhash == null || urlhash.isEmpty()) {
            return prop;
        }
        URIMetadataNode entry2 = segment.fulltext().getMetadata(urlhash.getBytes());
        if (entry2 == null) {
            return prop;
        }
        if (entry2.url() == null) {
            return prop;
        }
        URIMetadataNode le = entry2.referrerHash() == null || entry2.referrerHash().length != 12 ? null : segment.fulltext().getMetadata(entry2.referrerHash());
        prop.putXML("dc_title", entry2.dc_title());
        prop.putXML("dc_creator", entry2.dc_creator());
        prop.putXML("dc_description", "");
        prop.putXML("dc_subject", entry2.dc_subject());
        prop.putXML("dc_publisher", entry2.dc_publisher());
        prop.putXML("dc_contributor", "");
        prop.putXML("dc_date", ISO8601Formatter.FORMATTER.format(entry2.moddate()));
        prop.putXML("dc_type", String.valueOf(entry2.doctype()));
        prop.putXML("dc_identifier", entry2.url().toNormalform(true));
        prop.putXML("dc_language", entry2.language());
        prop.putXML("collection", Arrays.toString(entry2.collections()));
        prop.put("geo_lat", entry2.lat());
        prop.put("geo_long", entry2.lon());
        prop.put("yacy_urlhash", entry2.url().hash());
        prop.putXML("yacy_loaddate", entry2.loaddate().toString());
        prop.putXML("yacy_referrer_hash", le == null ? "" : ASCII.String(le.hash()));
        prop.putXML("yacy_referrer_url", le == null ? "" : le.url().toNormalform(true));
        prop.put("yacy_size", entry2.filesize());
        prop.put("yacy_words", entry2.wordCount());
        prop.put("yacy_citations", sb.index.connectedCitation() ? (long)sb.index.urlCitation().count(entry2.hash()) : 0L);
        prop.put("yacy_inbound", entry2.llocal());
        prop.put("yacy_outbound", entry2.lother());
        return prop;
    }
}

