/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.io.IOException;
import java.util.ArrayList;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.Rating;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.rwi.IndexCell;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class termlist_p {
    private static final ConcurrentLog log = new ConcurrentLog("TERMLIST");

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        Segment segment = sb.index;
        boolean delete = post != null && post.containsKey("delete");
        long mincount = post == null ? 10000L : post.getLong("mincount", 10000L);
        int c = 0;
        int termnumber = 0;
        byte[] maxterm = null;
        long maxcount = 0L;
        long totalmemory = 0L;
        ArrayList<byte[]> deleteterms = new ArrayList<byte[]>();
        long over1000 = 0L;
        long over10000 = 0L;
        long over100000 = 0L;
        long over1000000 = 0L;
        long over10000000 = 0L;
        long over100000000 = 0L;
        IndexCell<WordReference> termIndex = segment.termIndex();
        int rowsize = 0;
        if (termIndex != null) {
            rowsize = termIndex.referenceRow().objectsize;
            CloneableIterator<Rating<byte[]>> i = termIndex.referenceCountIterator(null, false, false);
            while (i.hasNext()) {
                Rating e = (Rating)i.next();
                ++termnumber;
                long count = e.getScore();
                if (count >= 1000L) {
                    ++over1000;
                }
                if (count >= 10000L) {
                    ++over10000;
                }
                if (count >= 100000L) {
                    ++over100000;
                }
                if (count >= 1000000L) {
                    ++over1000000;
                }
                if (count >= 10000000L) {
                    ++over10000000;
                }
                if (count >= 100000000L) {
                    ++over100000000;
                }
                if (count > maxcount) {
                    maxcount = count;
                    maxterm = (byte[])e.getObject();
                }
                if (count < mincount) continue;
                byte[] termhash = (byte[])e.getObject();
                if (delete) {
                    deleteterms.add(termhash);
                }
                String hstring = ASCII.String(termhash);
                long mem = 20L + count * (long)rowsize;
                prop.put("terms_" + c + "_termhash", hstring);
                prop.put("terms_" + c + "_count", count);
                prop.put("terms_" + c + "_memory", mem);
                ++c;
                totalmemory += mem;
            }
            if (delete) {
                for (byte[] t : deleteterms) {
                    try {
                        termIndex.delete(t);
                    }
                    catch (IOException e1) {
                        log.warn("Error deleting " + ASCII.String(t), e1);
                    }
                }
            }
        }
        prop.put("terms", c);
        prop.put("maxterm", maxterm == null ? "" : ASCII.String(maxterm));
        prop.put("maxcount", maxcount);
        prop.put("maxcountmemory", 20L + maxcount * (long)rowsize);
        prop.put("termnumber", termnumber);
        prop.put("totalmemory", totalmemory);
        prop.put("over1000", over1000);
        prop.put("over10000", over10000);
        prop.put("over100000", over100000);
        prop.put("over1000000", over1000000);
        prop.put("over10000000", over10000000);
        prop.put("over100000000", over100000000);
        log.warn("finished termlist_p -> terms: " + c);
        log.warn("maxterm: " + (maxterm == null ? "" : ASCII.String(maxterm)));
        log.warn("maxcount:  " + maxcount);
        log.warn("termnumber: " + termnumber);
        log.warn("totalmemory: " + totalmemory);
        return prop;
    }
}

