/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks.xbel;

import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.BookmarksDB;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class xbel {
    private static final serverObjects prop = new serverObjects();
    private static Switchboard switchboard = null;
    private static boolean isAdmin = false;
    private static int R = 1;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int count = 0;
        Object root = "/";
        int style2 = 0;
        prop.clear();
        switchboard = (Switchboard)env;
        isAdmin = switchboard.verifyAuthentication(header);
        if (post != null) {
            if (!isAdmin && post.containsKey("login")) {
                prop.authenticationRequired();
            }
            if (post.containsKey("tag")) {
                String tagName = post.get("tag");
                prop.putHTML("folder", tagName);
                if (!tagName.equals("")) {
                    Iterator<String> bit = xbel.switchboard.bookmarksDB.getBookmarksIterator(tagName, isAdmin);
                    count = xbel.print_XBEL(bit, count);
                    prop.put("xbel", count);
                    return prop;
                }
            }
            if (post.containsKey("folder")) {
                String folderName = post.get("folder");
                root = folderName.length() > 0 && folderName.charAt(0) == '/' ? folderName : "/" + folderName;
            }
            if (post.containsKey("style") && !post.get("style").equals("")) {
                style2 = 1;
                prop.putHTML("style_href", post.get("style"));
                prop.putHTML("style_type", post.get("style").replaceAll("^.*\\.", ""));
            }
        }
        prop.put("style", style2);
        R = ((String)root).replaceAll("[^/]", "").length() - 1;
        count = xbel.recurseFolders(BookmarkHelper.getFolderList((String)root, xbel.switchboard.bookmarksDB.getTagIterator(isAdmin)), (String)root, 0, true, "");
        prop.put("xbel", count);
        prop.put("yacyversion", yacyBuildProperties.getVersion());
        return prop;
    }

    private static int recurseFolders(Iterator<String> it, String root, int count, boolean next, String prev) {
        String fn = "";
        fn = next ? it.next() : prev;
        if (fn.equals("\uffff")) {
            for (int i = prev.replaceAll("[^/]", "").length() - R; i > 0; --i) {
                prop.put("xbel_" + count + "_elements", "</folder>");
                ++count;
            }
            return count;
        }
        if (fn.startsWith((String)(root.equals("/") ? root : root + "/"))) {
            prop.put("xbel_" + count + "_elements", "<folder id=\"" + BookmarkHelper.tagHash(fn) + "\">");
            String title = fn;
            prop.put("xbel_" + ++count + "_elements", "<title>" + CharacterCoding.unicode2xml(title.replaceAll("(/.[^/]*)*/", ""), true) + "</title>");
            ++count;
            Iterator<String> bit = xbel.switchboard.bookmarksDB.getBookmarksIterator(fn, isAdmin);
            count = xbel.print_XBEL(bit, count);
            if (it.hasNext()) {
                count = xbel.recurseFolders(it, fn, count, true, fn);
            }
        } else {
            if (count > 0) {
                prop.put("xbel_" + count + "_elements", "</folder>");
                ++count;
            }
            if ((root = root.replaceAll("(/.[^/]*$)", "")).equals("")) {
                root = "/";
            }
            count = xbel.recurseFolders(it, root, count, false, fn);
        }
        return count;
    }

    private static int print_XBEL(Iterator<String> bit, int count) {
        while (bit.hasNext()) {
            BookmarksDB.Bookmark bookmark = xbel.switchboard.bookmarksDB.getBookmark(bit.next());
            if (bookmark == null) continue;
            Date date = new Date(bookmark.getTimeStamp());
            prop.put("xbel_" + count + "_elements", "<bookmark id=\"" + bookmark.getUrlHash() + "\" href=\"" + CharacterCoding.unicode2xml(bookmark.getUrl(), true) + "\" added=\"" + CharacterCoding.unicode2xml(ISO8601Formatter.FORMATTER.format(date), true) + "\">");
            prop.put("xbel_" + ++count + "_elements", "<title>");
            prop.putXML("xbel_" + ++count + "_elements", bookmark.getTitle());
            prop.put("xbel_" + ++count + "_elements", "</title>");
            prop.put("xbel_" + ++count + "_elements", "<info>");
            prop.put("xbel_" + ++count + "_elements", "<metadata owner=\"Mozilla\" ShortcutURL=\"" + CharacterCoding.unicode2xml(bookmark.getTagsString().replaceAll("/.*,", "").toLowerCase(), true) + "\"/>");
            prop.put("xbel_" + ++count + "_elements", "<metadata owner=\"YaCy\" public=\"" + Boolean.toString(bookmark.getPublic()) + "\"/>");
            prop.put("xbel_" + ++count + "_elements", "</info>");
            prop.put("xbel_" + ++count + "_elements", "<desc>");
            prop.putXML("xbel_" + ++count + "_elements", bookmark.getDescription());
            prop.put("xbel_" + ++count + "_elements", "</desc>");
            prop.put("xbel_" + ++count + "_elements", "</bookmark>");
            ++count;
        }
        return count;
    }
}

