/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.util.CommonPattern;
import net.yacy.peers.graphics.WebStructureGraph;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.GraphPlotter;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class WebStructurePicture_p {
    private static final double maxlongd = 9.223372036854776E18;

    public static RasterPlotter respond(RequestHeader header, serverObjects post, serverSwitch env) {
        RasterPlotter graphPicture;
        long timeout;
        Switchboard sb = (Switchboard)env;
        String color_text = "888888";
        String color_back = "FFFFFF";
        String color_dot0 = "1111BB";
        String color_dota = "11BB11";
        String color_line = "222222";
        String color_lineend = "333333";
        int width = 1280;
        int height = 720;
        int depth = 3;
        int nodes = 300;
        int bf = 12;
        int time = -1;
        String hosts = null;
        int cyc = 0;
        if (post != null) {
            width = post.getInt("width", 1280);
            if (width < 32) {
                width = 32;
            }
            if (width > 10000) {
                width = 10000;
            }
            if ((height = post.getInt("height", 720)) < 24) {
                height = 24;
            }
            if (height > 10000) {
                height = 10000;
            }
            if ((depth = post.getInt("depth", 3)) > 8) {
                depth = 8;
            }
            if (depth < 0) {
                depth = 0;
            }
            nodes = post.getInt("nodes", width * height * 100 / 1024 / 576);
            bf = post.getInt("bf", depth <= 0 ? -1 : (int)Math.round(2.0 * Math.pow(nodes, 1.0 / (double)depth)));
            time = post.getInt("time", -1);
            hosts = post.get("host", "");
            color_text = post.get("colortext", color_text);
            color_back = post.get("colorback", color_back);
            color_dot0 = post.get("colordot0", color_dot0);
            color_dota = post.get("colordota", color_dota);
            color_line = post.get("colorline", color_line);
            color_lineend = post.get("colorlineend", color_lineend);
            cyc = post.getInt("cyc", 0);
        }
        long l = timeout = time < 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(time * 8 / 10);
        if (hosts == null || hosts.isEmpty() || hosts.equals("auto")) {
            hosts = sb.webStructure.hostWithMaxReferences();
        }
        if (hosts == null || hosts.isEmpty()) {
            RasterPlotter.DrawMode drawMode = RasterPlotter.darkColor(color_back) ? RasterPlotter.DrawMode.MODE_ADD : RasterPlotter.DrawMode.MODE_SUB;
            graphPicture = new RasterPlotter(width, height, drawMode, color_back);
            PrintTool.print6(graphPicture, width / 2, height / 2, 0, "NO WEB STRUCTURE DATA AVAILABLE.", 0, 100, true, true);
            PrintTool.print6(graphPicture, width / 2, height / 2 + 20, 0, "START A WEB CRAWL TO OBTAIN STRUCTURE DATA.", 0, 100, true, false);
        } else {
            GraphPlotter graph = new GraphPlotter();
            String[] hostlist = CommonPattern.COMMA.split(hosts);
            for (int i = 0; i < hostlist.length; ++i) {
                String host = hostlist[i];
                double angle = 2.0 * (double)i * Math.PI / (double)hostlist.length;
                if (hostlist.length == 3) {
                    angle -= 1.5707963267948966;
                }
                if (hostlist.length == 4) {
                    angle += 0.7853981633974483;
                }
                graph.addNode(host, Math.cos(angle) / 8.0, Math.sin(angle) / 8.0, 0);
                WebStructurePicture_p.place(graph, sb.webStructure, host, bf, nodes, timeout, hostlist.length == 1 ? 0 : 1, hostlist.length == 1 ? depth : depth + 1, cyc);
            }
            if (post != null && post.containsKey("pa")) {
                GraphPlotter.Ribbon rAll = new GraphPlotter.Ribbon(post.getFloat("ral", 0.1f), post.getFloat("raa", 0.1f), post.getFloat("rar", 0.1f));
                GraphPlotter.Ribbon rEdge = new GraphPlotter.Ribbon(post.getFloat("rel", 0.05f), post.getFloat("rea", 0.1f), post.getFloat("rer", 0.1f));
                int pa = post.getInt("pa", 0);
                for (int i = 0; i < pa; ++i) {
                    graph = graph.physics(rAll, rEdge);
                }
            }
            graph.normalize();
            graphPicture = graph.draw(width, height, 40, 40, 16, 16, 12, 6, color_back, color_dot0, color_dota, color_line, color_lineend, color_text);
        }
        graphPicture.setColor(Long.parseLong(color_text, 16));
        PrintTool.print6(graphPicture, 2, 10, 0, "YACY WEB-STRUCTURE ANALYSIS", -1, 100, true, false);
        if (hosts != null) {
            PrintTool.print6(graphPicture, 2, 20, 0, "LINK ENVIRONMENT OF DOMAIN " + hosts.toUpperCase(), -1, 80, true, false);
        }
        PrintTool.print6(graphPicture, width - 2, 10, 0, "SNAPSHOT FROM " + new Date().toString().toUpperCase(), 1, 80, true, false);
        return graphPicture;
    }

    private static final int place(GraphPlotter graph, WebStructureGraph structure, String hostName, int bf, int maxnodes, long timeout, int nextlayer, int maxlayer, int cyc) {
        GraphPlotter.Point pivotpoint = graph.getNode(hostName);
        int branches = 0;
        if (nextlayer == maxlayer) {
            return branches;
        }
        double radius = 1.0 / (double)(1 << ++nextlayer);
        Map<String, Integer> next = structure.outgoingReferencesByHostName(hostName);
        ClusteredScoreMap<String> next0 = new ClusteredScoreMap<String>(false);
        for (Map.Entry<String, Integer> entry2 : next.entrySet()) {
            next0.set(entry2.getKey(), entry2.getValue());
        }
        HashSet<String> targetHostNames = new HashSet<String>();
        int maxtargetrefs = 8;
        int maxthisrefs = 8;
        Iterator i = next0.keys(false);
        while (i.hasNext()) {
            String targethash = (String)i.next();
            String targethost = structure.hostHash2hostName(targethash);
            if (targethost == null) continue;
            int thisrefs = next.get(targethash);
            int targetrefs = structure.referencesCount(targethash);
            maxtargetrefs = Math.max(targetrefs, maxtargetrefs);
            maxthisrefs = Math.max(thisrefs, maxthisrefs);
            targetHostNames.add(targethost);
            if (graph.getNode(targethost) != null) continue;
            double angle = ((double)Base64Order.enhancedCoder.cardinal((targethash + "____").getBytes()) / 9.223372036854776E18 + (double)cyc / 360.0) * 2.0 * Math.PI;
            double rr = radius * 0.25 * (1.0 - (double)targetrefs / (double)maxtargetrefs);
            double re = radius * 0.5 * ((double)thisrefs / (double)maxthisrefs);
            graph.addNode(targethost, pivotpoint.x + (radius - rr - re) * Math.cos(angle), pivotpoint.y + (radius - rr - re) * Math.sin(angle), nextlayer);
            if (maxnodes-- > 0 && (bf <= 0 || ++branches < bf) && System.currentTimeMillis() < timeout) continue;
            break;
        }
        for (String targetHostName : targetHostNames) {
            int nextnodes = maxnodes <= 0 || System.currentTimeMillis() >= timeout ? 0 : WebStructurePicture_p.place(graph, structure, targetHostName, bf, maxnodes, timeout, nextlayer, maxlayer, cyc);
            branches += nextnodes;
            maxnodes -= nextnodes;
            graph.setEdge(hostName, targetHostName);
        }
        return branches;
    }
}

