/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.MessageBoard;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Messages_p {
    private static final String PEERSKNOWN = "peersKnown_";

    public static String dateString(Date date) {
        return GenericFormatter.SIMPLE_FORMATTER.format(date);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        MessageBoard.entry message2;
        String key;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String context = YaCyDefaultServlet.getContext(header, sb);
        String peerName = sb.peers.mySeed().getName();
        prop.put("context", context);
        prop.putXML("peerName", peerName);
        if (sb.peers != null && sb.peers.sizeConnected() > 0) {
            prop.put("peersKnown", "1");
            int peerCount = 0;
            try {
                String peername;
                TreeMap<String, String> hostList = new TreeMap<String, String>();
                Iterator<Seed> e = sb.peers.seedsConnected(true, false, null, 0.0);
                while (e.hasNext()) {
                    Seed seed = e.next();
                    if (seed == null) continue;
                    hostList.put(seed.get("Name", "nameless"), seed.hash);
                }
                while ((peername = (String)hostList.firstKey()) != null) {
                    String Hash = (String)hostList.get(peername);
                    prop.put("peersKnown_peers_" + peerCount + "_hash", Hash);
                    prop.putXML("peersKnown_peers_" + peerCount + "_name", peername);
                    hostList.remove(peername);
                    ++peerCount;
                }
            }
            catch (Exception hostList) {
                // empty catch block
            }
            prop.put("peersKnown_peers", peerCount);
        } else {
            prop.put("peersKnown", "0");
        }
        prop.put("mode", "0");
        prop.put("mode_error", "0");
        String action = post == null ? "list" : post.get("action", "list");
        File notifierSource = new File(sb.getAppPath(), sb.getConfig("htRootPath", "htroot") + "/env/grafics/empty.gif");
        File notifierDest = new File(sb.getDataPath("htDocsPath", "DATA/HTDOCS"), "notifier.gif");
        try {
            Files.copy((File)notifierSource, (File)notifierDest);
        }
        catch (IOException Hash) {
            // empty catch block
        }
        if (action.equals("delete")) {
            key = post == null ? "" : post.get("object", "");
            sb.messageDB.remove(key);
            action = "list";
        }
        if (action.equals("list")) {
            prop.put("mode", "0");
            try {
                Iterator<String> i = sb.messageDB.keys(null, true);
                boolean dark = true;
                int count = 0;
                while (i.hasNext()) {
                    String key2 = i.next();
                    message2 = sb.messageDB.read(key2);
                    prop.put("mode_messages_" + count + "_dark", dark ? "1" : "0");
                    prop.put("mode_messages_" + count + "_date", Messages_p.dateString(message2.date()));
                    prop.putXML("mode_messages_" + count + "_from", message2.author());
                    prop.putXML("mode_messages_" + count + "_to", message2.recipient());
                    prop.putXML("mode_messages_" + count + "_subject", message2.subject());
                    prop.putXML("mode_messages_" + count + "_category", message2.category());
                    prop.putXML("mode_messages_" + count + "_key", key2);
                    prop.put("mode_messages_" + count + "_hash", message2.authorHash());
                    if (header.getPathInfo().endsWith(".rss")) {
                        prop.put("mode_messages_" + count + "_context", context);
                        prop.put("mode_messages_" + count + "_rfc822Date", HeaderFramework.formatRFC1123(message2.date()));
                        prop.putXML("mode_messages_" + count + "_body", UTF8.String(message2.message()));
                    }
                    dark = !dark;
                    ++count;
                }
                prop.put("mode_messages", count);
            }
            catch (IOException e) {
                prop.put("mode_error", "1");
                prop.putHTML("mode_error_message", e.getMessage());
            }
        }
        if (action.equals("view")) {
            prop.put("mode", "1");
            key = post == null ? "" : post.get("object", "");
            message2 = sb.messageDB.read(key);
            if (message2 == null) {
                throw new NullPointerException("Message with ID " + key + " does not exist");
            }
            prop.putXML("mode_from", message2.author());
            prop.putXML("mode_to", message2.recipient());
            prop.put("mode_date", Messages_p.dateString(message2.date()));
            prop.putXML("mode_subject", message2.subject());
            String theMessage = null;
            theMessage = UTF8.String(message2.message());
            prop.putWiki("mode_message", theMessage);
            prop.put("mode_hash", message2.authorHash());
            prop.putXML("mode_key", key);
        }
        return prop;
    }
}

