/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.HFClient;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexPackDownloader_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Map<String, List<String>> hfmap;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post != null) {
            String dlsource = post.get("dlsource", "");
            String dlrepoid = post.get("dlrepoid", "");
            String dlfile = post.get("dlfile", "");
            if (!dlsource.isEmpty() && !dlrepoid.isEmpty() && !dlfile.isEmpty() && dlsource.equals("Huggingface")) {
                try {
                    byte[] b = HFClient.downloadFile(dlrepoid, dlfile);
                    if (b == null || b.length == 0) {
                        throw new IOException("downloaded file is empty");
                    }
                    File holdFile = new File(sb.packsHoldPath, dlfile);
                    if (!holdFile.getParentFile().exists()) {
                        holdFile.getParentFile().mkdirs();
                    }
                    FileUtils.copy(b, holdFile);
                    prop.put("reload", 1L);
                }
                catch (Exception e) {
                    sb.log.warn("error downloading from HuggingFace: " + e.getMessage(), e);
                }
            }
        }
        prop.put("reload", 0L);
        int i = 0;
        boolean dark = true;
        try {
            hfmap = HFClient.getAllPacks(true);
        }
        catch (IOException | InterruptedException e) {
            hfmap = new HashMap<String, List<String>>();
        }
        Map<String, String> packsMap = sb.packsMap();
        for (Map.Entry<String, List<String>> entry2 : hfmap.entrySet()) {
            String repoid = entry2.getKey();
            List<String> files = entry2.getValue();
            for (String file : files) {
                if (file == null || file.isEmpty()) continue;
                prop.put("packs-source_" + i + "_source", "Huggingface");
                prop.put("packs-source_" + i + "_repoid", repoid);
                prop.put("packs-source_" + i + "_repourl", "https://huggingface.co/datasets/" + repoid);
                prop.put("packs-source_" + i + "_file", file);
                String localPath = packsMap.get(file);
                if (localPath == null) {
                    prop.put("packs-source_" + i + "_process", "<a class=\"btn btn-primary\" href=\"IndexPackDownloader_p.html?dlsource=Huggingface&dlrepoid=" + repoid + "&dlfile=" + file + "\" role=\"button\">download</a>");
                } else {
                    prop.put("packs-source_" + i + "_process", "file is downloaded; location: " + localPath);
                }
                prop.put("packs_source" + i + "_dark", dark ? "1" : "0");
                ++i;
                dark = !dark;
            }
        }
        prop.put("packs-source", i);
        return prop;
    }
}

