/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class IndexExport_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        long ucount;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        long ucount200 = ucount = segment.fulltext().collectionSize();
        try {
            ucount200 = segment.fulltext().getDefaultConnector().getCountByQuery(CollectionSchema.httpstatus_i.getSolrFieldName() + ":200");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        prop.put("reload", 0L);
        prop.put("lurlexport", 0L);
        prop.putNum("ucount", ucount);
        prop.putNum("ucount200", ucount200);
        Fulltext.Export export = segment.fulltext().export();
        if (export != null && export.isAlive()) {
            prop.put("lurlexport", 2L);
            prop.put("lurlexportfinished", 0L);
            prop.put("lurlexporterror", 0L);
            prop.put("lurlexport_exportfile", export.file().toString());
            prop.put("lurlexport_urlcount", export.docCount());
            prop.put("reload", 1L);
        } else {
            prop.put("lurlexport", 1L);
            prop.put("lurlexport_exportfilepath", String.valueOf(sb.getDataPath()) + "/DATA/EXPORT/");
            if (export == null) {
                prop.put("lurlexportfinished", 0L);
                prop.put("lurlexporterror", 0L);
            } else {
                prop.put("lurlexportfinished", 1L);
                prop.put("lurlexportfinished_exportfile", export.file().toString());
                prop.put("lurlexportfinished_urlcount", export.docCount());
                if (export.failed() == null) {
                    prop.put("lurlexporterror", 0L);
                } else {
                    prop.put("lurlexporterror", 1L);
                    prop.put("lurlexporterror_exportfile", export.file().toString());
                    prop.put("lurlexporterror_exportfailmsg", export.failed());
                }
            }
        }
        if (post == null || env == null) {
            return prop;
        }
        if (post.containsKey("lurlexport")) {
            Fulltext.ExportFormat format = Fulltext.ExportFormat.text;
            String fname = post.get("format", "url-text");
            boolean dom = fname.startsWith("dom");
            boolean text = fname.startsWith("text");
            if (fname.endsWith("text")) {
                format = Fulltext.ExportFormat.text;
            }
            if (fname.endsWith("html")) {
                format = Fulltext.ExportFormat.html;
            }
            String filter = post.get("exportfilter", ".*");
            Object query2 = post.get("exportquery", "*:*");
            int maxseconds = post.getInt("exportmaxseconds", -1);
            long maxChunkSize = post.getLong("maxchunksize", Long.MAX_VALUE);
            if (maxChunkSize <= 0L) {
                maxChunkSize = Long.MAX_VALUE;
            }
            String path = post.get("exportfilepath", "");
            boolean minified = post.get("minified", "no").equals("yes");
            if (maxseconds != -1) {
                sb.tables.recordAPICall(post, "IndexExport_p.html", "dump", String.valueOf((Object)format) + "-dump, q=" + (String)query2 + ", maxseconds=" + maxseconds);
            }
            try {
                Date lastdate;
                Date firstdate;
                long doccount;
                File filepath = new File(path);
                long now = System.currentTimeMillis();
                if (maxseconds > 0) {
                    long from = now - (long)maxseconds * 1000L;
                    String nowstr = new Date(now).toInstant().toString();
                    String fromstr = new Date(from).toInstant().toString();
                    String dateq = CollectionSchema.load_date_dt.getSolrFieldName() + ":[" + fromstr + " TO " + nowstr + "]";
                    query2 = query2 == null || "*:*".equals(query2) ? dateq : (String)query2 + " AND " + dateq;
                } else {
                    query2 = query2 == null ? "*:*" : query2;
                }
                SolrDocumentList firstdoclist = sb.index.fulltext().getDefaultConnector().getDocumentListByQuery((String)query2, CollectionSchema.load_date_dt.getSolrFieldName() + " asc", 0, 1, CollectionSchema.load_date_dt.getSolrFieldName());
                SolrDocumentList lastdoclist = sb.index.fulltext().getDefaultConnector().getDocumentListByQuery((String)query2, CollectionSchema.load_date_dt.getSolrFieldName() + " desc", 0, 1, CollectionSchema.load_date_dt.getSolrFieldName());
                if (firstdoclist.size() == 0 || lastdoclist.size() == 0) {
                    doccount = sb.index.fulltext().getDefaultConnector().getCountByQuery((String)query2);
                    if (doccount == 0L) {
                        throw new IOException("number of exported documents == 0");
                    }
                    firstdate = new Date(0L);
                    lastdate = new Date(0L);
                } else {
                    doccount = firstdoclist.getNumFound();
                    SolrDocument firstdoc = (SolrDocument)firstdoclist.get(0);
                    SolrDocument lastdoc = (SolrDocument)lastdoclist.get(0);
                    Object firstdateobject = firstdoc.getFieldValue(CollectionSchema.load_date_dt.getSolrFieldName());
                    Object lastdateobject = lastdoc.getFieldValue(CollectionSchema.load_date_dt.getSolrFieldName());
                    if (firstdateobject instanceof Date) {
                        firstdate = (Date)firstdateobject;
                    } else {
                        ConcurrentLog.warn("Fulltext", "The required field " + CollectionSchema.load_date_dt.getSolrFieldName() + " is empty on document with id : " + String.valueOf(firstdoc.getFieldValue(CollectionSchema.id.getSolrFieldName())));
                        firstdate = new Date(0L);
                    }
                    if (lastdateobject instanceof Date) {
                        lastdate = (Date)lastdateobject;
                    } else {
                        ConcurrentLog.warn("Fulltext", "The required field " + CollectionSchema.load_date_dt.getSolrFieldName() + " is empty on document with id : " + String.valueOf(lastdoc.getFieldValue(CollectionSchema.id.getSolrFieldName())));
                        lastdate = new Date(0L);
                    }
                }
                String filename = "YaCy-Pack_f" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(firstdate) + "_l" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(lastdate) + "_n" + GenericFormatter.SHORT_MINUTE_FORMATTER.format(new Date(now)) + "_c" + String.format("%1$012d", doccount) + "_tc";
                export = sb.index.fulltext().export(filepath, filename, format.getExt(), filter, (String)query2, format, dom, text, maxChunkSize, minified);
            }
            catch (IOException e) {
                prop.put("lurlexporterror", 1L);
                prop.put("lurlexporterror_exportfile", "-no export-");
                prop.put("lurlexporterror_exportfailmsg", e.getMessage());
                return prop;
            }
            prop.put("lurlexport_exportfile", export.file().toString());
            prop.put("lurlexport_urlcount", export.docCount());
            if (export != null && export.failed() == null) {
                prop.put("lurlexport", 2L);
            }
            prop.put("reload", 1L);
        }
        prop.putNum("ucount", ucount);
        return prop;
    }
}

