/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.geo.GeonamesLocation;
import net.yacy.cora.geo.OpenGeoDBLocation;
import net.yacy.cora.language.synonyms.SynonymLibrary;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.LibraryProvider;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class DictionaryLoader_p {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Response response;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        File synonyms_path = new File(sb.dictionariesPath, "synonyms");
        File synonym_de_default = new File(sb.appPath, "addon/synonyms/openthesaurus_de_yacy");
        File synonym_de_production = new File(synonyms_path, synonym_de_default.getName());
        File synonym_en_default = new File(sb.appPath, "addon/synonyms/mobythesaurus_en_yacy");
        File synonym_en_production = new File(synonyms_path, synonym_en_default.getName());
        File synonym_ru_default = new File(sb.appPath, "addon/synonyms/thesaurus_ru_yacy");
        File synonym_ru_production = new File(synonyms_path, synonym_ru_default.getName());
        for (LibraryProvider.Dictionary dictionary : LibraryProvider.Dictionary.values()) {
            prop.put(dictionary.nickname + "URL", dictionary.url);
            prop.put(dictionary.nickname + "Status_URL", dictionary.url);
            prop.put(dictionary.nickname + "Storage", dictionary.file().toString());
            prop.put(dictionary.nickname + "Status_Storage", dictionary.file().toString());
            prop.put(dictionary.nickname + "Status", dictionary.file().exists() ? 1L : (dictionary.fileDisabled().exists() ? 2L : 0L));
            prop.put(dictionary.nickname + "ActionLoaded", 0L);
            prop.put(dictionary.nickname + "ActionRemoved", 0L);
            prop.put(dictionary.nickname + "ActionActivated", 0L);
            prop.put(dictionary.nickname + "ActionDeactivated", 0L);
        }
        if (post == null) {
            prop.put("syn0Status", synonym_de_production.exists() ? 1L : 0L);
            prop.put("syn1Status", synonym_en_production.exists() ? 1L : 0L);
            prop.put("syn2Status", synonym_ru_production.exists() ? 1L : 0L);
            return prop;
        }
        if (post.containsKey("geon0Load")) {
            try {
                response = sb.loader.load(sb.loader.request(new DigestURL(LibraryProvider.Dictionary.GEON0.url), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] b = response.getContent();
                FileUtils.copy(b, LibraryProvider.Dictionary.GEON0.file());
                LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON0.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON0.file(), null, -1L));
                LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
                prop.put("geon0Status", LibraryProvider.Dictionary.GEON0.file().exists() ? 1L : 0L);
                prop.put("geon0ActionLoaded", 1L);
                String nav = sb.getConfig("search.navigation", "");
                if (nav.indexOf("location") < 0) {
                    sb.setConfig("search.navigation", "location," + nav);
                }
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                prop.put("geon0ActionLoaded", 2L);
                prop.put("geon0ActionLoaded_error", e.getMessage());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("geon0ActionLoaded", 2L);
                prop.put("geon0ActionLoaded_error", e.getMessage());
            }
        }
        if (post.containsKey("geon0Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON0.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON0.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON0.nickname);
            prop.put("geon0ActionRemoved", 1L);
        }
        if (post.containsKey("geon0Deactivate")) {
            LibraryProvider.Dictionary.GEON0.file().renameTo(LibraryProvider.Dictionary.GEON0.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON0.nickname);
            prop.put("geon0ActionDeactivated", 1L);
        }
        if (post.containsKey("geon0Activate")) {
            LibraryProvider.Dictionary.GEON0.fileDisabled().renameTo(LibraryProvider.Dictionary.GEON0.file());
            LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON0.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON0.file(), null, -1L));
            LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
            prop.put("geon0ActionActivated", 1L);
        }
        if (post.containsKey("geon1Load")) {
            try {
                response = sb.loader.load(sb.loader.request(new DigestURL(LibraryProvider.Dictionary.GEON1.url), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] b = response.getContent();
                FileUtils.copy(b, LibraryProvider.Dictionary.GEON1.file());
                LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON1.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON1.file(), null, -1L));
                LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
                prop.put("geon1Status", LibraryProvider.Dictionary.GEON1.file().exists() ? 1L : 0L);
                prop.put("geon1ActionLoaded", 1L);
                String nav = sb.getConfig("search.navigation", "");
                if (nav.indexOf("location") < 0) {
                    sb.setConfig("search.navigation", "location," + nav);
                }
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                prop.put("geon1ActionLoaded", 2L);
                prop.put("geon1ActionLoaded_error", e.getMessage());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("geon1ActionLoaded", 2L);
                prop.put("geon1ActionLoaded_error", e.getMessage());
            }
        }
        if (post.containsKey("geon1Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON1.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON1.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON1.nickname);
            prop.put("geon1ActionRemoved", 1L);
        }
        if (post.containsKey("geon1Deactivate")) {
            LibraryProvider.Dictionary.GEON1.file().renameTo(LibraryProvider.Dictionary.GEON1.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON1.nickname);
            prop.put("geon1ActionDeactivated", 1L);
        }
        if (post.containsKey("geon1Activate")) {
            LibraryProvider.Dictionary.GEON1.fileDisabled().renameTo(LibraryProvider.Dictionary.GEON1.file());
            LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON1.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON1.file(), null, -1L));
            LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
            prop.put("geon1ActionActivated", 1L);
        }
        if (post.containsKey("geon2Load")) {
            try {
                response = sb.loader.load(sb.loader.request(new DigestURL(LibraryProvider.Dictionary.GEON2.url), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] b = response.getContent();
                FileUtils.copy(b, LibraryProvider.Dictionary.GEON2.file());
                LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON2.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON2.file(), null, 100000L));
                LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
                prop.put("geon2Status", LibraryProvider.Dictionary.GEON2.file().exists() ? 1L : 0L);
                prop.put("geon2ActionLoaded", 1L);
                String nav = sb.getConfig("search.navigation", "");
                if (nav.indexOf("location") < 0) {
                    sb.setConfig("search.navigation", "location," + nav);
                }
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                prop.put("geon2ActionLoaded", 2L);
                prop.put("geon2ActionLoaded_error", e.getMessage());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("geon2ActionLoaded", 2L);
                prop.put("geon2ActionLoaded_error", e.getMessage());
            }
        }
        if (post.containsKey("geon2Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON2.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEON2.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON2.nickname);
            prop.put("geon2ActionRemoved", 1L);
        }
        if (post.containsKey("geon2Deactivate")) {
            LibraryProvider.Dictionary.GEON2.file().renameTo(LibraryProvider.Dictionary.GEON2.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEON2.nickname);
            prop.put("geon2ActionDeactivated", 1L);
        }
        if (post.containsKey("geon2Activate")) {
            LibraryProvider.Dictionary.GEON2.fileDisabled().renameTo(LibraryProvider.Dictionary.GEON2.file());
            LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEON2.nickname, new GeonamesLocation(LibraryProvider.Dictionary.GEON2.file(), null, 100000L));
            LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
            prop.put("geon2ActionActivated", 1L);
        }
        if (post.containsKey("geo2Load")) {
            try {
                response = sb.loader.load(sb.loader.request(new DigestURL(LibraryProvider.Dictionary.GEODB2.url), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] b = response.getContent();
                FileUtils.copy(b, LibraryProvider.Dictionary.GEODB2.file());
                LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB2.nickname);
                boolean isUpgrade = false;
                if (LibraryProvider.Dictionary.GEODB0.file().exists()) {
                    isUpgrade = true;
                    FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB0.file());
                    FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB0.fileDisabled());
                    LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB0.nickname);
                } else if (LibraryProvider.Dictionary.GEODB1.file().exists()) {
                    isUpgrade = true;
                    FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB1.file());
                    FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB1.fileDisabled());
                    LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB1.nickname);
                }
                LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEODB2.nickname, new OpenGeoDBLocation(LibraryProvider.Dictionary.GEODB2.file(), null));
                LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
                prop.put("geo2Status", LibraryProvider.Dictionary.GEODB2.file().exists() ? 1L : 0L);
                prop.put("geo2ActionLoaded", isUpgrade ? 3L : 1L);
                String nav = sb.getConfig("search.navigation", "");
                if (nav.indexOf("location") < 0) {
                    sb.setConfig("search.navigation", "location," + nav);
                }
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                prop.put("geo2ActionLoaded", 2L);
                prop.put("geo2ActionLoaded_error", e.getMessage());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("geo2ActionLoaded", 2L);
                prop.put("geo2ActionLoaded_error", e.getMessage());
            }
        }
        if (post.containsKey("geo0Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB0.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB0.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB0.nickname);
            prop.put("geo0ActionRemoved", 1L);
        }
        if (post.containsKey("geo0Deactivate")) {
            LibraryProvider.Dictionary.GEODB0.file().renameTo(LibraryProvider.Dictionary.GEODB0.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB0.nickname);
            prop.put("geo0ActionDeactivated", 1L);
        }
        if (post.containsKey("geo1Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB1.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB1.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB1.nickname);
            prop.put("geo1ActionRemoved", 1L);
        }
        if (post.containsKey("geo1Deactivate")) {
            LibraryProvider.Dictionary.GEODB1.file().renameTo(LibraryProvider.Dictionary.GEODB1.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB1.nickname);
            prop.put("geo1ActionDeactivated", 1L);
        }
        if (post.containsKey("geo2Remove")) {
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB2.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.GEODB2.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB2.nickname);
            prop.put("geo2ActionRemoved", 1L);
        }
        if (post.containsKey("geo2Deactivate")) {
            LibraryProvider.Dictionary.GEODB2.file().renameTo(LibraryProvider.Dictionary.GEODB2.fileDisabled());
            LibraryProvider.geoLoc.deactivateLocalization(LibraryProvider.Dictionary.GEODB2.nickname);
            prop.put("geo2ActionDeactivated", 1L);
        }
        if (post.containsKey("geo2Activate")) {
            LibraryProvider.Dictionary.GEODB2.fileDisabled().renameTo(LibraryProvider.Dictionary.GEODB2.file());
            LibraryProvider.geoLoc.activateLocation(LibraryProvider.Dictionary.GEODB2.nickname, new OpenGeoDBLocation(LibraryProvider.Dictionary.GEODB2.file(), null));
            LibraryProvider.autotagging.addPlaces(LibraryProvider.geoLoc);
            prop.put("geo2ActionActivated", 1L);
        }
        if (post.containsKey("drw0Load")) {
            try {
                response = sb.loader.load(sb.loader.request(new DigestURL(LibraryProvider.Dictionary.DRW0.url), false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                byte[] b = response.getContent();
                FileUtils.copy(b, LibraryProvider.Dictionary.DRW0.file());
                LibraryProvider.activateDeReWo();
                LibraryProvider.initDidYouMean();
                prop.put("drw0Status", LibraryProvider.Dictionary.DRW0.file().exists() ? 1L : 0L);
                prop.put("drw0ActionLoaded", 1L);
            }
            catch (MalformedURLException e) {
                ConcurrentLog.logException(e);
                prop.put("drw0ActionLoaded", 2L);
                prop.put("drw0ActionLoaded_error", e.getMessage());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("drw0ActionLoaded", 2L);
                prop.put("drw0ActionLoaded_error", e.getMessage());
            }
        }
        if (post.containsKey("drw0Remove")) {
            LibraryProvider.deactivateDeReWo();
            LibraryProvider.initDidYouMean();
            FileUtils.deletedelete(LibraryProvider.Dictionary.DRW0.file());
            FileUtils.deletedelete(LibraryProvider.Dictionary.DRW0.fileDisabled());
            prop.put("drw0ActionRemoved", 1L);
        }
        if (post.containsKey("drw0Deactivate")) {
            LibraryProvider.deactivateDeReWo();
            LibraryProvider.initDidYouMean();
            LibraryProvider.Dictionary.DRW0.file().renameTo(LibraryProvider.Dictionary.DRW0.fileDisabled());
            prop.put("drw0ActionDeactivated", 1L);
        }
        if (post.containsKey("drw0Activate")) {
            LibraryProvider.Dictionary.DRW0.fileDisabled().renameTo(LibraryProvider.Dictionary.DRW0.file());
            LibraryProvider.activateDeReWo();
            LibraryProvider.initDidYouMean();
            prop.put("drw0ActionActivated", 1L);
        }
        if (post.containsKey("syn0Deactivate")) {
            synonym_de_production.delete();
            SynonymLibrary.init(synonyms_path);
        }
        if (post.containsKey("syn0Activate")) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(synonym_de_default);
                FileUtils.copy((InputStream)inStream, synonym_de_production);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ignored) {
                        ConcurrentLog.warn("DictionaryLoader", "Could not close file " + synonym_de_default.getName());
                    }
                }
            }
            SynonymLibrary.init(synonyms_path);
        }
        if (post.containsKey("syn1Deactivate")) {
            synonym_en_production.delete();
            SynonymLibrary.init(synonyms_path);
        }
        if (post.containsKey("syn1Activate")) {
            try {
                FileUtils.copy((InputStream)new FileInputStream(synonym_en_default), synonym_en_production);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            SynonymLibrary.init(synonyms_path);
        }
        if (post.containsKey("syn2Deactivate")) {
            synonym_ru_production.delete();
            SynonymLibrary.init(synonyms_path);
        }
        if (post.containsKey("syn2Activate")) {
            try {
                FileUtils.copy((InputStream)new FileInputStream(synonym_ru_default), synonym_ru_production);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            SynonymLibrary.init(synonyms_path);
        }
        if (post != null) {
            prop.put("syn0Status", synonym_de_production.exists() ? 1L : 0L);
            prop.put("syn1Status", synonym_en_production.exists() ? 1L : 0L);
            prop.put("syn2Status", synonym_ru_production.exists() ? 1L : 0L);
        }
        boolean keepPlacesTagging = false;
        for (LibraryProvider.Dictionary dictionary : LibraryProvider.Dictionary.values()) {
            int newstatus;
            int n = dictionary.file().exists() ? 1 : (newstatus = dictionary.fileDisabled().exists() ? 2 : 0);
            if (newstatus == 1) {
                keepPlacesTagging = true;
            }
            prop.put(dictionary.nickname + "Status", newstatus);
        }
        if (!keepPlacesTagging) {
            LibraryProvider.autotagging.removePlaces();
        }
        return prop;
    }
}

