/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.Scanner;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.WorkTables;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class CrawlStartScanner_p {
    private static final int CONCURRENT_RUNNER = 200;

    /*
     * WARNING - void declaration
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        SearchEventCache.cleanupEvents(true);
        prop.put("noserverdetected", 0L);
        prop.put("hosts", "");
        prop.put("intranet.checked", sb.isIntranetMode() ? 1L : 0L);
        int timeout = sb.isIntranetMode() ? 200 : 3000;
        timeout = post == null ? timeout : post.getInt("timeout", timeout);
        String hostt = post == null ? "" : post.get("scanhosts", "").trim();
        boolean listall = false;
        if (hostt.equals("*") || post != null && "all".equals(post.get("source", ""))) {
            hostt = "";
            listall = true;
            post.put("source", "hosts");
        }
        String[] hosts0 = hostt.indexOf(10) > 0 || hostt.indexOf(13) > 0 ? hostt.split("[\\r\\n]+") : hostt.split(Pattern.quote(","));
        LinkedHashSet<String> hostSet = new LinkedHashSet<String>();
        for (String string : hosts0) {
            if (string == null || string.length() <= 0) continue;
            hostSet.add(string);
        }
        Set<InetAddress> ips = Domains.myIntranetIPs();
        prop.put("intranethosts", ips.toString());
        prop.put("intranetHint", sb.isIntranetMode() ? 0L : 1L);
        if (hostSet.isEmpty()) {
            if (sb.isIntranetMode()) {
                InetAddress ip = !ips.isEmpty() ? ips.iterator().next() : Domains.dnsResolve("192.168.0.1");
                if (ip != null) {
                    hostSet.add(ip.getHostAddress());
                }
            } else {
                HashSet<InetAddress> myPublicIPs = new HashSet<InetAddress>();
                myPublicIPs.addAll(Domains.myPublicIPv4());
                myPublicIPs.addAll(Domains.myPublicIPv6());
                for (InetAddress myPublicIP : myPublicIPs) {
                    if (Domains.isThisHostIP(myPublicIP)) {
                        Set<String> myIPs = sb.peers.mySeed().getIPs();
                        for (String myIP : myIPs) {
                            InetAddress ip = Domains.dnsResolve(myIP);
                            if (ip == null) continue;
                            hostSet.add(ip.getHostAddress());
                        }
                        continue;
                    }
                    hostSet.add(myPublicIP.getHostAddress());
                }
            }
        }
        Object hos = "";
        for (String string : hostSet) {
            hos = (String)hos + string + "\n";
        }
        prop.put("scanhosts", ((String)hos).trim());
        if (listall) {
            ReversibleScoreMap<String> hostscore = null;
            try {
                hostscore = sb.index.fulltext().getDefaultConnector().getFacets("*:*", 1000, CollectionSchema.host_s.getSolrFieldName()).get(CollectionSchema.host_s.getSolrFieldName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (hostscore != null) {
                for (String s : hostscore) {
                    hostSet.add(s);
                }
            }
        }
        if (post != null) {
            int repeat_time = 0;
            String string = "seldays";
            if (post.get("rescan", "").equals("scheduler")) {
                repeat_time = post.getInt("repeat_time", -1);
                String string2 = post.get("repeat_unit", "selminutes");
            }
            int subnet = post.getInt("subnet", 24);
            if (post.containsKey("scan")) {
                Scanner scanner = new Scanner(200, timeout);
                boolean scanhttp = "on".equals(post.get("scanhttp", ""));
                int scanhttpport = post.getInt("scanhttpport", 80);
                boolean scanhttps = "on".equals(post.get("scanhttps", ""));
                int scanhttpsport = post.getInt("scanhttpsport", 443);
                boolean scanftp = "on".equals(post.get("scanftp", ""));
                boolean scansmb = "on".equals(post.get("scansmb", ""));
                if ("hosts".equals(post.get("source", ""))) {
                    for (String host : hostSet) {
                        int p;
                        if (host.startsWith("http://")) {
                            host = host.substring(7);
                        }
                        if (host.startsWith("https://")) {
                            host = host.substring(8);
                        }
                        if (host.startsWith("ftp://")) {
                            host = host.substring(6);
                        }
                        if (host.startsWith("smb://")) {
                            host = host.substring(6);
                        }
                        if ((p = host.indexOf(47, 0)) >= 0) {
                            host = host.substring(0, p);
                        }
                        ArrayList<InetAddress> scanbase = new ArrayList<InetAddress>();
                        if (host.length() > 0) {
                            InetAddress ip = Domains.dnsResolve(host);
                            if (ip != null) {
                                scanbase.add(ip);
                            }
                            if ((host.startsWith("ftp.") || host.startsWith("www.") || host.startsWith("blog.") || host.startsWith("wiki.") || host.startsWith("forum.") || host.startsWith("forums.") || host.startsWith("events.") || host.startsWith("bugs.")) && !hostSet.contains(host = host.substring(host.indexOf(46) + 1)) && (ip = Domains.dnsResolve(host)) != null) {
                                scanbase.add(ip);
                            }
                            if (scanftp && !hostSet.contains("ftp." + host) && (ip = Domains.dnsResolve("ftp." + host)) != null) {
                                scanbase.add(ip);
                            }
                            if ((scanhttp || scanhttps) && !hostSet.contains("www." + host) && (ip = Domains.dnsResolve("www." + host)) != null) {
                                scanbase.add(ip);
                            }
                        }
                        scanner.addProtocols(Scanner.genlist(scanbase, subnet), scanhttp, scanhttpport, scanhttps, scanhttpsport, scanftp, scansmb);
                    }
                }
                if ("intranet".equals(post.get("source", ""))) {
                    scanner.addProtocols(Scanner.genlist(Domains.myIntranetIPs(), subnet), scanhttp, scanhttpport, scanhttps, scanhttpsport, scanftp, scansmb);
                }
                scanner.terminate();
                if ("on".equals(post.get("accumulatescancache", "")) && !"scheduler".equals(post.get("rescan", ""))) {
                    Scanner.scancacheExtend(scanner);
                } else {
                    Scanner.scancacheReplace(scanner);
                }
            }
            if (post.containsKey("crawl")) {
                Iterator<Map.Entry<Scanner.Service, Scanner.Access>> se = Scanner.scancacheEntries();
                TreeMap<byte[], DigestURL> pkmap = new TreeMap<byte[], DigestURL>(Base64Order.enhancedCoder);
                while (se.hasNext()) {
                    Scanner.Service u = se.next().getKey();
                    try {
                        DigestURL uu = u.url();
                        pkmap.put(uu.hash(), uu);
                    }
                    catch (MalformedURLException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                for (Map.Entry<String, String> entry2 : post.entrySet()) {
                    byte[] pk;
                    DigestURL url;
                    if (!entry2.getValue().startsWith("mark_") || (url = (DigestURL)pkmap.get(pk = entry2.getValue().substring(5).getBytes())) == null) continue;
                    Object path = "/Crawler_p.html?createBookmark=off&xsstopw=off&crawlingDomMaxPages=10000&intention=&range=domain&indexMedia=on&recrawl=nodoubles&xdstopw=off&storeHTCache=on&sitemapURL=&repeat_time=7&crawlingQ=on&cachePolicy=iffresh&indexText=on&crawlingMode=url&mustnotmatch=&crawlingDomFilterDepth=1&crawlingDomFilterCheck=off&crawlingstart=Start%20New%20Crawl&xpstopw=off&repeat_unit=seldays&crawlingDepth=99&directDocByURL=on";
                    path = (String)path + "&crawlingURL=" + url.toNormalform(true);
                    WorkTables.execGetAPICall("localhost", sb.getLocalPort(), (String)path, pk, sb.getConfig("adminAccountUserName", "admin"), sb.getConfig("adminAccountBase64MD5", ""));
                }
            }
            if ("scheduler".equals(post.get("rescan", ""))) {
                if (repeat_time > 0) {
                    void var13_30;
                    sb.tables.recordAPICall(post, "CrawlStartScanner_p.html", "crawler", "network scanner for hosts: " + ((Object)hostSet).toString(), repeat_time, var13_30.substring(3));
                }
                if (Scanner.scancacheSize() > 0) {
                    Map<byte[], String> apiCommentCache = WorkTables.commentCache(sb);
                    try {
                        Iterator<Map.Entry<Scanner.Service, Scanner.Access>> se = Scanner.scancacheEntries();
                        while (se.hasNext()) {
                            Map.Entry<Scanner.Service, Scanner.Access> host = se.next();
                            try {
                                DigestURL u = host.getKey().url();
                                String urlString = u.toNormalform(true);
                                if (host.getValue() != Scanner.Access.granted || Scanner.inIndex(apiCommentCache, urlString) != null) continue;
                                Object path = "/Crawler_p.html?createBookmark=off&xsstopw=off&crawlingDomMaxPages=10000&intention=&range=domain&indexMedia=on&recrawl=nodoubles&xdstopw=off&storeHTCache=on&sitemapURL=&repeat_time=7&crawlingQ=on&cachePolicy=iffresh&indexText=on&crawlingMode=url&mustnotmatch=&crawlingDomFilterDepth=1&crawlingDomFilterCheck=off&crawlingstart=Start%20New%20Crawl&xpstopw=off&repeat_unit=seldays&crawlingDepth=99";
                                path = (String)path + "&crawlingURL=" + urlString;
                                WorkTables.execGetAPICall("localhost", sb.getLocalPort(), (String)path, u.hash(), sb.getConfig("adminAccountUserName", "admin"), sb.getConfig("adminAccountBase64MD5", ""));
                            }
                            catch (MalformedURLException e) {
                                ConcurrentLog.logException(e);
                            }
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            }
        }
        return prop;
    }
}

