/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.ArrayList;
import java.util.Collection;
import net.yacy.cora.federate.solr.instance.EmbeddedInstance;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.Html2Image;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.document.LibraryProvider;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.core.SolrCore;

public class CrawlStartExpert {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String agentName;
        Integer maxPages;
        Integer depth;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String defaultCollection = "user";
        prop.put("matchAllStr", ".*");
        prop.put("matchNoneStr", "");
        prop.put("solrQueryMatchAllStr", "*:*");
        prop.put("solrEmptyQueryStr", "");
        prop.put("defaultCollection", "user");
        if (post != null && post.containsKey("crawlingURL")) {
            String crawlingURL = post.get("crawlingURL", "").replaceAll("%0D%0A", "\n").replaceAll("%0A", "\n").replaceAll("%0D", "\n");
            prop.put("starturl", crawlingURL);
            if (!crawlingURL.trim().isEmpty()) {
                prop.put("has_url", 1L);
            }
        } else {
            prop.put("starturl", "");
        }
        if (post != null && post.containsKey("sitemapURL")) {
            String sitemapURL = post.get("sitemapURL", "");
            prop.put("sitemapURL", sitemapURL);
            if (!sitemapURL.trim().isEmpty()) {
                prop.put("has_sitemapURL", 1L);
            }
        } else {
            prop.put("sitemapURL", "");
        }
        if (post != null && post.containsKey("crawlingFile")) {
            String crawlingFile = post.get("crawlingFile", "");
            prop.put("crawlingFile", crawlingFile);
            if (!crawlingFile.trim().isEmpty()) {
                prop.put("has_crawlingFile", 1L);
            }
        } else {
            prop.put("crawlingFile", "");
        }
        if (post != null && post.containsKey("crawlingMode")) {
            String crawlingMode = post.get("crawlingMode", "");
            boolean hasMode = false;
            if (crawlingMode.equalsIgnoreCase("sitelist") && prop.getBoolean("has_url")) {
                prop.put("crawlingMode_sitelist", 1L);
                hasMode = true;
            } else if (crawlingMode.equalsIgnoreCase("sitemap") && prop.getBoolean("has_sitemapURL")) {
                prop.put("crawlingMode_sitemap", 1L);
                hasMode = true;
            } else if (crawlingMode.equalsIgnoreCase("file") && prop.getBoolean("has_crawlingFile")) {
                prop.put("crawlingMode_file", 1L);
                hasMode = true;
            } else if (crawlingMode.equalsIgnoreCase("url") && prop.getBoolean("has_crawlingURL")) {
                prop.put("crawlingMode_url", 1L);
                hasMode = true;
            }
            if (!hasMode) {
                if (prop.getBoolean("has_url")) {
                    prop.put("crawlingMode_url", 1L);
                } else if (prop.getBoolean("has_sitemapURL")) {
                    prop.put("crawlingMode_sitemap", 1L);
                } else if (prop.getBoolean("has_crawlingFile")) {
                    prop.put("crawlingMode_file", 1L);
                } else {
                    prop.put("crawlingMode_url", 1L);
                }
            }
        } else {
            prop.put("crawlingMode_url", 1L);
        }
        if (post != null && post.containsKey("bookmarkTitle")) {
            prop.put("bookmarkTitle", post.get("bookmarkTitle", ""));
        } else {
            prop.put("bookmarkTitle", "");
        }
        int crawlingDomMaxPages = env.getConfigInt("crawlingDomMaxPages", -1);
        if (post != null && post.containsKey("crawlingDepth") && (depth = Integer.valueOf(post.getInt("crawlingDepth", -1))) >= 0 && depth < 100) {
            prop.put("crawlingDepth", depth.intValue());
        }
        if (!prop.containsKey("crawlingDepth")) {
            prop.put("crawlingDepth", Math.min(3L, env.getConfigLong("crawlingDepth", 0L)));
        }
        if (post == null) {
            prop.put("directDocByURLChecked", sb.getConfigBool("crawlingDirectDocByURL", true) ? 1L : 0L);
        } else {
            prop.put("directDocByURLChecked", post.getBoolean("directDocByURL") ? 1L : 0L);
        }
        if (post != null && post.containsKey("crawlingDepthExtension")) {
            prop.put("crawlingDepthExtension", post.get("crawlingDepthExtension", ""));
        } else {
            prop.put("crawlingDepthExtension", "");
        }
        if (post == null) {
            prop.put("crawlingDomMaxCheck", crawlingDomMaxPages == -1 ? 0L : 1L);
        } else {
            prop.put("crawlingDomMaxCheck", post.getBoolean("crawlingDomMaxCheck") ? 1L : 0L);
        }
        if (post != null && post.containsKey("crawlingDomMaxPages") && (maxPages = Integer.valueOf(post.getInt("crawlingDomMaxPages", -1))) > 0 && maxPages < 1000000) {
            prop.put("crawlingDomMaxPages", maxPages.intValue());
        }
        if (!prop.containsKey("crawlingDomMaxPages")) {
            prop.put("crawlingDomMaxPages", crawlingDomMaxPages == -1 ? 10000L : (long)crawlingDomMaxPages);
        }
        if (post == null) {
            prop.put("crawlingQChecked", env.getConfigBool("crawlingQ", true) ? 1L : 0L);
            prop.put("obeyHtmlRobotsNoindexChecked", env.getConfigBool("obeyHtmlRobotsNoindex", true) ? 1L : 0L);
            prop.put("obeyHtmlRobotsNofollowChecked", env.getConfigBool("obeyHtmlRobotsNofollow", true) ? 1L : 0L);
        } else {
            prop.put("crawlingQChecked", post.getBoolean("crawlingQ") ? 1L : 0L);
            prop.put("obeyHtmlRobotsNoindexChecked", post.getBoolean("obeyHtmlRobotsNoindex") ? 1L : 0L);
            prop.put("obeyHtmlRobotsNofollowChecked", post.getBoolean("obeyHtmlRobotsNofollow") ? 1L : 0L);
        }
        if (post == null) {
            prop.put("crawlerAlwaysCheckMediaType", true);
        } else {
            prop.put("crawlerAlwaysCheckMediaType", post.getBoolean("crawlerAlwaysCheckMediaType"));
        }
        if (post != null && post.containsKey("range")) {
            String range = post.get("range", "");
            if (range.equalsIgnoreCase("domain")) {
                prop.put("range_domain", 1L);
            } else if (range.equalsIgnoreCase("subpath")) {
                prop.put("range_subpath", 1L);
            } else if (range.equalsIgnoreCase("wide")) {
                prop.put("range_wide", 1L);
            }
        } else {
            prop.put("range_wide", 1L);
        }
        if (post != null && post.containsKey("mustmatch")) {
            prop.put("mustmatch", post.get("mustmatch", ""));
        } else {
            prop.put("mustmatch", ".*");
        }
        if (post != null && post.containsKey("mustnotmatch")) {
            prop.put("mustnotmatch", post.get("mustnotmatch", ""));
        } else {
            prop.put("mustnotmatch", "");
        }
        if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTMATCH.key)) {
            prop.put(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTMATCH.key, post.get(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTMATCH.key, ".*"));
        } else {
            prop.put(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTMATCH.key, ".*");
        }
        if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTNOTMATCH.key)) {
            prop.put(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTNOTMATCH.key, post.get(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTNOTMATCH.key, ""));
        } else {
            prop.put(CrawlProfile.CrawlAttribute.CRAWLER_ORIGIN_URL_MUSTNOTMATCH.key, "");
        }
        if (post != null && post.containsKey("ipMustmatch")) {
            prop.put("ipMustmatch", post.get("ipMustmatch", ""));
        } else {
            prop.put("ipMustmatch", sb.getConfig("crawlingIPMustMatch", ".*"));
        }
        if (post != null && post.containsKey("ipMustnotmatch")) {
            prop.put("ipMustnotmatch", post.get("ipMustnotmatch", ""));
        } else {
            prop.put("ipMustnotmatch", sb.getConfig("crawlingIPMustNotMatch", ""));
        }
        if (post == null) {
            prop.put("countryMustMatchSwitchChecked", 0L);
        } else {
            prop.put("countryMustMatchSwitchChecked", post.getBoolean("countryMustMatchSwitch") ? 1L : 0L);
        }
        if (post != null && post.containsKey("countryMustMatchList")) {
            prop.put("countryMustMatch", post.get("countryMustMatchList", ""));
        } else {
            prop.put("countryMustMatch", sb.getConfig("crawlingCountryMustMatch", ""));
        }
        if (post != null && post.containsKey("indexmustmatch")) {
            prop.put("indexmustmatch", post.get("indexmustmatch", ""));
        } else {
            prop.put("indexmustmatch", ".*");
        }
        if (post != null && post.containsKey("indexmustnotmatch")) {
            prop.put("indexmustnotmatch", post.get("indexmustnotmatch", ""));
        } else {
            prop.put("indexmustnotmatch", "");
        }
        if (post != null && post.containsKey("indexcontentmustmatch")) {
            prop.put("indexcontentmustmatch", post.get("indexcontentmustmatch", ""));
        } else {
            prop.put("indexcontentmustmatch", ".*");
        }
        if (post != null && post.containsKey("indexcontentmustnotmatch")) {
            prop.put("indexcontentmustnotmatch", post.get("indexcontentmustnotmatch", ""));
        } else {
            prop.put("indexcontentmustnotmatch", "");
        }
        if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTMATCH.key)) {
            prop.put(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTMATCH.key, post.get(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTMATCH.key, ".*"));
        } else {
            prop.put(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTMATCH.key, ".*");
        }
        if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTNOTMATCH.key)) {
            prop.put(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTNOTMATCH.key, post.get(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTNOTMATCH.key, ""));
        } else {
            prop.put(CrawlProfile.CrawlAttribute.INDEXING_MEDIA_TYPE_MUSTNOTMATCH.key, "");
        }
        EmbeddedInstance embeddedSolr = sb.index.fulltext().getEmbeddedInstance();
        SolrCore embeddedCore = embeddedSolr != null ? embeddedSolr.getDefaultCore() : null;
        boolean embeddedSolrConnected = embeddedSolr != null && embeddedCore != null;
        prop.put("embeddedSolrConnected", embeddedSolrConnected);
        if (embeddedSolrConnected) {
            if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTMATCH.key)) {
                prop.put("embeddedSolrConnected_" + CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTMATCH.key, post.get(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTMATCH.key, "*:*").trim());
            } else {
                prop.put("embeddedSolrConnected_" + CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTMATCH.key, "*:*");
            }
            if (post != null && post.containsKey(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTNOTMATCH.key)) {
                prop.put("embeddedSolrConnected_" + CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTNOTMATCH.key, post.get(CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTNOTMATCH.key, "").trim());
            } else {
                prop.put("embeddedSolrConnected_" + CrawlProfile.CrawlAttribute.INDEXING_SOLR_QUERY_MUSTNOTMATCH.key, "");
            }
        }
        if (post == null) {
            prop.put("noindexWhenCanonicalUnequalURLChecked", 0L);
        } else {
            prop.put("noindexWhenCanonicalUnequalURLChecked", post.getBoolean("noindexWhenCanonicalUnequalURL") ? 1L : 0L);
        }
        prop.put("deleteIfOlderSelect", 1L);
        for (int i = 0; i < 13; ++i) {
            prop.put("deleteIfOlderSelect_list_" + i + "_name", Integer.toString(i));
        }
        prop.put("deleteIfOlderSelect_list_13_name", "14");
        prop.put("deleteIfOlderSelect_list_14_name", "21");
        prop.put("deleteIfOlderSelect_list_15_name", "28");
        prop.put("deleteIfOlderSelect_list_16_name", "30");
        prop.put("deleteIfOlderSelect_list", 17L);
        if (post != null && post.containsKey("deleteIfOlderNumber")) {
            Integer olderNumber = post.getInt("deleteIfOlderNumber", -1);
            if (olderNumber > 0 && olderNumber <= 12) {
                prop.put("deleteIfOlderSelect_list_" + olderNumber + "_default", 1L);
            } else {
                switch (olderNumber) {
                    case 21: {
                        prop.put("deleteIfOlderSelect_list_14_default", 1L);
                        break;
                    }
                    case 28: {
                        prop.put("deleteIfOlderSelect_list_15_default", 1L);
                        break;
                    }
                    case 30: {
                        prop.put("deleteIfOlderSelect_list_16_default", 1L);
                        break;
                    }
                    default: {
                        prop.put("deleteIfOlderSelect_list_13_default", 1L);
                    }
                }
            }
        } else {
            prop.put("deleteIfOlderSelect_list_13_default", 1L);
        }
        prop.put("deleteIfOlderUnitSelect", 1L);
        prop.put("deleteIfOlderUnitSelect_list_0_name", "years");
        prop.put("deleteIfOlderUnitSelect_list_0_value", "year");
        prop.put("deleteIfOlderUnitSelect_list_1_name", "months");
        prop.put("deleteIfOlderUnitSelect_list_1_value", "month");
        prop.put("deleteIfOlderUnitSelect_list_2_name", "days");
        prop.put("deleteIfOlderUnitSelect_list_2_value", "day");
        prop.put("deleteIfOlderUnitSelect_list_3_name", "hours");
        prop.put("deleteIfOlderUnitSelect_list_3_value", "hour");
        prop.put("deleteIfOlderUnitSelect_list", 4L);
        if (post != null && post.containsKey("deleteIfOlderUnit")) {
            String olderUnit = post.get("deleteIfOlderUnit", "");
            if (olderUnit.equalsIgnoreCase("year")) {
                prop.put("deleteIfOlderUnitSelect_list_0_default", 1L);
            } else if (olderUnit.equalsIgnoreCase("month")) {
                prop.put("deleteIfOlderUnitSelect_list_1_default", 1L);
            } else if (olderUnit.equalsIgnoreCase("hour")) {
                prop.put("deleteIfOlderUnitSelect_list_3_default", 1L);
            } else {
                prop.put("deleteIfOlderUnitSelect_list_2_default", 1L);
            }
        } else {
            prop.put("deleteIfOlderUnitSelect_list_2_default", 1L);
        }
        if (post != null && post.containsKey("cleanSearchCache")) {
            prop.put("cleanSearchCacheChecked", post.getBoolean("cleanSearchCache"));
        } else {
            prop.put("cleanSearchCacheChecked", !sb.getConfigBool("search.jsresort", false));
        }
        if (post != null && post.containsKey("deleteold")) {
            String deleteold = post.get("deleteold", "");
            if (deleteold.equalsIgnoreCase("on")) {
                prop.put("deleteold_on", 1L);
            } else if (deleteold.equalsIgnoreCase("age")) {
                prop.put("deleteold_age", 1L);
            } else {
                prop.put("deleteold_off", 1L);
            }
        } else {
            prop.put("deleteold_off", 1L);
        }
        prop.put("reloadIfOlderSelect", 1L);
        for (int i = 0; i < 13; ++i) {
            prop.put("reloadIfOlderSelect_list_" + i + "_name", Integer.toString(i));
        }
        prop.put("reloadIfOlderSelect_list_13_name", "14");
        prop.put("reloadIfOlderSelect_list_14_name", "21");
        prop.put("reloadIfOlderSelect_list_15_name", "28");
        prop.put("reloadIfOlderSelect_list_16_name", "30");
        prop.put("reloadIfOlderSelect_list", 17L);
        if (post != null && post.containsKey("reloadIfOlderNumber")) {
            Integer olderNumber = post.getInt("reloadIfOlderNumber", -1);
            if (olderNumber > 0 && olderNumber <= 12) {
                prop.put("reloadIfOlderSelect_list_" + olderNumber + "_default", 1L);
            } else {
                switch (olderNumber) {
                    case 21: {
                        prop.put("reloadIfOlderSelect_list_14_default", 1L);
                        break;
                    }
                    case 28: {
                        prop.put("reloadIfOlderSelect_list_15_default", 1L);
                        break;
                    }
                    case 30: {
                        prop.put("reloadIfOlderSelect_list_16_default", 1L);
                        break;
                    }
                    default: {
                        prop.put("reloadIfOlderSelect_list_13_default", 1L);
                    }
                }
            }
        } else {
            prop.put("reloadIfOlderSelect_list_13_default", 1L);
        }
        prop.put("reloadIfOlderUnitSelect", 1L);
        prop.put("reloadIfOlderUnitSelect_list_0_name", "years");
        prop.put("reloadIfOlderUnitSelect_list_0_value", "year");
        prop.put("reloadIfOlderUnitSelect_list_1_name", "months");
        prop.put("reloadIfOlderUnitSelect_list_1_value", "month");
        prop.put("reloadIfOlderUnitSelect_list_2_name", "days");
        prop.put("reloadIfOlderUnitSelect_list_2_value", "day");
        prop.put("reloadIfOlderUnitSelect_list_3_name", "hours");
        prop.put("reloadIfOlderUnitSelect_list_3_value", "hour");
        prop.put("reloadIfOlderUnitSelect_list", 4L);
        if (post != null && post.containsKey("reloadIfOlderUnit")) {
            String olderUnit = post.get("reloadIfOlderUnit", "");
            if (olderUnit.equalsIgnoreCase("year")) {
                prop.put("reloadIfOlderUnitSelect_list_0_default", 1L);
            } else if (olderUnit.equalsIgnoreCase("month")) {
                prop.put("reloadIfOlderUnitSelect_list_1_default", 1L);
            } else if (olderUnit.equalsIgnoreCase("hour")) {
                prop.put("reloadIfOlderUnitSelect_list_3_default", 1L);
            } else {
                prop.put("reloadIfOlderUnitSelect_list_2_default", 1L);
            }
        } else {
            prop.put("reloadIfOlderUnitSelect_list_2_default", 1L);
        }
        if (post != null && post.containsKey("recrawl")) {
            String recrawl = post.get("recrawl", "");
            if (recrawl.equalsIgnoreCase("reload")) {
                prop.put("recrawl_reload", 1L);
            } else {
                prop.put("recrawl_nodoubles", 1L);
            }
        } else {
            prop.put("recrawl_nodoubles", 1L);
        }
        if (post == null) {
            prop.put("storeHTCacheChecked", env.getConfigBool("storeHTCache", true) ? 1L : 0L);
        } else {
            prop.put("storeHTCacheChecked", post.getBoolean("storeHTCache") ? 1L : 0L);
        }
        if (post != null && post.containsKey("cachePolicy")) {
            String cachePolicy = post.get("cachePolicy", "");
            if (cachePolicy.equalsIgnoreCase("nocache")) {
                prop.put("cachePolicy_nocache", 1L);
            } else if (cachePolicy.equalsIgnoreCase("ifexist")) {
                prop.put("cachePolicy_ifexist", 1L);
            } else if (cachePolicy.equalsIgnoreCase("cacheonly")) {
                prop.put("cachePolicy_cacheonly", 1L);
            } else {
                prop.put("cachePolicy_iffresh", 1L);
            }
        } else {
            prop.put("cachePolicy_iffresh", 1L);
        }
        ArrayList<String> agentNames = new ArrayList<String>();
        agentNames.add("Random Browser");
        agentNames.add("Googlebot");
        if (sb.isIntranetMode()) {
            agentNames.add("YaCy Intranet (greedy)");
        }
        if (sb.isGlobalMode()) {
            agentNames.add("YaCy Internet (cautious)");
        }
        if (ClientIdentification.getAgent("Custom Agent") != null) {
            agentNames.add("Custom Agent");
        }
        String defaultAgentName = (String)agentNames.get(0);
        if (post != null && post.containsKey("agentName") && agentNames.contains(agentName = post.get("agentName", sb.isIntranetMode() ? "YaCy Intranet (greedy)" : "YaCy Internet (cautious)"))) {
            defaultAgentName = agentName;
        }
        for (int i = 0; i < agentNames.size(); ++i) {
            prop.put("list_" + i + "_name", (String)agentNames.get(i));
            prop.put("list_" + i + "_default", ((String)agentNames.get(i)).equals(defaultAgentName) ? 1L : 0L);
        }
        prop.put("list", agentNames.size());
        prop.put("defaultAgentName", sb.isIntranetMode() ? "YaCy Intranet (greedy)" : "YaCy Internet (cautious)");
        if (post != null && post.containsKey("valency_switch_tag_names")) {
            prop.put("valency_switch_tag_names", post.get("valency_switch_tag_names", ""));
        } else {
            prop.put("valency_switch_tag_names", "");
        }
        if (post != null && post.containsKey("default_valency")) {
            String default_valency = post.get("default_valency", "");
            if (default_valency.equalsIgnoreCase("EVAL")) {
                prop.put("default_valency_eval", 1L);
                prop.put("default_valency_ignore", 0L);
            } else if (default_valency.equalsIgnoreCase("IGNORE")) {
                prop.put("default_valency_eval", 0L);
                prop.put("default_valency_ignore", 1L);
                prop.put("default_valency_ignore", 0L);
            } else {
                prop.put("default_valency_eval", 1L);
                prop.put("default_valency_ignore", 0L);
            }
        } else {
            prop.put("default_valency_eval", 1L);
            prop.put("default_valency_ignore", 0L);
        }
        Collection<Tagging> vocs = LibraryProvider.autotagging.getVocabularies();
        if (vocs.size() == 0) {
            prop.put("vocabularySelect", 0L);
        } else {
            prop.put("vocabularySelect", 1L);
            int count = 0;
            for (Tagging v : vocs) {
                String value = post == null ? "" : post.get("vocabulary_" + v.getName() + "_class", "");
                prop.put("vocabularySelect_vocabularyset_" + count + "_name", v.getName());
                prop.put("vocabularySelect_vocabularyset_" + count + "_value", value);
                ++count;
            }
            prop.put("vocabularySelect_vocabularyset", count);
        }
        boolean wkhtmltopdfAvailable = Html2Image.wkhtmltopdfAvailable();
        prop.put("snapshotsMaxDepth", post == null ? "-1" : post.get("snapshotsMaxDepth", "-1"));
        prop.put("snapshotsMustnotmatch", post == null ? "" : post.get("snapshotsMustnotmatch", ""));
        if (wkhtmltopdfAvailable) {
            prop.put("snapshotEnableImages", 1L);
            prop.put("snapshotEnableImages_snapshotsLoadImageChecked", post == null ? 1L : (post.getBoolean("snapshotsLoadImage") ? 1L : 0L));
        } else {
            prop.put("snapshotEnableImages", 0L);
        }
        if (post == null) {
            prop.put("indexingTextChecked", env.getConfigBool("indexText", true) ? 1L : 0L);
            prop.put("indexingMediaChecked", env.getConfigBool("indexMedia", true) ? 1L : 0L);
            if (sb.isP2PMode()) {
                prop.put("remoteindexing", 1L);
                prop.put("remoteindexing_remoteCrawlerDisabled", !sb.getConfigBool("crawlResponse", false));
                prop.put("remoteindexing_remoteCrawlerDisabled_crawlOrderChecked", env.getConfigBool("crawlOrder", true));
                prop.put("remoteindexing_crawlOrderChecked", env.getConfigBool("crawlOrder", true));
                prop.put("remoteindexing_intention", "");
            } else {
                prop.put("remoteindexing", 0L);
            }
        } else {
            prop.put("indexingTextChecked", post.getBoolean("indexText") ? 1L : 0L);
            prop.put("indexingMediaChecked", post.getBoolean("indexMedia") ? 1L : 0L);
            if (sb.isP2PMode()) {
                prop.put("remoteindexing", 1L);
                prop.put("remoteindexing_remoteCrawlerDisabled", !sb.getConfigBool("crawlResponse", false));
                prop.put("remoteindexing_remoteCrawlerDisabled_crawlOrderChecked", post.getBoolean("crawlOrder"));
                prop.put("remoteindexing_crawlOrderChecked", post.getBoolean("crawlOrder"));
                prop.put("remoteindexing_intention", post.get("intention", ""));
            } else {
                prop.put("remoteindexing", 0L);
            }
        }
        boolean collectionEnabled = sb.index.fulltext().getDefaultConfiguration().isEmpty() || sb.index.fulltext().getDefaultConfiguration().contains(CollectionSchema.collection_sxt);
        prop.put("collectionEnabled", collectionEnabled ? 1L : 0L);
        if (collectionEnabled) {
            if (post != null && post.containsKey("collection")) {
                prop.put("collection", post.get("collection", ""));
            } else {
                prop.put("collection", collectionEnabled ? "user" : "");
            }
        }
        return prop;
    }
}

