/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MapTools;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigNetwork_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) throws FileNotFoundException, IOException {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        int commit = 0;
        File networkBootstrapLocationsFile = new File(new File(sb.getAppPath(), "defaults"), "yacy.networks");
        HashSet<String> networkBootstrapLocations = FileUtils.loadList(networkBootstrapLocationsFile);
        if (post != null) {
            sb.tables.recordAPICall(post, "ConfigNetwork_p.html", "configuration", "network settings");
            if (post.containsKey("changeNetwork")) {
                TransactionManager.checkPostTransaction(header, post);
                String networkDefinition = post.get("networkDefinition", "defaults/yacy.network.freeworld.unit");
                String networkDefinitionURL = post.get("networkDefinitionURL", "");
                if (!networkDefinitionURL.equals("")) {
                    networkDefinition = networkDefinitionURL;
                }
                if (networkDefinition.equals(sb.getConfig("network.unit.definition", ""))) {
                    commit = 3;
                } else {
                    commit = 1;
                    sb.setConfig("core.service.rwi.tmp", networkDefinition.indexOf("freeworld") >= 0);
                    sb.switchNetwork(networkDefinition);
                }
            }
            if (post.containsKey("setEncryption")) {
                TransactionManager.checkPostTransaction(header, post);
                boolean httpsPreferred = sb.getConfigBool("network.unit.protocol.https.preferred", false);
                boolean newHttpsPreferred = post.getBoolean("network.unit.protocol.https.preferred");
                if (httpsPreferred == newHttpsPreferred) {
                    commit = 3;
                } else {
                    commit = 1;
                    sb.setConfig("network.unit.protocol.https.preferred", newHttpsPreferred);
                }
            }
            if (post.containsKey("save")) {
                boolean robinsonmode;
                TransactionManager.checkPostTransaction(header, post);
                boolean indexDistribute = "on".equals(post.get("indexDistribute", ""));
                boolean indexReceive = "on".equals(post.get("indexReceive", ""));
                boolean indexReceiveSearch = "on".equals(post.get("indexReceiveSearch", ""));
                if (!indexReceive) {
                    sb.setConfig("heuristic.site", false);
                    sb.setConfig("heuristic.opensearch", false);
                }
                if (robinsonmode = "robinson".equals(post.get("network", ""))) {
                    indexDistribute = false;
                    indexReceive = false;
                    commit = 1;
                } else if (!indexDistribute && !indexReceive) {
                    prop.put("commitDHTIsRobinson", "1");
                    commit = 2;
                } else if (indexDistribute && indexReceive) {
                    commit = 1;
                } else {
                    if (!indexReceive) {
                        prop.put("commitDHTNoGlobalSearch", "1");
                    }
                    commit = 1;
                }
                sb.setConfig("allowDistributeIndex", indexDistribute);
                sb.setConfig("allowDistributeIndexWhileCrawling", "on".equals(post.get("indexDistributeWhileCrawling", "")));
                sb.setConfig("allowDistributeIndexWhileIndexing", "on".equals(post.get("indexDistributeWhileIndexing", "")));
                sb.peers.mySeed().setFlagAcceptRemoteIndex(indexReceive);
                sb.setConfig("allowReceiveIndex", indexReceive);
                sb.setConfig("allowReceiveIndex.search", indexReceiveSearch);
                sb.setConfig("memory.disabledDHT", false);
                sb.setConfig("indexReceiveBlockBlacklist", "on".equals(post.get("indexReceiveBlockBlacklist", "")));
                if (post.containsKey("peertags")) {
                    sb.peers.mySeed().setPeerTags(MapTools.string2set(ConfigNetwork_p.normalizedList(post.get("peertags")), ","));
                }
                sb.setConfig("cluster.mode", post.get("cluster.mode", "publicpeer"));
                sb.setConfig("cluster.peers.ipport", ConfigNetwork_p.checkIPPortList(post.get("cluster.peers.ipport", "")));
                sb.setConfig("cluster.peers.yacydomain", ConfigNetwork_p.checkYaCyDomainList(post.get("cluster.peers.yacydomain", "")));
                sb.clusterhashes = sb.peers.clusterHashes(sb.getConfig("cluster.peers.yacydomain", ""));
            }
        }
        prop.put("commit", commit);
        prop.put("crawlResponse", sb.getConfigBool("crawlResponse", false) ? "1" : "0");
        long RTCbusySleep = Math.max(1, env.getConfigInt("62_remotetriggeredcrawl_busysleep", 100));
        int RTCppm = (int)(60000L / RTCbusySleep);
        prop.put("acceptCrawlLimit", RTCppm);
        prop.put("indexDistributeWhileCrawling.on", sb.getConfigBool("allowDistributeIndexWhileCrawling", true));
        prop.put("indexDistributeWhileCrawling.off", !sb.getConfigBool("allowDistributeIndexWhileCrawling", true));
        prop.put("indexDistributeWhileIndexing.on", sb.getConfigBool("allowDistributeIndexWhileIndexing", true));
        prop.put("indexDistributeWhileIndexing.off", !sb.getConfigBool("allowDistributeIndexWhileIndexing", true));
        prop.put("indexReceiveBlockBlacklistChecked.on", sb.getConfigBool("indexReceiveBlockBlacklist", true));
        prop.put("indexReceiveBlockBlacklistChecked.off", !sb.getConfigBool("indexReceiveBlockBlacklist", true));
        prop.putHTML("peertags", MapTools.set2string(sb.peers.mySeed().getPeerTags(), ",", false));
        boolean indexDistribute = sb.getConfigBool("allowDistributeIndex", true);
        boolean indexReceive = sb.getConfigBool("allowReceiveIndex", true);
        boolean indexReceiveSearch = sb.getConfigBool("allowReceiveIndex.search", true);
        prop.put("indexDistributeChecked", indexDistribute);
        prop.put("indexReceiveChecked", indexReceive);
        prop.put("indexReceiveSearchChecked", indexReceiveSearch);
        sb.peers.mySeed().setFlagAcceptRemoteCrawl(sb.getConfigBool("crawlResponse", false));
        sb.peers.mySeed().setFlagAcceptRemoteIndex(indexReceive);
        prop.put("p2p.checked", indexDistribute || indexReceive);
        prop.put("robinson.checked", !indexDistribute && !indexReceive);
        prop.putHTML("cluster.peers.ipport", sb.getConfig("cluster.peers.ipport", ""));
        prop.putHTML("cluster.peers.yacydomain", sb.getConfig("cluster.peers.yacydomain", ""));
        StringBuilder hashes = new StringBuilder();
        for (byte[] h : sb.clusterhashes) {
            hashes.append(", ").append(ASCII.String(h));
        }
        if (hashes.length() > 2) {
            hashes = hashes.delete(0, 2);
        }
        prop.put("cluster.peers.yacydomain.hashes", hashes.toString());
        prop.put("privatepeerChecked", "privatepeer".equals(sb.getConfig("cluster.mode", "")));
        prop.put("publicclusterChecked", "publiccluster".equals(sb.getConfig("cluster.mode", "")));
        prop.put("publicpeerChecked", "publicpeer".equals(sb.getConfig("cluster.mode", "")));
        prop.putHTML("network.unit.definition", sb.getConfig("network.unit.definition", ""));
        prop.putHTML("network.unit.name", sb.getConfig("network.unit.name", ""));
        prop.putHTML("network.unit.description", sb.getConfig("network.unit.description", ""));
        prop.putHTML("network.unit.domain", sb.getConfig("network.unit.domain", ""));
        prop.putHTML("network.unit.dht", sb.getConfig("network.unit.dht", ""));
        networkBootstrapLocations.remove(sb.getConfig("network.unit.definition", ""));
        int c = 0;
        for (String s : networkBootstrapLocations) {
            prop.put("networks_" + c++ + "_network", s);
        }
        prop.put("networks", c);
        prop.put("network.unit.protocol.https.preferred", sb.getConfigBool("network.unit.protocol.https.preferred", false));
        return prop;
    }

    private static String normalizedList(String input) {
        input = input.replace(' ', ',');
        input = input.replace(' ', ';');
        if ((input = input.replaceAll(",,", ",")).length() > 0 && input.charAt(0) == ',') {
            input = input.substring(1);
        }
        if (input.endsWith(",")) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    private static String checkYaCyDomainList(String input) {
        String[] array = CommonPattern.COMMA.split(ConfigNetwork_p.normalizedList(input));
        StringBuilder output = new StringBuilder();
        for (String element : array) {
            if (!element.endsWith(".yacyh") && !element.endsWith(".yacy") && element.indexOf(".yacyh=", 0) <= 0 && element.indexOf(".yacy=", 0) <= 0) continue;
            output.append(",").append(element);
        }
        if (output.length() == 0) {
            return input;
        }
        return output.delete(0, 1).toString();
    }

    private static String checkIPPortList(String input) {
        String[] array = CommonPattern.COMMA.split(ConfigNetwork_p.normalizedList(input));
        StringBuilder output = new StringBuilder();
        for (String element : array) {
            if (element.indexOf(58, 0) < 9) continue;
            output.append(",").append(element);
        }
        if (input.isEmpty()) {
            return input;
        }
        return output.delete(0, 1).toString();
    }
}

