/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.Seed;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.query.AccessTracker;
import net.yacy.search.query.QueryParams;
import net.yacy.server.serverAccessTracker;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class AccessTracker_p {
    private static Collection<serverAccessTracker.Track> listclone(Collection<serverAccessTracker.Track> m) {
        LinkedBlockingQueue<serverAccessTracker.Track> accessClone = new LinkedBlockingQueue<serverAccessTracker.Track>();
        try {
            accessClone.addAll(m);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return accessClone;
    }

    private static String getRelativePathToThis(String path) {
        String relativePath = path;
        if (path != null && path.startsWith("/")) {
            relativePath = relativePath.substring(1, relativePath.length());
        }
        return relativePath;
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.setLocalized(!header.getPathInfo().endsWith(".xml"));
        int page = 0;
        if (post != null) {
            page = post.getInt("page", 0);
        }
        prop.put("page", page);
        int maxCount = 1000;
        boolean dark = true;
        if (page == 0) {
            int entCount;
            Iterator<String> i = serverAccessTracker.accessHosts();
            try {
                for (entCount = 0; entCount < 1000 && i.hasNext(); ++entCount) {
                    String host = i.next();
                    prop.putHTML("page_list_" + entCount + "_host", host);
                    prop.putNum("page_list_" + entCount + "_countSecond", serverAccessTracker.latestAccessCount(host, 1000L));
                    prop.putNum("page_list_" + entCount + "_countMinute", serverAccessTracker.latestAccessCount(host, 60000L));
                    prop.putNum("page_list_" + entCount + "_count10Minutes", serverAccessTracker.latestAccessCount(host, 600000L));
                    prop.putNum("page_list_" + entCount + "_countHour", serverAccessTracker.latestAccessCount(host, 3600000L));
                }
            }
            catch (ConcurrentModificationException e) {
                ConcurrentLog.logException(e);
            }
            prop.put("page_list", entCount);
            prop.put("page_num", entCount);
            entCount = 0;
            prop.put("page_bflist", entCount);
        } else if (page == 1) {
            String host = post == null ? "" : post.get("host", "");
            int entCount = 0;
            if (host.length() > 0) {
                Collection<serverAccessTracker.Track> access = serverAccessTracker.accessTrack(host);
                if (access != null) {
                    try {
                        for (serverAccessTracker.Track entry2 : AccessTracker_p.listclone(access)) {
                            prop.putHTML("page_list_" + entCount + "_host", host);
                            prop.put("page_list_" + entCount + "_date", GenericFormatter.SIMPLE_FORMATTER.format(new Date(entry2.getTime())));
                            prop.putHTML("page_list_" + entCount + "_path", entry2.getPath());
                            prop.putHTML("page_list_" + entCount + "_relativePath", AccessTracker_p.getRelativePathToThis(entry2.getPath()));
                            ++entCount;
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            } else {
                try {
                    Iterator<String> i = serverAccessTracker.accessHosts();
                    while (entCount < 1000 && i.hasNext()) {
                        host = i.next();
                        Collection<serverAccessTracker.Track> access = serverAccessTracker.accessTrack(host);
                        Iterator<serverAccessTracker.Track> ii = AccessTracker_p.listclone(access).iterator();
                        while (ii.hasNext() && entCount < 1000) {
                            serverAccessTracker.Track entry3 = ii.next();
                            prop.putHTML("page_list_" + entCount + "_host", host);
                            prop.put("page_list_" + entCount + "_date", GenericFormatter.SIMPLE_FORMATTER.format(new Date(entry3.getTime())));
                            prop.putHTML("page_list_" + entCount + "_path", entry3.getPath());
                            prop.putHTML("page_list_" + entCount + "_relativePath", AccessTracker_p.getRelativePathToThis(entry3.getPath()));
                            ++entCount;
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                }
            }
            prop.put("page_list", entCount);
            prop.put("page_num", entCount);
        } else if (page == 2 || page == 4) {
            Iterator<QueryParams> ai = page == 2 ? AccessTracker.get(AccessTracker.Location.local) : AccessTracker.get(AccessTracker.Location.remote);
            long qcountSum = 0L;
            long rcountSum = 0L;
            long tcountSum = 0L;
            long rcount = 0L;
            long utimeSum = 0L;
            long stimeSum = 0L;
            long rtimeSum = 0L;
            long utimeSum1 = 0L;
            long stimeSum1 = 0L;
            long rtimeSum1 = 0L;
            int m = 0;
            while (ai.hasNext()) {
                QueryParams query2;
                try {
                    query2 = ai.next();
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                    break;
                }
                prop.put("page_list_" + m + "_dark", dark ? 1 : 0);
                dark = !dark;
                prop.putHTML("page_list_" + m + "_host", query2.clienthost);
                prop.put("page_list_" + m + "_date", GenericFormatter.SIMPLE_FORMATTER.format(new Date(query2.starttime)));
                prop.put("page_list_" + m + "_timestamp", query2.starttime);
                if (page == 2) {
                    prop.putNum("page_list_" + m + "_offset", query2.offset);
                    prop.putHTML("page_list_" + m + "_querystring", query2.getQueryGoal().getQueryString(false));
                } else {
                    prop.putHTML("page_list_" + m + "_peername", query2.remotepeer == null ? "<unknown>" : query2.remotepeer.getName());
                    prop.put("page_list_" + m + "_queryhashes", QueryParams.anonymizedQueryHashes(query2.getQueryGoal().getIncludeHashes()));
                }
                prop.putNum("page_list_" + m + "_querycount", query2.itemsPerPage);
                prop.putNum("page_list_" + m + "_transmitcount", query2.transmitcount);
                prop.putNum("page_list_" + m + "_resultcount", 0L);
                prop.putNum("page_list_" + m + "_urltime", query2.urlretrievaltime);
                prop.putNum("page_list_" + m + "_snippettime", query2.snippetcomputationtime);
                prop.putNum("page_list_" + m + "_resulttime", query2.searchtime);
                prop.putHTML("page_list_" + m + "_userAgent", query2.userAgent);
                qcountSum += (long)query2.itemsPerPage;
                rcountSum += 0L;
                tcountSum += (long)query2.transmitcount;
                utimeSum += query2.urlretrievaltime;
                stimeSum += query2.snippetcomputationtime;
                rtimeSum += query2.searchtime;
                if (query2.transmitcount > 0) {
                    ++rcount;
                    rtimeSum1 += query2.searchtime;
                }
                ++m;
            }
            prop.put("page_list", m);
            prop.put("page_num", m);
            prop.put("page_resultcount", rcount);
            if (m == 0) {
                m = -1;
                prop.put("page_list", 1L);
                prop.put("page_list_0_dark", 1L);
                prop.put("page_list_0_host", "");
                prop.put("page_list_0_date", "");
                prop.put("page_list_0_timestamp", "");
                if (page == 2) {
                    prop.putNum("page_list_0_offset", "");
                    prop.put("page_list_0_querystring", "");
                } else {
                    prop.put("page_list_0_peername", "");
                    prop.put("page_list_0_queryhashes", "");
                }
                prop.putNum("page_list_0_querycount", "");
                prop.putNum("page_list_0_transmitcount", "");
                prop.putNum("page_list_0_resultcount", "");
                prop.putNum("page_list_0_urltime", "");
                prop.putNum("page_list_0_snippettime", "");
                prop.putNum("page_list_0_resulttime", "");
                prop.put("page_list_0_userAgent", "");
            }
            if (rcount == 0L) {
                rcount = -1L;
            }
            prop.putNum("page_querycount_avg", (double)qcountSum / (double)m);
            prop.putNum("page_resultcount_avg", (double)rcountSum / (double)m);
            prop.putNum("page_urltime_avg", (double)utimeSum / (double)m);
            prop.putNum("page_snippettime_avg", (double)stimeSum / (double)m);
            prop.putNum("page_resulttime_avg", (double)rtimeSum / (double)m);
            prop.putNum("page_transmitcount_avg", (double)tcountSum / (double)rcount);
            prop.putNum("page_resultcount_avg1", (double)rcountSum / (double)rcount);
            prop.putNum("page_urltime_avg1", 0.0 / (double)rcount);
            prop.putNum("page_snippettime_avg1", 0.0 / (double)rcount);
            prop.putNum("page_resulttime_avg1", (double)rtimeSum1 / (double)rcount);
            prop.putNum("page_total", page == 2 ? AccessTracker.size(AccessTracker.Location.local) : AccessTracker.size(AccessTracker.Location.remote));
            if (page == 2 && AccessTracker.getDumpFile() != null && AccessTracker.getDumpFile().exists()) {
                Date toDate = new Date();
                Date fromDate = new Date(toDate.getTime() - 604800000L);
                List<EventTracker.Event> evList = AccessTracker.readLog(AccessTracker.getDumpFile(), fromDate, toDate);
                OrderedScoreMap<String> topicNavigator = new OrderedScoreMap<String>(String.CASE_INSENSITIVE_ORDER);
                for (EventTracker.Event ev : evList) {
                    String[] words;
                    String qs = ev.payload.toString();
                    if (!qs.startsWith("qs ")) continue;
                    for (String w : words = CommonPattern.SPACE.split(qs.substring(3))) {
                        if (w.isEmpty()) continue;
                        topicNavigator.inc(w);
                    }
                }
                if (topicNavigator == null || topicNavigator.isEmpty()) {
                    prop.put("page_nav-topics", "0");
                } else {
                    int i;
                    int TOPWORDS_MAXCOUNT = 25;
                    int TOPWORDS_MINSIZE = 9;
                    int TOPWORDS_MAXSIZE = 24;
                    prop.put("page_nav-topics", "1");
                    int maxcount = topicNavigator.getMaxScore();
                    Iterator navigatorIterator = topicNavigator.iterator();
                    for (i = 0; i < 25 && navigatorIterator.hasNext(); ++i) {
                        String name = (String)navigatorIterator.next();
                        int count = topicNavigator.get(name);
                        prop.put("page_nav-topics_element_" + i + "_on", 1L);
                        prop.put("page_nav-topics_element_" + i + "_name", name);
                        prop.put("page_nav-topics_element_" + i + "_count", count);
                        int fontsize = 9 + 15 * (count / maxcount);
                        fontsize = Math.max(9, fontsize);
                        prop.put("page_nav-topics_element_" + i + "_size", fontsize);
                    }
                    prop.put("page_nav-topics_element", i);
                    prop.put("page_nav-topics_count", i);
                }
            }
        } else if (page == 3 || page == 5) {
            int m;
            Iterator<Map.Entry<String, TreeSet<Long>>> i = page == 3 ? sb.localSearchTracker.entrySet().iterator() : sb.remoteSearchTracker.entrySet().iterator();
            int qphSum = 0;
            try {
                for (m = 0; m < 1000 && i.hasNext(); ++m) {
                    Map.Entry<String, TreeSet<Long>> entry4 = i.next();
                    String host = entry4.getKey();
                    TreeSet<Long> handles = entry4.getValue();
                    int dateCount = 0;
                    for (Long timestamp : handles) {
                        prop.put("page_list_" + m + "_dates_" + dateCount + "_date", GenericFormatter.SIMPLE_FORMATTER.format(new Date(timestamp)));
                        prop.put("page_list_" + m + "_dates_" + dateCount + "_timestamp", timestamp.toString());
                        ++dateCount;
                    }
                    prop.put("page_list_" + m + "_dates", dateCount);
                    int qph = handles.tailSet(System.currentTimeMillis() - 3600000L).size();
                    qphSum += qph;
                    prop.put("page_list_" + m + "_qph", qph);
                    prop.put("page_list_" + m + "_dark", dark ? 1 : 0);
                    dark = !dark;
                    prop.putHTML("page_list_" + m + "_host", host);
                    if (page == 5) {
                        Seed remotepeer = sb.peers.lookupByIP(Domains.dnsResolve(host), -1, true, true, true);
                        prop.putHTML("page_list_" + m + "_peername", remotepeer == null ? "UNKNOWN" : remotepeer.getName());
                    }
                    prop.putNum("page_list_" + m + "_count", handles.size());
                }
            }
            catch (ConcurrentModificationException e) {
                ConcurrentLog.logException(e);
            }
            if (m == 0) {
                prop.put("page_list", 1L);
                prop.put("page_list_0_dates_0_date", "");
                prop.put("page_list_0_dates", 1L);
                prop.putNum("page_list_0_qph", "");
                prop.put("page_list_0_dark", 1L);
                prop.put("page_list_0_peername", "");
                prop.put("page_list_0_host", "");
                prop.putNum("page_list_0_count", "");
            } else {
                prop.put("page_list", m);
            }
            prop.putNum("page_num", m);
            prop.putNum("page_total", page == 3 ? AccessTracker.size(AccessTracker.Location.local) : AccessTracker.size(AccessTracker.Location.remote));
            prop.putNum("page_qph_sum", qphSum);
        }
        return prop;
    }
}

