/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.gui;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.yacy.gui.InfoPage;
import net.yacy.gui.framework.Application;
import net.yacy.gui.framework.Operation;
import net.yacy.gui.framework.Switchboard;
import net.yacy.yacy;
import org.apache.log4j.Logger;

public class YaCyApp {
    public static Logger log = Logger.getLogger(YaCyApp.class);
    private static JFrame app;
    private static Operation operation;
    private static BufferedImage splashImg;
    private static File splashFile;

    public static void start(final String host, final int port) {
        System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "YaCy Search Engine");
        Switchboard.startInfoUpdater();
        operation = new Op(app, host, port);
        final ArrayList<JMenu> menues = new ArrayList<JMenu>();
        JMenu FileMenu = new JMenu("File");
        JMenuItem OpenItem = new JMenuItem("Open");
        OpenItem.setEnabled(false);
        JMenuItem QuitItem = new JMenuItem("Quit");
        QuitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                operation.closeAndExit();
            }
        });
        FileMenu.add(OpenItem);
        FileMenu.add(QuitItem);
        menues.add(FileMenu);
        JMenu EditMenu = new JMenu("Edit");
        JMenuItem CutItem = new JMenuItem("Cut");
        CutItem.setEnabled(false);
        JMenuItem CopyItem = new JMenuItem("Copy");
        CopyItem.setEnabled(false);
        JMenuItem PasteItem = new JMenuItem("Paste");
        PasteItem.setEnabled(false);
        EditMenu.add(CutItem);
        EditMenu.add(CopyItem);
        EditMenu.add(PasteItem);
        menues.add(EditMenu);
        log.info((Object)"Registering Shutdown Hook");
        Thread t = new Thread("YaCyApp"){

            @Override
            public void run() {
                app = new Application("YaCy GUI", operation, menues, new InfoPage(host, port));
                app.setLocationRelativeTo(null);
                app.setVisible(true);
            }
        };
        Switchboard.addShutdownHook(t, yacy.shutdownSemaphore);
        SwingUtilities.invokeLater(t);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Switchboard.load(new File(args[0]));
        }
        YaCyApp.start("localhost", 8090);
    }

    static {
        splashImg = null;
        splashFile = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            ImageIO.setUseCache(false);
            if (splashFile != null) {
                splashImg = ImageIO.read(splashFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Op
    implements Operation {
        JFrame app;
        final String host;
        final int port;

        public Op(JFrame app, String host, int port) {
            this.app = app;
            this.host = host;
            this.port = port;
        }

        @Override
        public void closeAndExit() {
            if (this.app != null) {
                this.app.setVisible(false);
            }
            net.yacy.search.Switchboard.getSwitchboard().terminate(10L, "shutdown request from gui(1)");
            Switchboard.shutdown();
        }
    }

    public class splashCanvas
    extends Canvas {
        private static final long serialVersionUID = -8823028472678019008L;
        ImageObserver obs;

        public splashCanvas(ImageObserver obs) {
            this.obs = obs;
        }

        @Override
        public void paint(Graphics g) {
            if (splashImg != null) {
                g.drawImage(splashImg, 0, 0, this.obs);
            }
        }
    }
}

