/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.naming.SizeLimitExceededException;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.document.parser.html.ContentScraper;
import org.apache.commons.io.input.ClosedInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OOXMLSpreeadsheetHandler
extends DefaultHandler {
    public static final String ENTRY_PREFIX = "xl/worksheets/sheet";
    private static final String CELL_TAG = "c";
    private static final String CELL_TYPE_ATTRIBUTE = "t";
    private static final String CELL_VALUE_TAG = "v";
    private static final String SHARED_STRING_CELL_TYPE = "s";
    private final List<String> sharedStrings;
    private final Writer out;
    private final Collection<AnchorURL> urls;
    private final int maxURLs;
    private long detectedURLs;
    private boolean lastAppendedIsSpace;
    private StringBuilder cellValue;
    private boolean inCell;
    private boolean inCellValue;
    private boolean sharedStringCell;

    public OOXMLSpreeadsheetHandler(List<String> sharedStrings, Writer out, Collection<AnchorURL> urls2) throws IllegalArgumentException {
        this(sharedStrings, out, urls2, Integer.MAX_VALUE);
    }

    public OOXMLSpreeadsheetHandler(List<String> sharedStrings, Writer out, Collection<AnchorURL> urls2, int maxURLs) throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("out writer must not be null");
        }
        if (urls2 == null) {
            throw new IllegalArgumentException("urls collection must not be null");
        }
        this.sharedStrings = sharedStrings;
        this.out = out;
        this.urls = urls2;
        this.maxURLs = maxURLs;
        this.detectedURLs = 0L;
        this.lastAppendedIsSpace = false;
        this.inCell = false;
        this.inCellValue = false;
        this.sharedStringCell = false;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource((InputStream)new ClosedInputStream());
    }

    @Override
    public void startDocument() throws SAXException {
        this.cellValue = new StringBuilder();
        this.detectedURLs = 0L;
        this.lastAppendedIsSpace = false;
        this.inCell = false;
        this.inCellValue = false;
        this.sharedStringCell = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (CELL_TAG.equals(qName)) {
            this.cellValue.setLength(0);
            this.inCell = true;
            String cellType = attributes.getValue(CELL_TYPE_ATTRIBUTE);
            this.sharedStringCell = SHARED_STRING_CELL_TYPE.equals(cellType);
        } else if (this.inCell && CELL_VALUE_TAG.equals(qName)) {
            this.cellValue.setLength(0);
            this.inCellValue = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inCellValue) {
            this.cellValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CELL_VALUE_TAG.equals(qName)) {
            String cellText = null;
            if (this.sharedStringCell) {
                try {
                    int index2 = Integer.parseInt(this.cellValue.toString());
                    if (this.sharedStrings != null && this.sharedStrings.size() > index2) {
                        cellText = this.sharedStrings.get(index2);
                    }
                }
                catch (NumberFormatException index2) {}
            } else {
                cellText = this.cellValue.toString();
            }
            try {
                if (cellText != null && !cellText.isEmpty()) {
                    this.detectedURLs += ContentScraper.findAbsoluteURLs(cellText, this.urls, null, (long)this.maxURLs - this.detectedURLs);
                    if (!this.lastAppendedIsSpace && !Character.isWhitespace(cellText.charAt(0))) {
                        this.out.write(" ");
                    }
                    this.out.write(cellText);
                    this.lastAppendedIsSpace = Character.isWhitespace(cellText.charAt(cellText.length() - 1));
                }
            }
            catch (IOException ioe) {
                throw new SAXException("Error while appending characters to the output writer", ioe);
            }
            finally {
                this.cellValue.setLength(0);
                this.inCellValue = false;
            }
            if (this.detectedURLs >= (long)this.maxURLs) {
                throw new SAXException(new SizeLimitExceededException("Reached maximum URLs to parse : " + this.maxURLs));
            }
        } else if (CELL_TAG.equals(qName)) {
            this.inCell = false;
            this.inCellValue = false;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.cellValue = null;
    }
}

