/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collection;
import javax.naming.SizeLimitExceededException;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.document.parser.html.ContentScraper;
import org.apache.commons.io.input.ClosedInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericXMLContentHandler
extends DefaultHandler {
    private final Writer out;
    private final Collection<AnchorURL> urls;
    private final int maxURLs;
    private long detectedURLs;
    private StringBuilder currentElementText;
    private boolean lastAppendedIsSpace;
    private int currentElementTextChunks;
    private boolean documentHasText;

    public GenericXMLContentHandler(Writer out, Collection<AnchorURL> urls2) throws IllegalArgumentException {
        this(out, urls2, Integer.MAX_VALUE);
    }

    public GenericXMLContentHandler(Writer out, Collection<AnchorURL> urls2, int maxURLs) throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("out writer must not be null");
        }
        if (urls2 == null) {
            throw new IllegalArgumentException("urls collection must not be null");
        }
        this.out = out;
        this.urls = urls2;
        this.maxURLs = maxURLs;
        this.detectedURLs = 0L;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource((InputStream)new ClosedInputStream());
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentElementText = new StringBuilder();
        this.lastAppendedIsSpace = false;
        this.currentElementTextChunks = 0;
        this.documentHasText = false;
        this.detectedURLs = 0L;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElementText.setLength(0);
        this.currentElementTextChunks = 0;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getValue(i);
                this.detectedURLs += ContentScraper.findAbsoluteURLs(attribute, this.urls, null, (long)this.maxURLs - this.detectedURLs);
                if (this.detectedURLs < (long)this.maxURLs) continue;
                throw new SAXException(new SizeLimitExceededException("Reached maximum URLs to parse : " + this.maxURLs));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.currentElementTextChunks == 0 && this.documentHasText && length > 0 && !this.lastAppendedIsSpace && !Character.isWhitespace(ch[0])) {
                this.out.write(" ");
                this.currentElementText.append(" ");
            }
            this.out.write(ch, start, length);
            this.currentElementText.append(ch, start, length);
            if (length > 0) {
                ++this.currentElementTextChunks;
                this.documentHasText = true;
                this.lastAppendedIsSpace = Character.isWhitespace(ch[length - 1]);
            }
        }
        catch (IOException ioe) {
            throw new SAXException("Error while appending characters to the output writer", ioe);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.detectedURLs += ContentScraper.findAbsoluteURLs(this.currentElementText.toString(), this.urls, null, (long)this.maxURLs - this.detectedURLs);
        if (this.detectedURLs >= (long)this.maxURLs) {
            throw new SAXException(new SizeLimitExceededException("Reached maximum URLs to parse : " + this.maxURLs));
        }
        this.currentElementText.setLength(0);
        this.currentElementTextChunks = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        this.currentElementText = null;
    }
}

