/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;

public class sidAudioParser
extends AbstractParser
implements Parser {
    public sidAudioParser() {
        super("Commodore 64 SID Audio File Parser");
        this.SUPPORTED_EXTENSIONS.add("sid");
        this.SUPPORTED_MIME_TYPES.add("audio/prs.sid");
        this.SUPPORTED_MIME_TYPES.add("audio/psid");
        this.SUPPORTED_MIME_TYPES.add("audio/x-psid");
        this.SUPPORTED_MIME_TYPES.add("audio/sidtune");
        this.SUPPORTED_MIME_TYPES.add("audio/x-sidtune");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            int available = source.available();
            byte[] b = new byte[available];
            if (available >= 128 && source.read(b) >= 128) {
                int version2 = (b[4] << 2) + b[5];
                Map<Object, Object> header = new HashMap();
                switch (version2) {
                    case 1: {
                        header = this.parseHeader(b);
                        break;
                    }
                    case 2: {
                        header = this.parseHeader(b);
                        break;
                    }
                    default: {
                        throw new Parser.Failure("Unable to parse SID file, unexpected version: " + version2, location);
                    }
                }
                return new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, null, sidAudioParser.singleList((String)header.get("name")), (String)header.get("author"), (String)header.get("publisher"), null, null, 0.0, 0.0, null, null, null, null, false, new Date())};
            }
            throw new Parser.Failure("Unable to parse SID file, file does seems to be incomplete (len = " + available + ").", location);
        }
        catch (IOException ex) {
            throw new Parser.Failure("Unable to read SID file header.", location, ex);
        }
    }

    private Map<String, String> parseHeader(byte[] header) {
        byte[] name = new byte[32];
        for (int i = 0; i < 32; ++i) {
            name[i] = header[i + 16];
        }
        byte[] author = new byte[32];
        for (int i = 0; i < 32; ++i) {
            author[i] = header[i + 48];
        }
        byte[] copyright = new byte[32];
        for (int i = 0; i < 32; ++i) {
            copyright[i] = header[i + 80];
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("name", new String(name, StandardCharsets.ISO_8859_1).trim());
        ret.put("author", new String(author, StandardCharsets.ISO_8859_1).trim());
        ret.put("publisher", new String(copyright, StandardCharsets.ISO_8859_1).trim());
        return ret;
    }
}

